/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog.wizard;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dbgl.gui.abstractdialog.JobWizardDialog;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Group_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.gui.thread.SearchEngineThread;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.util.SystemUtils;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class UpdateMultiProfileDialog
extends JobWizardDialog<Boolean> {
    private final List<Profile> orgProfs_;
    private final List<Profile> profs_;
    private final boolean dbversionChanged_;
    private final boolean templateReloaded_;
    private final List<Chain> metaControls_;
    private final Chain nativeCommandControl_;
    private final WebSearchEngine engine_;

    public UpdateMultiProfileDialog(Shell parent, List<Profile> orgProfs, List<Profile> profs, boolean dbversionChanged, boolean templateReloaded, List<Chain> metaControls, Chain nativeCommandControl, WebSearchEngine engine) {
        super(parent, "multiprofiledialog");
        this.orgProfs_ = orgProfs;
        this.profs_ = profs;
        this.dbversionChanged_ = dbversionChanged;
        this.templateReloaded_ = templateReloaded;
        this.metaControls_ = metaControls.stream().filter(Chain::hasChangedValue).collect(Collectors.toList());
        this.nativeCommandControl_ = nativeCommandControl.hasChangedValue() ? nativeCommandControl : null;
        this.engine_ = engine;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.multiprofile.title.edit", new Object[]{this.profs_.size()});
    }

    @Override
    protected void onShellCreated() {
        StringBuilder info = new StringBuilder();
        if (this.dbversionChanged_) {
            long count = IntStream.range(0, this.profs_.size()).filter(x -> this.profs_.get(x).getDosboxVersion().getId() != this.orgProfs_.get(x).getDosboxVersion().getId()).count();
            info.append(this.text_.get("dialog.multiprofile.dosboxversionchanged", new Object[]{this.profs_.get(0).getDosboxVersion().getTitle(), count})).append(SystemUtils.EOLN);
        }
        if (this.templateReloaded_) {
            info.append(this.text_.get("dialog.multiprofile.templateloaded")).append(SystemUtils.EOLN);
        }
        String conflicting = this.text_.get("dialog.multiprofile.conflictingvalues");
        if (this.nativeCommandControl_ != null) {
            info.append(this.nativeCommandControl_.toString()).append(": ").append((String)(this.nativeCommandControl_.conflictingValues() ? conflicting : "\"" + this.nativeCommandControl_.getInitialNativeCommandsAsString() + "\"")).append(" -> ").append("\"" + this.nativeCommandControl_.getCurrentNativeCommandsAsString() + "\"").append(SystemUtils.EOLN);
        }
        this.metaControls_.forEach(x -> info.append(x.toString()).append(": ").append((String)(x.conflictingValues() ? conflicting : "\"" + x.getInitialStringValue() + "\"")).append(" -> ").append("\"" + x.getCurrentStringValueForDisplay() + "\"").append(SystemUtils.EOLN));
        if (!this.dbversionChanged_ && !this.templateReloaded_ && this.nativeCommandControl_ == null && this.metaControls_.isEmpty()) {
            info.append(this.text_.get("dialog.multiprofile.notice.nochanges")).append(SystemUtils.EOLN);
            this.nextButton_.setEnabled(false);
        }
        Group infoGroup = Group_.on((Composite)this.shell_).layout((Layout)new GridLayout()).key("dialog.multiprofile.reviewchanges").build();
        Text_.on((Composite)infoGroup).multi().readOnly().val(info.toString()).build();
        this.addStep(infoGroup);
        this.addFinalStep("dialog.dfendimport.progress", "dialog.multiprofile.applychanges");
        this.progressBar_.setMaximum(this.profs_.size());
    }

    @Override
    protected boolean onNext(int step) {
        if (step == 1) {
            for (Profile prof : this.profs_) {
                Configuration combinedConf = prof.getCombinedConfiguration();
                this.metaControls_.forEach(x -> x.updateConfigurableByControl(prof, combinedConf));
                if (this.nativeCommandControl_ != null) {
                    this.nativeCommandControl_.updateConfigurableByControl(prof, combinedConf);
                }
                try {
                    new ProfileRepository().update(prof);
                }
                catch (SQLException e) {
                    this.log_.append(e.toString());
                    e.printStackTrace();
                }
                this.progressBar_.setSelection(this.progressBar_.getSelection() + 1);
            }
            this.progressBar_.setSelection(0);
            this.job_ = new SearchEngineThread(this.profs_, this.engine_, this.log_, this.progressBar_, this.status_);
        } else if (step == 2) {
            if (!this.job_.isEverythingOk()) {
                Mess_.on(this.shell_).key("dialog.multiprofile.error.problem").warning();
            }
            this.status_.setText(this.text_.get("dialog.multiprofile.reviewlog"));
            this.status_.pack();
            this.result_ = true;
        }
        return true;
    }
}

