/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ShortFile
implements Comparable<ShortFile> {
    private File file_;
    private String name_;

    public ShortFile(File file, String name) {
        this.file_ = file;
        this.name_ = name;
    }

    public File getFile() {
        return this.file_;
    }

    public String getName() {
        return this.name_;
    }

    public String getFormattedName() {
        return this.file_.isDirectory() ? "[" + this.name_ + "]" : this.name_;
    }

    public boolean isContainedIn(Set<ShortFile> set) {
        int idx2;
        int count = StringUtils.countMatches((CharSequence)this.file_.getPath(), (CharSequence)"\\");
        int idx1 = this.name_.indexOf(126);
        int n = idx2 = idx1 == -1 ? -1 : this.name_.indexOf(46, idx1 + 2);
        if (idx2 == -1) {
            idx2 = Math.min(this.name_.length(), 8);
        }
        for (ShortFile shortFile : set) {
            if (count != StringUtils.countMatches((CharSequence)shortFile.file_.getPath(), (CharSequence)"\\")) {
                return false;
            }
            if (idx1 != -1 && idx1 == shortFile.name_.indexOf(126)) {
                int idx3 = shortFile.name_.indexOf(46, idx1 + 2);
                if (idx3 == -1) {
                    idx3 = Math.min(shortFile.name_.length(), 8);
                }
                if (idx2 != idx3 || !this.name_.substring(0, idx2).equals(shortFile.name_.substring(0, idx2))) continue;
                return true;
            }
            if (!this.name_.equals(shortFile.name_)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.file_, this.name_);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortFile)) {
            return false;
        }
        ShortFile that = (ShortFile)obj;
        return (this.file_ == null && that.file_ == null || this.file_ != null && that.file_ != null && this.file_.equals(that.file_)) && StringUtils.equals((CharSequence)this.name_, (CharSequence)that.name_);
    }

    @Override
    public int compareTo(ShortFile o) {
        int idx2;
        int count2;
        int count1 = StringUtils.countMatches((CharSequence)o.file_.getPath(), (CharSequence)"\\");
        if (count1 != (count2 = StringUtils.countMatches((CharSequence)this.file_.getPath(), (CharSequence)"\\"))) {
            return count1 - count2;
        }
        int res = Boolean.valueOf(o.file_.isDirectory()).compareTo(this.file_.isDirectory());
        if (res != 0) {
            return res;
        }
        int idx1 = this.name_.indexOf(126);
        if (idx1 != -1 && idx1 == o.name_.indexOf(126) && (idx2 = this.name_.indexOf(46, idx1 + 2)) != -1 && idx2 == o.name_.indexOf(46, idx1 + 2)) {
            return this.name_.substring(0, idx2).compareTo(o.name_.substring(0, idx2));
        }
        return this.name_.compareTo(o.name_);
    }
}

