/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Comparator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.service.ImageService;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.graphics.ImageData;
import org.w3c.dom.Element;

public class WebProfile
implements Comparable<WebProfile> {
    private String title_;
    private String platform_;
    private String year_;
    private String url_;
    private String developerName_;
    private String publisherName_;
    private String genre_;
    private String notes_;
    private int rank_;
    private String coreGameCoverUrl_;
    private SearchEngineImageInformation[] webImages_;
    private Element xmlElementWithAllImages_;
    private int releaseId_;
    private int gameId_;
    private int platformId_;

    public String getTitle() {
        return this.title_;
    }

    public void setTitle(String title) {
        this.title_ = title;
    }

    public String getPlatform() {
        return this.platform_;
    }

    public void setPlatform(String platform) {
        this.platform_ = platform;
    }

    public String getYear() {
        return this.year_;
    }

    public void setYear(String year) {
        this.year_ = year;
    }

    public String getUrl() {
        return this.url_;
    }

    public void setUrl(String url) {
        this.url_ = url;
    }

    public String getScreenshotsUrl() {
        return this.url_ + "/screenshots";
    }

    public String getCoverArtUrl() {
        return this.url_ + "/covers";
    }

    public String getCoreGameCoverUrl() {
        return this.coreGameCoverUrl_;
    }

    public String getCoreGameCoverUrlWithoutPathPrefix() {
        int index = StringUtils.ordinalIndexOf((CharSequence)this.coreGameCoverUrl_, (CharSequence)"/", (int)3);
        if (index > 0) {
            return this.coreGameCoverUrl_.substring(index + 1);
        }
        return this.coreGameCoverUrl_;
    }

    public void setCoreGameCoverUrl(String coreGameCoverUrl) {
        this.coreGameCoverUrl_ = coreGameCoverUrl;
    }

    public ImageData getWebImage(int i) throws IOException {
        block15: {
            if (this.webImages_[i].getData() == null) {
                HttpURLConnection conn = WebSearchEngine.getHttpURLConnection(this.webImages_[i].getUrl());
                try (InputStream is = conn.getInputStream();){
                    if (conn.getContentType().equalsIgnoreCase("image/gif")) {
                        ImageData imgData = ImageService.getImageDataUsingGifDecoder(is);
                        if (imgData != null) {
                            this.webImages_[i].setData(imgData);
                            break block15;
                        }
                        HttpURLConnection conn2 = WebSearchEngine.getHttpURLConnection(this.webImages_[i].getUrl());
                        try (InputStream is2 = conn2.getInputStream();){
                            this.webImages_[i].setData(new ImageData(is2));
                            break block15;
                        }
                    }
                    this.webImages_[i].setData(new ImageData(is));
                }
            }
        }
        return this.webImages_[i].getData();
    }

    public SearchEngineImageInformation[] getWebImages() {
        return (SearchEngineImageInformation[])this.webImages_.clone();
    }

    public void setWebImages(SearchEngineImageInformation[] webImages) {
        this.webImages_ = (SearchEngineImageInformation[])webImages.clone();
    }

    public String getDeveloperName() {
        return this.developerName_;
    }

    public void setDeveloperName(String developerName) {
        this.developerName_ = developerName;
    }

    public String getPublisherName() {
        return this.publisherName_;
    }

    public void setPublisherName(String publisherName) {
        this.publisherName_ = publisherName;
    }

    public String getGenre() {
        return this.genre_;
    }

    public void setGenre(String genre) {
        this.genre_ = genre;
    }

    public String getNotes() {
        return this.notes_;
    }

    public void setNotes(String notes) {
        this.notes_ = notes;
    }

    public int getRank() {
        return this.rank_;
    }

    public void setRank(int rank) {
        this.rank_ = rank;
    }

    public int getReleaseId() {
        return this.releaseId_;
    }

    public void setReleaseId(int releaseId) {
        this.releaseId_ = releaseId;
    }

    public int getGameId() {
        return this.gameId_;
    }

    public void setGameId(int gameId) {
        this.gameId_ = gameId;
    }

    public int getPlatformId() {
        return this.platformId_;
    }

    public void setPlatformId(int platformId) {
        this.platformId_ = platformId;
    }

    public Element getXmlElementWithAllImages() {
        return this.xmlElementWithAllImages_;
    }

    public void setXmlElementWithAllImages(Element xmlElementWithAllImages) {
        this.xmlElementWithAllImages_ = xmlElementWithAllImages;
    }

    public int hashCode() {
        return Objects.hash(this.platform_, this.title_);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebProfile otherProfile = (WebProfile)obj;
        return this.platform_.equalsIgnoreCase(otherProfile.platform_) && this.title_.equalsIgnoreCase(otherProfile.title_);
    }

    @Override
    public int compareTo(WebProfile otherProfile) {
        if (otherProfile.platform_.equalsIgnoreCase(this.platform_)) {
            return this.title_.compareToIgnoreCase(otherProfile.title_);
        }
        return this.platform_.compareToIgnoreCase(otherProfile.platform_);
    }

    public String toString() {
        return this.title_ + "@" + this.platform_;
    }

    public static final class byPlatform
    implements Comparator<WebProfile> {
        @Override
        public int compare(WebProfile prof1, WebProfile prof2) {
            return prof1.platform_.compareToIgnoreCase(prof2.platform_);
        }
    }

    public static final class byYear
    implements Comparator<WebProfile> {
        @Override
        public int compare(WebProfile prof1, WebProfile prof2) {
            return prof1.year_.compareToIgnoreCase(prof2.year_);
        }
    }

    public static final class byTitle
    implements Comparator<WebProfile> {
        @Override
        public int compare(WebProfile prof1, WebProfile prof2) {
            return prof1.title_.compareToIgnoreCase(prof2.title_);
        }
    }
}

