/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf.mount;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.FileLocation;
import org.dbgl.model.conf.mount.Mount;
import org.dbgl.service.FileLocationService;
import org.dbgl.util.FilesUtils;

public class DirMount
extends Mount {
    private FileLocation path_ = null;
    private String lowlevelCD_ = "";
    private String useCD_ = "";
    private String freesize_ = "";

    public File getPath() {
        return this.path_.getFile();
    }

    public File getCanonicalPath() {
        return this.path_.getCanonicalFile();
    }

    public void setPath(String location) {
        this.path_ = new FileLocation(location, FileLocationService.getInstance().dosrootRelative());
    }

    public String getLowlevelCD() {
        return this.lowlevelCD_;
    }

    public void setLowlevelCD(String lowlevelCD) {
        this.lowlevelCD_ = lowlevelCD;
    }

    public String getUseCD() {
        return this.useCD_;
    }

    public void setUseCD(String useCD) {
        this.useCD_ = useCD;
    }

    public String getFreesize() {
        return this.freesize_;
    }

    public void setFreesize(String freesize) {
        this.freesize_ = freesize;
    }

    @Override
    public File canBeUsedFor(FileLocation hostFile) {
        if (!FilesUtils.areRelated(this.getCanonicalPath(), hostFile.getCanonicalFile())) {
            return null;
        }
        return FilesUtils.makeRelativeTo(this.getCanonicalPath(), hostFile.getCanonicalFile());
    }

    @Override
    public void setBaseDir(File baseDir) {
        this.setPath(FilesUtils.concat(baseDir, this.getPath()));
    }

    @Override
    public void migrate(FileLocation from, FileLocation to) {
        this.path_ = FilesUtils.migrate(this.path_, from, to);
    }

    @Override
    public String getPathString() {
        return this.getPath().getPath();
    }

    @Override
    public String toString(boolean forUI) {
        StringBuilder result = new StringBuilder();
        result.append("mount ").append(this.drive_).append(" \"").append(this.path_.getFile()).append('\"');
        if (StringUtils.isNotBlank((CharSequence)this.lowlevelCD_)) {
            result.append(" -").append(this.lowlevelCD_);
        }
        if (StringUtils.isNotBlank((CharSequence)this.useCD_)) {
            result.append(" -usecd ").append(this.useCD_);
        }
        if (StringUtils.isNotBlank((CharSequence)this.freesize_)) {
            result.append(" -freesize ").append(this.freesize_);
        }
        return this.extString(result, forUI);
    }
}

