/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf.mount;

import java.io.File;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.FileLocation;
import org.dbgl.model.conf.mount.Mount;
import org.dbgl.service.FileLocationService;
import org.dbgl.util.FilesUtils;

public class ImageMount
extends Mount {
    private FileLocation[] imgPath_ = new FileLocation[0];
    private String fs_ = "";
    private String size_ = "";

    public String getFs() {
        return this.fs_;
    }

    public void setFs(String fs) {
        this.fs_ = fs;
    }

    public String getSize() {
        return this.size_;
    }

    public void setSize(String size) {
        this.size_ = size;
    }

    public File[] getImgPaths() {
        return (File[])Stream.of(this.imgPath_).map(FileLocation::getFile).toArray(File[]::new);
    }

    public File[] getCanonicalImgPaths() {
        return (File[])Stream.of(this.imgPath_).map(FileLocation::getCanonicalFile).toArray(File[]::new);
    }

    public String[] getImgPathStrings() {
        return (String[])Stream.of(this.imgPath_).map(x -> x.getFile().getPath()).toArray(String[]::new);
    }

    public void setImgPaths(String[] locations) {
        this.imgPath_ = new FileLocation[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            this.imgPath_[i] = new FileLocation(locations[i], FileLocationService.getInstance().dosrootRelative());
        }
    }

    public boolean matchesImgPath(String location) {
        if (this.imgPath_.length == 0) {
            return false;
        }
        return this.imgPath_[0].getFile().getPath().equals(location);
    }

    @Override
    public void setMountAs(String mountAs) {
        super.setMountAs("cdrom".equalsIgnoreCase(mountAs) ? "iso" : mountAs);
    }

    @Override
    public File canBeUsedFor(FileLocation hostFile) {
        if (!FilesUtils.areRelated(this.getCanonicalImgPaths()[0], hostFile.getCanonicalFile())) {
            return null;
        }
        return FilesUtils.makeRelativeTo(this.getCanonicalImgPaths()[0], hostFile.getCanonicalFile());
    }

    @Override
    public void setBaseDir(File baseDir) {
        this.setImgPaths((String[])Stream.of(this.getImgPathStrings()).map(x -> FilesUtils.concat(baseDir, x)).toArray(String[]::new));
    }

    @Override
    public void migrate(FileLocation from, FileLocation to) {
        this.imgPath_ = (FileLocation[])Stream.of(this.imgPath_).map(x -> FilesUtils.migrate(x, from, to)).toArray(FileLocation[]::new);
    }

    @Override
    public String getPathString() {
        return StringUtils.join((Object[])this.getImgPathStrings(), (String)", ");
    }

    @Override
    public String toString(boolean forUI) {
        StringBuilder result = new StringBuilder();
        result.append("imgmount ").append(this.drive_);
        for (String imgPath : this.getImgPathStrings()) {
            result.append(" \"").append(imgPath).append('\"');
        }
        if (StringUtils.isNotBlank((CharSequence)this.fs_)) {
            result.append(" -fs ").append(this.fs_);
        }
        if (StringUtils.isNotBlank((CharSequence)this.size_)) {
            result.append(" -size ").append(this.size_);
        }
        return this.extString(result, forUI);
    }
}

