/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.fat;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.util.fat.FatDirectoryEntry;

public abstract class AbstractDirectory {
    private final List<FatDirectoryEntry> entries_ = new ArrayList<FatDirectoryEntry>();
    private final int capacity_;
    private final boolean isRoot_;

    protected AbstractDirectory(int capacity, boolean isRoot) {
        this.capacity_ = capacity;
        this.isRoot_ = isRoot;
    }

    protected abstract void read(ByteBuffer var1) throws IOException;

    public final FatDirectoryEntry getEntry(int idx) {
        return this.entries_.get(idx);
    }

    public final int getEntryCount() {
        return this.entries_.size();
    }

    public final boolean isRoot() {
        return this.isRoot_;
    }

    public final void read() throws IOException {
        FatDirectoryEntry e;
        ByteBuffer data = ByteBuffer.allocate(this.capacity_ * 32);
        this.read(data);
        ((Buffer)data).flip();
        for (int i = 0; i < this.capacity_ && (e = FatDirectoryEntry.read(data)) != null; ++i) {
            if (e.isVolumeLabel()) {
                if (this.isRoot_) continue;
                throw new IOException("volume label in non-root directory");
            }
            this.entries_.add(e);
        }
    }
}

