/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.json.JSONArray;
import org.json.JSONObject;

public class MobyGamesSearchEngine
extends WebSearchEngine {
    static final String MOBY_GAMES_HOST_NAME = "www.mobygames.com";
    static final String MOBY_GAMES_CDN_URL = "cdn.mobygames.com";
    static final String MOBY_GAMES_API_URL = "api.mobygames.com/v1";
    private static final int RESULTS_PER_PAGE = 100;
    private static Long lastApiRequest_;

    private MobyGamesSearchEngine() {
    }

    public static WebSearchEngine getInstance() {
        return SearchEngineHolder.instance_;
    }

    @Override
    public String getIcon() {
        return "moby.png";
    }

    @Override
    public String getName() {
        return "MobyGames";
    }

    @Override
    public String getSimpleName() {
        return "mobygames";
    }

    @Override
    public boolean available() {
        return true;
    }

    @Override
    public void updatePlatforms(String[] platforms) throws IOException {
        ArrayList<Integer> platformIds = new ArrayList<Integer>();
        if (platforms.length > 0) {
            String url = "https://api.mobygames.com/v1/platforms";
            JSONObject gameObj = new JSONObject(MobyGamesSearchEngine.getApiResponse(url));
            for (JSONObject platformObj : gameObj.getJSONArray("platforms")) {
                String name = platformObj.getString("platform_name");
                if (!Stream.of(platforms).anyMatch(x -> x.equalsIgnoreCase(name))) continue;
                platformIds.add(platformObj.getInt("platform_id"));
            }
        }
        SettingsService.getInstance().setValue(this.getSimpleName(), "platform_filter_ids", StringUtils.join(platformIds, (char)' '));
    }

    protected static String getApiResponse(String url) throws IOException {
        long waiting;
        if (lastApiRequest_ != null && (waiting = 1000L - (new Date().getTime() - lastApiRequest_)) > 0L) {
            try {
                Thread.sleep(waiting);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        String key = SettingsService.getInstance().getValue("mobygames", "api_key");
        url = (String)url + (((String)url).contains("?") ? (char)'&' : '?') + "api_key=" + URLEncoder.encode(key, StandardCharsets.UTF_8);
        StringBuilder response = new StringBuilder(8192);
        HttpURLConnection conn = MobyGamesSearchEngine.getHttpURLConnection((String)url);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Accept", "application/json");
        int responseCode = conn.getResponseCode();
        if (responseCode == 429) {
            throw new IOException(TextService.getInstance().get("dialog.profile.mobygames.error.toomanyrequests"));
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            String str;
            while ((str = in.readLine()) != null) {
                response.append(str);
            }
        }
        lastApiRequest_ = new Date().getTime();
        return response.toString();
    }

    @Override
    public List<WebProfile> getEntries(String title, String[] platforms) throws IOException {
        TreeSet<WebProfile> allEntries = new TreeSet<WebProfile>();
        String baseUrl = "https://api.mobygames.com/v1/games?title=" + URLEncoder.encode(MobyGamesSearchEngine.prepareSearchTerm(title), StandardCharsets.UTF_8);
        int[] platformIds = SettingsService.getInstance().getIntValues(this.getSimpleName(), "platform_filter_ids");
        if (platformIds.length == 0) {
            allEntries.addAll(this.getAllPagedEntries(baseUrl, -1));
        } else {
            for (int platformId : platformIds) {
                allEntries.addAll(this.getAllPagedEntries(baseUrl + "&platform=" + platformId, platformId));
            }
        }
        return new ArrayList<WebProfile>(allEntries);
    }

    private Set<WebProfile> getAllPagedEntries(String baseUrl, int platformId) throws IOException {
        TreeSet<WebProfile> allEntries = new TreeSet<WebProfile>();
        do {
            String url = baseUrl + "&limit=100&offset=" + allEntries.size();
            String json = MobyGamesSearchEngine.getApiResponse(url);
            for (JSONObject gameObj : new JSONObject(json).getJSONArray("games")) {
                JSONObject platformObj;
                WebProfile gameEntry = new WebProfile();
                gameEntry.setGameId(gameObj.getInt("game_id"));
                gameEntry.setTitle(gameObj.getString("title"));
                gameEntry.setUrl(gameObj.getString("moby_url"));
                gameEntry.setGenre(this.getGenre(gameObj));
                Iterator platformIt = gameObj.getJSONArray("platforms").iterator();
                if (platformId == -1) {
                    platformObj = (JSONObject)platformIt.next();
                    gameEntry.setPlatformId(platformObj.getInt("platform_id"));
                    gameEntry.setPlatform(platformObj.getString("platform_name"));
                    gameEntry.setYear(platformObj.getString("first_release_date"));
                } else {
                    gameEntry.setPlatformId(platformId);
                    while (platformIt.hasNext()) {
                        platformObj = (JSONObject)platformIt.next();
                        if (platformObj.getInt("platform_id") != platformId) continue;
                        gameEntry.setPlatform(platformObj.getString("platform_name"));
                        gameEntry.setYear(platformObj.getString("first_release_date"));
                    }
                }
                allEntries.add(gameEntry);
            }
        } while (!allEntries.isEmpty() && allEntries.size() % 100 == 0);
        return allEntries;
    }

    @Override
    public WebProfile getEntryDetailedInformation(WebProfile entry) throws IOException {
        String url = "https://api.mobygames.com/v1/games/" + entry.getGameId();
        JSONObject gameObj = new JSONObject(MobyGamesSearchEngine.getApiResponse(url));
        entry.setGenre(this.getGenre(gameObj));
        entry.setRank((int)(gameObj.optDouble("moby_score") * 10.0));
        entry.setNotes(MobyGamesSearchEngine.unescapeHtml(MobyGamesSearchEngine.removeAllTags(gameObj.getString("description"))));
        String coreCoverUrl = gameObj.getJSONObject("sample_cover").getString("image");
        if (!coreCoverUrl.startsWith("https://cdn.mobygames.com/screenshots/")) {
            entry.setCoreGameCoverUrl(coreCoverUrl);
        }
        url = url + "/platforms/" + entry.getPlatformId();
        JSONObject gameOnPlatformObj = new JSONObject(MobyGamesSearchEngine.getApiResponse(url));
        LinkedHashSet<String> publishers = new LinkedHashSet<String>();
        LinkedHashSet<String> developers = new LinkedHashSet<String>();
        JSONArray releasesArr = gameOnPlatformObj.getJSONArray("releases");
        for (JSONObject releaseObj : releasesArr) {
            JSONArray companiesArr = releaseObj.getJSONArray("companies");
            for (JSONObject companyObj : companiesArr) {
                if (companyObj.getString("role").equals("Published by")) {
                    publishers.add(companyObj.getString("company_name"));
                    continue;
                }
                if (!companyObj.getString("role").equals("Developed by")) continue;
                developers.add(companyObj.getString("company_name"));
            }
        }
        entry.setPublisherName(StringUtils.join(publishers, (String)", "));
        entry.setDeveloperName(StringUtils.join(developers, (String)", "));
        return entry;
    }

    private String getGenre(JSONObject gameObj) {
        ArrayList<String> genres = new ArrayList<String>();
        for (JSONObject genresObj : gameObj.getJSONArray("genres")) {
            if (!genresObj.getString("genre_category").equals("Basic Genres")) continue;
            genres.add(genresObj.getString("genre_name"));
        }
        return StringUtils.join(genres, (String)", ");
    }

    @Override
    public SearchEngineImageInformation[] getEntryImages(WebProfile entry, int coverArtMax, int screenshotsMax, boolean forceAllRegionsCoverArt) throws IOException {
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        if (coverArtMax > 0) {
            result.addAll(MobyGamesSearchEngine.getEntryCoverArtInformation(entry, coverArtMax, forceAllRegionsCoverArt));
        }
        if (screenshotsMax > 0) {
            result.addAll(MobyGamesSearchEngine.getEntryScreenshotInformation(entry, screenshotsMax));
        }
        entry.setWebImages(result.toArray(new SearchEngineImageInformation[0]));
        return entry.getWebImages();
    }

    private static List<SearchEngineImageInformation> getEntryScreenshotInformation(WebProfile entry, int max) throws IOException {
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        String url = "https://api.mobygames.com/v1/games/" + entry.getGameId() + "/platforms/" + entry.getPlatformId() + "/screenshots";
        JSONObject obj = new JSONObject(MobyGamesSearchEngine.getApiResponse(url));
        Iterator ssIt = obj.getJSONArray("screenshots").iterator();
        while (ssIt.hasNext() && result.size() < max) {
            JSONObject ssObj = (JSONObject)ssIt.next();
            result.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.SCREENSHOT, ssObj.getString("image"), ssObj.getString("caption")));
        }
        return result;
    }

    private static List<SearchEngineImageInformation> getEntryCoverArtInformation(WebProfile entry, int max, boolean forceAllRegionsCoverArt) throws IOException {
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        String url = "https://api.mobygames.com/v1/games/" + entry.getGameId() + "/platforms/" + entry.getPlatformId() + "/covers";
        JSONObject obj = new JSONObject(MobyGamesSearchEngine.getApiResponse(url));
        for (JSONObject cgObj : obj.getJSONArray("cover_groups")) {
            JSONArray coversArr = cgObj.getJSONArray("covers");
            Iterator coversIt = coversArr.iterator();
            while (coversIt.hasNext() && result.size() < max) {
                JSONObject coverObj = (JSONObject)coversIt.next();
                String descr = StringUtils.join((Object[])new String[]{coverObj.getString("scan_of"), coverObj.optString("comments")}, (char)' ').trim();
                result.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.COVER_ART, coverObj.getString("image"), descr));
            }
            if (forceAllRegionsCoverArt) continue;
            break;
        }
        return result;
    }

    private static class SearchEngineHolder {
        private static WebSearchEngine instance_ = new MobyGamesSearchEngine();

        private SearchEngineHolder() {
        }
    }
}

