/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.service.ImageService;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.graphics.ImageData;

public class PouetSearchEngine
extends WebSearchEngine {
    private static final String HTML_MULTIPLE_RESULT_MARKER_START = "<span class='typeiconlist'>";
    private static final String HTML_NEXT_RESULT_MARKER_START = "<span class='typeiconlist'>";
    private static final String HTML_GAME_END_MARKER = "</div></td></tr>";
    private static final String HTML_PLATFORM_MARKER = "<span class='platformi ";
    private static final String HOST_NAME = "www.pouet.net";

    private PouetSearchEngine() {
    }

    public static WebSearchEngine getInstance() {
        return SearchEngineHolder.instance_;
    }

    @Override
    public String getIcon() {
        return "pouet.png";
    }

    @Override
    public String getName() {
        return "Pou\u00ebt.net";
    }

    @Override
    public String getSimpleName() {
        return "pouet";
    }

    @Override
    public boolean available() {
        return true;
    }

    @Override
    public List<WebProfile> getEntries(String title, String[] platforms) throws IOException {
        int pages = 1;
        ArrayList<WebProfile> allEntries = new ArrayList<WebProfile>();
        for (int pageIdx = 0; pageIdx < pages; ++pageIdx) {
            String content = PouetSearchEngine.getResponseContent("https://www.pouet.net/search.php?type=prod&what=" + URLEncoder.encode(PouetSearchEngine.prepareSearchTerm(title), StandardCharsets.UTF_8) + "&page=" + (pageIdx + 1), StandardCharsets.UTF_8);
            if (pageIdx == 0) {
                pages = PouetSearchEngine.getPages(content);
            }
            if (pages > 0) {
                allEntries.addAll(PouetSearchEngine.extractEntries(content));
                continue;
            }
            if (content.indexOf("<div id='prodpagecontainer'>") == -1) continue;
            allEntries.addAll(PouetSearchEngine.extractSingleEntry(content));
        }
        return PouetSearchEngine.filterEntries(platforms, allEntries);
    }

    private static int getPages(String htmlChunk) {
        int i = htmlChunk.indexOf("<select name='page'>");
        if (i == -1) {
            return 0;
        }
        int j = htmlChunk.indexOf("</select>", i);
        String pages = htmlChunk.substring(i, j);
        int amountOfPages = 0;
        i = 0;
        while ((i = pages.indexOf("<option", i + 7)) != -1) {
            ++amountOfPages;
        }
        return amountOfPages;
    }

    private static List<WebProfile> extractEntries(String html) {
        ArrayList<WebProfile> allEntries = new ArrayList<WebProfile>();
        int gameMatchEntryIndex = (html = html.replace("\\\\\"", "\"")).indexOf("<span class='typeiconlist'>");
        if (gameMatchEntryIndex != -1) {
            gameMatchEntryIndex += "<span class='typeiconlist'>".length();
        }
        while (gameMatchEntryIndex != -1) {
            int rank;
            String category = StringUtils.capitalize((String)PouetSearchEngine.extractNextContent(html, gameMatchEntryIndex, "<span ", "</span>"));
            int startPlatformIdx = html.indexOf("<span class='platformiconlist'>", gameMatchEntryIndex);
            int gameTitleIdx = html.indexOf("<span class='prod'>", gameMatchEntryIndex);
            String gameTitleData = PouetSearchEngine.extractNextContent(html, gameTitleIdx, "<a ", "</a>");
            String gameTitle = StringUtils.capitalize((String)PouetSearchEngine.unescapeHtml(PouetSearchEngine.removeAllTags(gameTitleData)));
            String url = PouetSearchEngine.extractNextHrefContentSingleQuotes(html, gameTitleIdx);
            url = PouetSearchEngine.absoluteUrl(HOST_NAME, url);
            gameMatchEntryIndex = html.indexOf("<td>", gameMatchEntryIndex);
            String developerName = PouetSearchEngine.extractNextContent(html, gameMatchEntryIndex + "<td>".length(), "<a ", "</a>");
            developerName = StringUtils.capitalize((String)developerName);
            String year = StringUtils.right((String)PouetSearchEngine.extractNextContent(html, gameMatchEntryIndex, "<td class='date'>", "</td>"), (int)4);
            try {
                String span = PouetSearchEngine.extractNextContent(html, gameMatchEntryIndex, "<td class='votesavg'>", "</td>");
                String score = PouetSearchEngine.extractNextContent(span, 0, "<span ", "</span>");
                rank = (int)((Double.parseDouble(score) + 1.0) * 50.0);
            }
            catch (NumberFormatException e) {
                rank = 0;
            }
            String details = html.substring(startPlatformIdx, gameTitleIdx);
            int platformIdx = details.indexOf(HTML_PLATFORM_MARKER);
            while (platformIdx != -1) {
                String platform = PouetSearchEngine.extractNextContent(details, platformIdx, "<span ", "</span>");
                WebProfile gameEntry = new WebProfile();
                gameEntry.setTitle(gameTitle);
                gameEntry.setUrl(url);
                gameEntry.setPlatform(platform);
                gameEntry.setPublisherName("");
                gameEntry.setDeveloperName(developerName);
                gameEntry.setYear(year);
                gameEntry.setGenre(category);
                gameEntry.setRank(rank);
                gameEntry.setNotes("");
                allEntries.add(gameEntry);
                platformIdx = details.indexOf(HTML_PLATFORM_MARKER, platformIdx + 1);
            }
            int endIdx = html.indexOf(HTML_GAME_END_MARKER, gameTitleIdx);
            gameMatchEntryIndex = html.indexOf("<span class='typeiconlist'>", endIdx + HTML_GAME_END_MARKER.length());
            if (gameMatchEntryIndex == -1) continue;
            gameMatchEntryIndex += "<span class='typeiconlist'>".length();
        }
        return allEntries;
    }

    private static List<WebProfile> extractSingleEntry(String html) {
        int rank;
        ArrayList<WebProfile> allEntries = new ArrayList<WebProfile>();
        int canonicalIndex = html.indexOf("<link rel=\"canonical\"");
        String url = PouetSearchEngine.extractNextHrefContent(html, canonicalIndex).replace("http://", "https://");
        int titleIdx = html.indexOf("<span id='title'>", canonicalIndex);
        String gameTitleData = PouetSearchEngine.extractNextContent(html, titleIdx, "<span id='prod-title'>", "</span>");
        String title = StringUtils.capitalize((String)PouetSearchEngine.unescapeHtml(PouetSearchEngine.removeAllTags(gameTitleData)));
        String developerName = html.indexOf("</span> by ", titleIdx) != -1 ? StringUtils.capitalize((String)PouetSearchEngine.extractNextContent(html, titleIdx, "<a ", "</a>")) : "";
        int platformIdx = html.indexOf("<td>platform :</td>", titleIdx);
        int categoryIdx = html.indexOf("<td>type :</td>", platformIdx);
        String category = StringUtils.capitalize((String)PouetSearchEngine.extractNextContent(html, categoryIdx, "<span ", "</span>"));
        int yearIdx = html.indexOf("<td>release date :</td>", categoryIdx);
        String dateValue = PouetSearchEngine.extractNextContent(html, yearIdx + 24, "<td>", "</td>");
        String year = !dateValue.contains("n/a") ? StringUtils.right((String)dateValue, (int)4) : "";
        int scoreStartIdx = html.indexOf("<ul id='avgstats'>", yearIdx);
        try {
            String score = PouetSearchEngine.extractNextContent(html, scoreStartIdx, "<li", "</li>");
            int l = score.indexOf("</li>");
            if (l != -1) {
                score = score.substring(0, l);
            }
            rank = (int)((Double.parseDouble(score) + 1.0) * 50.0);
        }
        catch (NumberFormatException e) {
            rank = 0;
        }
        String details = html.substring(platformIdx, categoryIdx);
        platformIdx = details.indexOf("<span class='platform ");
        while (platformIdx != -1) {
            String platform = PouetSearchEngine.extractNextContent(details, platformIdx, "<span ", "</span>");
            WebProfile gameEntry = new WebProfile();
            gameEntry.setTitle(title);
            gameEntry.setUrl(url);
            gameEntry.setPlatform(platform);
            gameEntry.setPublisherName("");
            gameEntry.setDeveloperName(developerName);
            gameEntry.setYear(year);
            gameEntry.setGenre(category);
            gameEntry.setRank(rank);
            gameEntry.setNotes("");
            allEntries.add(gameEntry);
            platformIdx = details.indexOf("<span class='platform ", platformIdx + 1);
        }
        return allEntries;
    }

    @Override
    public WebProfile getEntryDetailedInformation(WebProfile entry) throws IOException {
        return entry;
    }

    @Override
    public SearchEngineImageInformation[] getEntryImages(WebProfile entry, int coverArtMax, int screenshotsMax, boolean forceAllRegionsCoverArt) throws IOException {
        String html = PouetSearchEngine.getResponseContent(entry.getUrl(), StandardCharsets.ISO_8859_1);
        int imgMatchEntryIndex = html.indexOf("<td rowspan='3' id='screenshot'><img src=");
        if (imgMatchEntryIndex == -1) {
            entry.setWebImages(new SearchEngineImageInformation[0]);
        } else {
            String imgUrl = PouetSearchEngine.absoluteUrl(HOST_NAME, PouetSearchEngine.extractNextSrcContentSingleQuotes(html, imgMatchEntryIndex));
            String imgDescription = this.getSimpleName();
            if (imgUrl.toLowerCase().endsWith(".gif")) {
                try (InputStream is = PouetSearchEngine.getHttpURLConnection(imgUrl).getInputStream();){
                    ImageData[] images = ImageService.getAnimatedImageData(is);
                    int nrOfImages = Math.min(images.length, Math.max(screenshotsMax, 0));
                    SearchEngineImageInformation[] result = new SearchEngineImageInformation[nrOfImages];
                    for (int i = 0; i < nrOfImages; ++i) {
                        result[i] = new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.SCREENSHOT, imgUrl, imgDescription);
                        result[i].setData(images[i]);
                    }
                    entry.setWebImages(result);
                }
            } else {
                entry.setWebImages(new SearchEngineImageInformation[]{new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.SCREENSHOT, imgUrl, imgDescription)});
            }
        }
        return entry.getWebImages();
    }

    private static class SearchEngineHolder {
        private static WebSearchEngine instance_ = new PouetSearchEngine();

        private SearchEngineHolder() {
        }
    }
}

