package org.dbgl.model;

import java.io.File;
import java.util.List;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;


public class ExpGame extends Profile {
    
    private String fullConfig;
    private String incrConfig;
    private File gameDir;
    
    private final static XPathFactory xfactory = XPathFactory.newInstance();
    private final static XPath xPath = xfactory.newXPath();

    
    public ExpGame(int id, String confFile, String captures, String setup, String fc, String ic, File gd, Profile prof) {
        super(id, confFile, captures, prof);
        this.fullConfig = fc;
        this.incrConfig = ic;
        this.setup = setup;
        this.gameDir = gd;
    }

    public ExpGame(Node n, Set<DosboxVersion> dbSet) throws XPathExpressionException {
    	super(xPath.evaluate("title", n), Boolean.valueOf(xPath.evaluate("meta-info/favorite", n)));
        
        this.developerName = xPath.evaluate("meta-info/developer", n);
        this.publisherName = xPath.evaluate("meta-info/publisher", n);
        this.year = xPath.evaluate("meta-info/year", n);
        this.genre = xPath.evaluate("meta-info/genre", n);
        this.status = xPath.evaluate("meta-info/status", n);
        this.notes = xPath.evaluate("meta-info/notes", n);
        this.customString = new String[] { xPath.evaluate("meta-info/custom1", n),
                xPath.evaluate("meta-info/custom2", n), xPath.evaluate("meta-info/custom3", n),
                xPath.evaluate("meta-info/custom4", n), xPath.evaluate("meta-info/custom5", n),
                xPath.evaluate("meta-info/custom6", n), xPath.evaluate("meta-info/custom7", n),
                xPath.evaluate("meta-info/custom8", n) };
        this.customInt = new int[] { Integer.valueOf(xPath.evaluate("meta-info/custom9", n)),
                Integer.valueOf(xPath.evaluate("meta-info/custom10", n)) };
        this.link = new String[] { xPath.evaluate("meta-info/link1", n), xPath.evaluate("meta-info/link2", n),
                xPath.evaluate("meta-info/link3", n), xPath.evaluate("meta-info/link4", n) };
        this.setup = xPath.evaluate("dosbox/setup", n);
        this.setupParams = xPath.evaluate("dosbox/setup-parameters", n);
        this.captures = xPath.evaluate("dosbox/captures", n);
        this.gameDir = new File(xPath.evaluate("dosbox/game-dir", n));
        for (DosboxVersion db : dbSet) {
            String dbTitle = xPath.evaluate("dosbox/title", n);
            String dbVersion = xPath.evaluate("dosbox/version", n);
            if (db.getVersion().equals(dbVersion) && db.getTitle().equals(dbTitle))
                this.dbversionId = db.getId();
        }
        this.fullConfig = xPath.evaluate("full-configuration", n);
        this.incrConfig = xPath.evaluate("incremental-configuration", n);
    }

    public String getFullConfig() {
        return fullConfig;
    }

    public File getGameDir() {
        return gameDir;
    }

    public void setGameDir(File gameDir) {
        this.gameDir = gameDir;
    }

    public String getIncrConfig() {
        return incrConfig;
    }

    public void setDbversionId(int id) {
        this.dbversionId = id;
    }

    public Element getXml(Document xmldoc, List<DosboxVersion> dbversionsList) {
        Element el = xmldoc.createElement("profile");
        XmlUtils.addElement(xmldoc, el, "title", getTitle());
        Element meta = xmldoc.createElement("meta-info");
        XmlUtils.addElement(xmldoc, meta, "developer", getDeveloperName());
        XmlUtils.addElement(xmldoc, meta, "publisher", getPublisherName());
        XmlUtils.addElement(xmldoc, meta, "year", getYear());
        XmlUtils.addElement(xmldoc, meta, "genre", getGenre());
        XmlUtils.addElement(xmldoc, meta, "status", getStatus());
        XmlUtils.addElement(xmldoc, meta, "favorite", String.valueOf(isDefault()));
        XmlUtils.addCDataElement(xmldoc, meta, "notes", getNotes());
        for (int i = 0; i < 8; i++)
            XmlUtils.addElement(xmldoc, meta, "custom" + (i + 1), getCustomString(i));
        for (int i = 0; i < 2; i++)
            XmlUtils.addElement(xmldoc, meta, "custom" + (i + 9), String.valueOf(getCustomInt(i)));
        for (int i = 0; i < 4; i++)
            XmlUtils.addElement(xmldoc, meta, "link" + (i + 1), getLink(i));
        el.appendChild(meta);
        XmlUtils.addCDataElement(xmldoc, el, "full-configuration", fullConfig);
        XmlUtils.addCDataElement(xmldoc, el, "incremental-configuration", incrConfig);
        int index = DosboxVersion.findById(dbversionsList, getDbversionId());
        DosboxVersion dbv = dbversionsList.get(index);
        Element dosbox = xmldoc.createElement("dosbox");
        XmlUtils.addElement(xmldoc, dosbox, "title", dbv.getValue());
        XmlUtils.addElement(xmldoc, dosbox, "version", dbv.getVersion());
        XmlUtils.addElement(xmldoc, dosbox, "captures", getCaptures());
        XmlUtils.addElement(xmldoc, dosbox, "setup", PlatformUtils.toDosboxPath(getSetup()));
        XmlUtils.addElement(xmldoc, dosbox, "setup-parameters", getSetupParameters());
        XmlUtils.addElement(xmldoc, dosbox, "game-dir", PlatformUtils.toDosboxPath(gameDir.getPath()));
        el.appendChild(dosbox);
        return el;
    }
}
