package org.dbgl.test;

import static org.junit.Assert.assertEquals;
import java.io.IOException;
import java.util.List;
import org.dbgl.model.MobyProfile;
import org.dbgl.util.MobyGamesUtils;
import org.junit.Test;


public class MobyGamesTest {

	@Test
    public void testGetEntries() {
		try {
			List<MobyProfile> entries1 = MobyGamesUtils.getEntries("doom", new String[] {"dos", "pc booter"});
			assertEquals(27, entries1.size());
			
			List<MobyProfile> entries2 = MobyGamesUtils.getEntries("mario", new String[] {"dos", "pc booter"});
			assertEquals(6, entries2.size());
			
			List<MobyProfile> entries3 = MobyGamesUtils.getEntries("noresultsplease", new String[] {"dos", "pc booter"});
			assertEquals(0, entries3.size());
		} catch (IOException e) {
			e.printStackTrace();
		}
    }
}
