/*
 *  Copyright (C) 2006-2010  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.model.conf;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.dbgl.util.PlatformUtils;


public final class Settings extends Conf {

    private static final String SAMPLE_RATES = "8000 11025 16000 22050 32000 44100 48000 49716";
    private static final String BASE_ADDRS = "220 240 260 280 2a0 2c0 2e0 300";
    private static final String IRQS = "3 5 7 9 10 11 12";
    private static final String DMAS = "0 1 3 5 6 7";
    
    private static Locale locale;
    private static ResourceBundle mes;
    private static MessageFormat formatter;


    private Settings() {
    	super(defaultSettings(), new File("settings.conf"), System.err);
        
        locale = new Locale(getSettings().getValue("locale", "language"), getSettings().getValue("locale", "country"));
        try {
        	mes = ResourceBundle.getBundle("plugins/i18n/MessagesBundle", locale);
        } catch (MissingResourceException me) {
        	mes = ResourceBundle.getBundle("i18n/MessagesBundle", locale);
        }
        formatter = new MessageFormat("");
        formatter.setLocale(locale);
    }


    private static class SettingsHolder {
        private static Settings instance = new Settings();
    }

    public static Settings getInstance() {
        return SettingsHolder.instance;
    }

    public String msg(String key) {
    	try {
    		return mes.getString(key);
    	} catch(MissingResourceException me) {
    		return "[" + key + "]";
    	}
    }
    
    public String msg(String key, Object[] objs) {
        try {
        	formatter.applyPattern(msg(key));
        	return formatter.format(objs);
        } catch (IllegalArgumentException e) {
        	return e.getMessage() + "[" + msg(key) + "]";
        }
    }

    private static SectionsWrapper defaultSettings() {
    	SectionsWrapper sec = new SectionsWrapper();
    	
        sec.setValue("gui", "width", "904");
        sec.setValue("gui", "height", "475");
        sec.setValue("gui", "x", "10");
        sec.setValue("gui", "y", "10");
        sec.setValue("gui", "profiledialog_width", "660");
        sec.setValue("gui", "profiledialog_height", "522");
        sec.setValue("gui", "profileloaderdialog_width", "375");
        sec.setValue("gui", "profileloaderdialog_height", "300");
        sec.setValue("gui", "profiledeletedialog_width", "550");
        sec.setValue("gui", "profiledeletedialog_height", "200");
        sec.setValue("gui", "multiprofiledialog_width", "600");
        sec.setValue("gui", "multiprofiledialog_height", "375");
        sec.setValue("gui", "dosboxdialog_width", "600");
        sec.setValue("gui", "dosboxdialog_height", "360");
        sec.setValue("gui", "templatedialog_width", "660");
        sec.setValue("gui", "templatedialog_height", "522");
        sec.setValue("gui", "mountdialog_width", "640");
        sec.setValue("gui", "mountdialog_height", "500");
        sec.setValue("gui", "archivebrowser_width", "400");
        sec.setValue("gui", "mobygamesbrowser_width", "400");
        sec.setValue("gui", "mobygamesbrowser_height", "375");
        sec.setValue("gui", "mixerdialog_width", "950");
        sec.setValue("gui", "mixerdialog_height", "450");
        sec.setValue("gui", "archivebrowser_height", "375");
        sec.setValue("gui", "dfendimportdialog_width", "600");
        sec.setValue("gui", "dfendimportdialog_height", "375");
        sec.setValue("gui", "exportlistdialog_width", "550");
        sec.setValue("gui", "exportlistdialog_height", "190");
        sec.setValue("gui", "export_width", "550");
        sec.setValue("gui", "export_height", "500");
        sec.setValue("gui", "import_width", "550");
        sec.setValue("gui", "import_height", "500");
        sec.setValue("gui", "migratedialog_width", "600");
        sec.setValue("gui", "migratedialog_height", "375");
        sec.setValue("gui", "settingsdialog_width", "600");
        sec.setValue("gui", "settingsdialog_height", "400");
        sec.setValue("gui", "filterdialog_width", "600");
        sec.setValue("gui", "filterdialog_height", "335");
        sec.setValue("gui", "filtertab", "0");
        sec.setBooleanValue("gui", "maximized", false);
        sec.setValue("gui", "column1width", "150");
        sec.setValue("gui", "column2width", "48");
        sec.setValue("gui", "column3width", "100");
        sec.setValue("gui", "column4width", "100");
        sec.setValue("gui", "column5width", "70");
        sec.setValue("gui", "column6width", "40");
        sec.setValue("gui", "column7width", "60");
        sec.setValue("gui", "column8width", "60");
        sec.setValue("gui", "column9width", "38");
        sec.setValue("gui", "column10width", "40");
        sec.setValue("gui", "column11width", "70");
        sec.setValue("gui", "column12width", "70");
        sec.setValue("gui", "column13width", "70");
        sec.setValue("gui", "column14width", "70");
        sec.setValue("gui", "column15width", "70");
        sec.setValue("gui", "column16width", "70");
        sec.setValue("gui", "column17width", "70");
        sec.setValue("gui", "column18width", "70");
        sec.setValue("gui", "column19width", "44");
        sec.setValue("gui", "column20width", "44");
        sec.setValue("gui", "column21width", "82");
        sec.setValue("gui", "column22width", "70");
        sec.setBooleanValue("gui", "column1visible", true);
        sec.setBooleanValue("gui", "column2visible", true);
        sec.setBooleanValue("gui", "column3visible", true);
        sec.setBooleanValue("gui", "column4visible", true);
        sec.setBooleanValue("gui", "column5visible", true);
        sec.setBooleanValue("gui", "column6visible", true);
        sec.setBooleanValue("gui", "column7visible", true);
        sec.setBooleanValue("gui", "column8visible", true);
        sec.setBooleanValue("gui", "column9visible", true);
        sec.setBooleanValue("gui", "column10visible", false);
        sec.setBooleanValue("gui", "column11visible", false);
        sec.setBooleanValue("gui", "column12visible", false);
        sec.setBooleanValue("gui", "column13visible", false);
        sec.setBooleanValue("gui", "column14visible", false);
        sec.setBooleanValue("gui", "column15visible", false);
        sec.setBooleanValue("gui", "column16visible", false);
        sec.setBooleanValue("gui", "column17visible", false);
        sec.setBooleanValue("gui", "column18visible", false);
        sec.setBooleanValue("gui", "column19visible", false);
        sec.setBooleanValue("gui", "column20visible", false);
        sec.setBooleanValue("gui", "column21visible", false);
        sec.setBooleanValue("gui", "column22visible", false);
        sec.setValue("gui", "column2_1width", "300");
        sec.setValue("gui", "column2_2width", "250");
        sec.setValue("gui", "column2_3width", "50");
        sec.setValue("gui", "column2_4width", "38");
        sec.setValue("gui", "column3_1width", "500");
        sec.setValue("gui", "column3_2width", "50");
        sec.setValue("gui", "sortcolumn", "0 8");
        sec.setValue("gui", "sortascending", "true true");
        sec.setValue("gui", "columnorder", "0 1 2 3 4 5 6 7 8");
        sec.setValue("gui", "sashweights", "777 222");
        sec.setValue("gui", "screenshotsheight", "100");
        sec.setValue("gui", "screenshotscolumnheight", "50");
        sec.setBooleanValue("gui", "autosortonupdate", false);
        sec.setBooleanValue("gui", "screenshotsfilename", true);
        sec.setIntValue("gui", "buttondisplay", 0);
        sec.setValue("gui", "custom1", "Custom1");
        sec.setValue("gui", "custom2", "Custom2");
        sec.setValue("gui", "custom3", "Custom3");
        sec.setValue("gui", "custom4", "Custom4");
        sec.setValue("gui", "custom5", "Custom5");
        sec.setValue("gui", "custom6", "Custom6");
        sec.setValue("gui", "custom7", "Custom7");
        sec.setValue("gui", "custom8", "Custom8");
        sec.setValue("gui", "custom9", "Custom9");
        sec.setValue("gui", "custom10", "Custom10");
        
		sec.setIntValue("profiledefaults", "confpath", 0);
        sec.setIntValue("profiledefaults", "conffile", 0);

        sec.setBooleanValue("dosbox", "hideconsole", false);

        sec.setBooleanValue("communication", "port_enabled", PlatformUtils.IS_WINDOWS);
        sec.setValue("communication", "port", "4740");

        sec.setValue("database", "connectionstring", "jdbc:hsqldb:file:./db/database");
        sec.setValue("database", "username", "sa");
        sec.setValue("database", "pasword", "");

        sec.setValue("directory", "data", ".");
        sec.setValue("directory", "dosbox", ".");
        
        sec.setValue("locale", "language", "en");
        sec.setValue("locale", "country", "");

        sec.setValue("mobygames", "platform_filter", "dos pc<space>booter");
        sec.setBooleanValue("mobygames", "set_title", true);
        sec.setBooleanValue("mobygames", "set_developer", true);
        sec.setBooleanValue("mobygames", "set_publisher", true);
        sec.setBooleanValue("mobygames", "set_year", true);
        sec.setBooleanValue("mobygames", "set_genre", true);
        sec.setBooleanValue("mobygames", "set_link", true);
        sec.setBooleanValue("mobygames", "set_description", true);
        sec.setBooleanValue("mobygames", "set_rank", true);

        sec.setBooleanValue("environment", "use", false);
        sec.setValue("environment", "value", "");

    	sec.setValue("profile", "priority_active", "lowest lower normal higher highest");
    	sec.setValue("profile", "priority_inactive", "lowest lower normal higher highest pause");
    	sec.setValue("profile", "output", "ddraw direct3d overlay opengl openglhq openglnb surface");
    	sec.setValue("profile", "frameskip", "0 1 2 3 4 5 6 7 8 9 10");
    	sec.setValue("profile", "scaler", "none normal2x normal3x advmame2x advmame3x advinterp2x advinterp3x "
                + "tv2x tv3x rgb2x rgb3x scan2x scan3x supereagle super2xsai 2xsai hq2x hq3x hardware2x hardware3x "
                + "tv tvadvmame2x normal4x");
    	sec.setValue("profile", "pixelshader", "none 2xsai.fx 2xsai_srgb.fx bilinear.fx cartoon.fx gs2x.fx "
                + "gs4x.fx gs4xcolor.fx gs4xcolorfilter.fx gs4xcolorscale.fx gs4xfilter.fx gs4xscale.fx matrix.fx "
                + "mcgreen.fx mcorange.fx point.fx scale2x.fx scale2x_ps14.fx sketch.fx");
    	sec.setValue("profile", "fullresolution", "original 0x0 320x200 640x480 800x600 1024x768 1280x768 1280x960 1280x1024");
    	sec.setValue("profile", "windowresolution", "original 320x200 640x480 800x600 1024x768 1280x768 1280x960 1280x1024");
    	sec.setValue("profile", "svgachipset", "none et3000 et4000 et4000new pvga1a s3");
    	sec.setValue("profile", "videoram", "256 512 1024 2048 3072 4096");
    	sec.setValue("profile", "vsyncmode", "off on force");
    	sec.setValue("profile", "lfbglide", "full read write none");
    	sec.setValue("profile", "machine", "cga hercules pcjr tandy vga");
    	sec.setValue("profile", "machine073", "cga hercules pcjr tandy ega vgaonly svga_s3 svga_et3000 svga_et4000 svga_paradise vesa_nolfb vesa_oldvbe");
    	sec.setValue("profile", "cputype", "auto 386 386_slow 486_slow pentium_slow 386_prefetch");
    	sec.setValue("profile", "core", "dynamic full normal simple auto");
    	sec.setValue("profile", "cycles",
                "350 500 750 1000 2000 3000 4000 5000 7500 10000 12500 15000 17500 20000 "
                + "25000 30000 32500 35000 40000 45000 50000 55000 60000 auto max<space>50% max<space>80% max<space>90% max");
    	sec.setValue("profile", "cycles_up", "10 20 50 100 500 1000 2000 5000 10000");
    	sec.setValue("profile", "cycles_down", "10 20 50 100 500 1000 2000 5000 10000");
    	sec.setValue("profile", "memsize", "0 1 2 4 8 16 31 63");
    	sec.setValue("profile", "ems", "false true");
    	sec.setValue("profile", "umb", "false true max");
    	sec.setValue("profile", "loadfix_value", "1 63 127");
    	sec.setValue("profile", "rate", SAMPLE_RATES);
    	sec.setValue("profile", "blocksize", "256 512 1024 2048 4096 8192");
    	sec.setValue("profile", "prebuffer", "10");
        sec.setValue("profile", "mpu401", "none intelligent uart");
        sec.setValue("profile", "device", "alsa default coreaudio coremidi mt32 none oss win32");
        sec.setValue("profile", "mt32rate", SAMPLE_RATES);
        sec.setValue("profile", "sbtype", "none gb sb1 sb2 sbpro1 sbpro2 sb16");
        sec.setValue("profile", "oplrate", SAMPLE_RATES);
        sec.setValue("profile", "oplmode", "auto cms opl2 dualopl2 opl3");
        sec.setValue("profile", "oplemu", "default compat fast");
        sec.setValue("profile", "sbbase", BASE_ADDRS);
        sec.setValue("profile", "irq", IRQS);
        sec.setValue("profile", "dma", DMAS);
        sec.setValue("profile", "hdma", DMAS);
        sec.setValue("profile", "gusrate", SAMPLE_RATES);
        sec.setValue("profile", "gusbase", BASE_ADDRS);
        sec.setValue("profile", "irq1", IRQS);
        sec.setValue("profile", "irq2", IRQS);
        sec.setValue("profile", "dma1", DMAS);
        sec.setValue("profile", "dma2", DMAS);
        sec.setValue("profile", "pcrate", SAMPLE_RATES);
        sec.setValue("profile", "tandy", "auto off on");
        sec.setValue("profile", "tandyrate", SAMPLE_RATES);
        sec.setValue("profile", "sensitivity", "10 20 30 40 50 60 70 80 90 100 125 150 175 200 250 300 350 400 "
                + "450 500 550 600 700 800 900 1000");
        sec.setValue("profile", "joysticktype", "auto none 2axis 4axis 4axis_2 ch fcs");
        sec.setValue("profile", "mount_type", "cdrom dir floppy");
        sec.setValue("profile", "zipmount_type", "cdrom dir floppy");
        sec.setValue("profile", "freesize", "1 10 100 200 500 1000");
        sec.setValue("profile", "lowlevelcd_type", "aspi ioctl ioctl_dx ioctl_dio ioctl_mci noioctl");
        sec.setValue("profile", "keyboardlayout", "auto none " +
        		"ba234 be120 bg241 bg442 bl463 br274 br275 by463 ca58 ca445 cf58 cf445 cf501 cz243 de129 de453 dk159 dv103 ee454 el220 el319 el459 es172 es173 et454 " +
        		"fi153 fo fr120 fr189 gk220 gk319 gk459 gr129 gr453 hr234 hu208 is161 is197 is458 it141 it142 la171 lt210 lt211 lt212 lt221 lt456 lh103 mk449 ml47 mt47 " +
        		"nl143 no155 ph pl214 pl457 po163 rh103 ro333 ro446 ru441 ru443 sd150 sf150 sg150 si234 sk245 sp172 sp173 sq448 sq452 sr118 sr450 su153 sv153 " +
        		"tm tr179 tr440 ua465 uk166 uk168 ur465 us103 ux103 yc118 yc450 yu234");

        return sec;
    }
}
