/*
 *  Copyright (C) 2006-2010  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.swtdesigner;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;


public final class SWTImageManager {

    private static final Map<String, Image> imageMap = new HashMap<String, Image>();

    public static final String IMG_TB_NEW = "tb_new.png";
    public static final String IMG_TB_EDIT = "tb_edit.png";
    public static final String IMG_TB_DELETE = "tb_delete.png";
    public static final String IMG_TB_RUN = "tb_run.png";
    public static final String IMG_TB_SETUP = "tb_setup.png";
    public static final String IMG_RUN = "run.png";
    public static final String IMG_SETUP = "setup.png";
    public static final String IMG_FOLDER = "folder.png";
    public static final String IMG_ZOOM = "zoom.png";
    public static final String IMG_NEW = "new.png";
    public static final String IMG_EDIT = "edit.png";
    public static final String IMG_DUPLICATE = "duplicate.png";
    public static final String IMG_DELETE = "delete.png";
    public static final String IMG_FAVORITE = "favorite.png";
    public static final String IMG_SHORTCUT = "shortcut.png";
    public static final String IMG_REFRESH = "refresh.png";
    public static final String IMG_HOME = "home.png";
    public static final String IMG_DFEND = "dfend.png";
    public static final String IMG_MIGRATE = "case.png";
    public static final String IMG_TABLEEXPORT = "checkout.png";
    public static final String IMG_IMPORT = "import.png";
    public static final String IMG_CLEAN = "clean.png";
    public static final String IMG_SETTINGS = "settings.png";
    public static final String IMG_EXIT = "stop.png";
    public static final String IMG_GRAB = "grab.png";
    public static final String IMG_MOBYGAMES = "moby.png";


    public static void dispose() {
        for (Image image: imageMap.values()) {
            image.dispose();
        }
        imageMap.clear();
    }
    
    public static Image getResourceImage(final Display display, final String path) {
    	return new Image(display, imageMap.getClass().getResourceAsStream("/img/" + path));
    }

    public static Image getImage(final Display display, final String path) {
        try {
        	if (path.toLowerCase().endsWith(".ico")) {
        		ImageLoader iLoader = new ImageLoader();
        		iLoader.load(path);
        		int bestWidth = 0;
        		int bestDepth = 0;
        		int bestIndex = 0;
        		for (int i = 0; i < iLoader.data.length; i++) {
        			if (iLoader.data[i].width >= bestWidth && iLoader.data[i].depth >= bestDepth) {
        				bestWidth = iLoader.data[i].width;
        				bestDepth = iLoader.data[i].depth;
        				bestIndex = i;
        			}
        		}
        		return new Image(display, iLoader.data[bestIndex]);
        	} else {
        		return new Image(display, path);
        	}
        } catch (Exception e) {
            Image image = new Image(display, 10, 10);
            GC graphc = new GC(image);
            graphc.setBackground(display.getSystemColor(SWT.COLOR_RED));
            graphc.fillRectangle(0, 0, 10, 10);
            graphc.dispose();
            return image;
        }
    }

    public static Image getResizedImage(final Display display, final int height, final String path, final String name) {
        String hash = path + height + name;
        Image image = imageMap.get(hash);
        if (image == null) {
            Image orgImage = getImage(display, path);
            int orgW = orgImage.getBounds().width;
            int orgH = orgImage.getBounds().height;
            double factor = (double) height / (double) orgH;
            int width = (int) (orgW * factor);
            image = new Image(display, width, height);
            GC graphc = new GC(image);
            graphc.setAntialias(SWT.ON);
            graphc.drawImage(orgImage, 0, 0, orgW, orgH, 0, 0, width, height);
            if (name != null) {
                Point size = graphc.textExtent(name);
                graphc.setBackground(new Color(display, 0, 0, 0));
                graphc.setForeground(new Color(display, 255, 255, 255));
                graphc.setAlpha(180);
                graphc.drawString(name, width - size.x - 2, height - size.y - 2, false);
            }
            graphc.dispose();
            imageMap.put(hash, image);
        }
        return image;
    }
}