/*
 *  Copyright (C) 2006-2010  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.model;

import java.io.File;
import java.net.MalformedURLException;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;


public class Profile extends KeyTitleDefault {

	protected String developerName;
	protected String publisherName;
	protected String genre;
	protected String year;
    protected int dbversionId;
    protected String setup;
    protected String setupParams;
    protected String notes;
    protected String[] link;
    protected String[] linkTitle;
    protected String status;
    protected String confPathAndFile;
    protected String captures;
    protected String[] customString;
    protected int[] customInt;


    protected Profile(final String title, final boolean favorite) {
    	super(-1, title, favorite); 
    }

    public Profile(final int id, final String title, final String devName, final String publName, final String genre, final String year,
            final int dbversionId, final String setup, final String setupParams, final String notes, final String link1, final String link2,
            final Boolean favorite, final String status, final String confPathAndFile, final String captures,
            final String link3, final String link4, final String cust1, final String cust2,
            final String cust3, final String cust4, final String cust5, final String cust6,
            final String cust7, final String cust8, final int cust9, final int cust10,
            final String link1Title, final String link2Title, final String link3Title, final String link4Title) {
        super(id, title, favorite);
        this.developerName = devName;
        this.publisherName = publName;
        this.genre = genre;
        this.year = year;
        this.dbversionId = dbversionId;
        this.setup = PlatformUtils.pathToNativePath(setup);
        this.setupParams = setupParams;
        this.notes = notes;
        this.status = status;
        this.confPathAndFile = PlatformUtils.pathToNativePath(confPathAndFile);
        this.captures = PlatformUtils.pathToNativePath(captures);
        this.link = new String[] { PlatformUtils.pathToNativePath(link1), PlatformUtils.pathToNativePath(link2),
        						   PlatformUtils.pathToNativePath(link3), PlatformUtils.pathToNativePath(link4) };
        this.linkTitle = new String[] { link1Title, link2Title, link3Title, link4Title };
        this.customString = new String[] { cust1, cust2, cust3, cust4, cust5, cust6, cust7, cust8 };
        this.customInt = new int[] { cust9, cust10 };
    }

    public Profile(final int id, final String confFile, final String captures, final Profile prof) {
        this(id, prof.getTitle(), prof.getDeveloperName(), prof.getPublisherName(), prof.getGenre(), prof.getYear(),
                prof.getDbversionId(), prof.getSetup(), prof.getSetupParameters(), prof.getNotes(), prof.getLink(0),
                prof.getLink(1), prof.isDefault(), prof.getStatus(), confFile, captures, prof.getLink(2),
                prof.getLink(3), prof.getCustomString(0), prof.getCustomString(1), prof.getCustomString(2),
                prof.getCustomString(3), prof.getCustomString(4), prof.getCustomString(5), prof.getCustomString(6),
                prof.getCustomString(7), prof.getCustomInt(0), prof.getCustomInt(1),
                prof.getLinkTitle(0), prof.getLinkTitle(1), prof.getLinkTitle(2), prof.getLinkTitle(3));
    }

    public Profile(final Profile prof1, final Profile prof2) {
    	this(-1, 
    			prof1.getTitle().equals(prof2.getTitle())? prof1.getTitle(): Conf.CONFLICTING_STRING_SETTING, 
    			prof1.getDeveloperName().equals(prof2.getDeveloperName())? prof1.getDeveloperName(): Conf.CONFLICTING_STRING_SETTING, 
    			prof1.getPublisherName().equals(prof2.getPublisherName())? prof1.getPublisherName(): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getGenre().equals(prof2.getGenre())? prof1.getGenre(): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getYear().equals(prof2.getYear())? prof1.getYear(): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getDbversionId() == (prof2.getDbversionId())? prof1.getDbversionId(): Conf.CONFLICTING_INT_SETTING,
    			prof1.getSetup().equals(prof2.getSetup())? prof1.getSetup(): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getSetupParameters().equals(prof2.getSetupParameters())? prof1.getSetupParameters(): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getNotes().equals(prof2.getNotes())? prof1.getNotes(): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getLink(0).equals(prof2.getLink(0))? prof1.getLink(0): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getLink(1).equals(prof2.getLink(1))? prof1.getLink(1): Conf.CONFLICTING_STRING_SETTING,
    			prof1.isDefault() == prof2.isDefault()? prof1.isDefault(): Conf.CONFLICTING_BOOL_SETTING,
    			prof1.getStatus().equals(prof2.getStatus())? prof1.getStatus(): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getConfPathAndFile().equals(prof2.getConfPathAndFile())? prof1.getConfPathAndFile(): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getCaptures().equals(prof2.getCaptures())? prof1.getCaptures(): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getLink(2).equals(prof2.getLink(2))? prof1.getLink(2): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getLink(3).equals(prof2.getLink(3))? prof1.getLink(3): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getCustomString(0).equals(prof2.getCustomString(0))? prof1.getCustomString(0): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getCustomString(1).equals(prof2.getCustomString(1))? prof1.getCustomString(1): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getCustomString(2).equals(prof2.getCustomString(2))? prof1.getCustomString(2): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getCustomString(3).equals(prof2.getCustomString(3))? prof1.getCustomString(3): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getCustomString(4).equals(prof2.getCustomString(4))? prof1.getCustomString(4): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getCustomString(5).equals(prof2.getCustomString(5))? prof1.getCustomString(5): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getCustomString(6).equals(prof2.getCustomString(6))? prof1.getCustomString(6): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getCustomString(7).equals(prof2.getCustomString(7))? prof1.getCustomString(7): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getCustomInt(0) == prof2.getCustomInt(0)? prof1.getCustomInt(0): Conf.CONFLICTING_INT_SETTING,
    			prof1.getCustomInt(1) == prof2.getCustomInt(1)? prof1.getCustomInt(1): Conf.CONFLICTING_INT_SETTING,
    			prof1.getLinkTitle(0).equals(prof2.getLinkTitle(0))? prof1.getLinkTitle(0): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getLinkTitle(1).equals(prof2.getLinkTitle(1))? prof1.getLinkTitle(1): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getLinkTitle(2).equals(prof2.getLinkTitle(2))? prof1.getLinkTitle(2): Conf.CONFLICTING_STRING_SETTING,
    			prof1.getLinkTitle(3).equals(prof2.getLinkTitle(3))? prof1.getLinkTitle(3): Conf.CONFLICTING_STRING_SETTING);
    }

    public Profile(final Profile prof1, final Profile prof2, boolean bogus) {
    	this(prof1.getId(),
    			prof2.getTitle() == null? prof1.getTitle(): prof2.getTitle(), 
    			prof2.getDeveloperName() == null? prof1.getDeveloperName(): prof2.getDeveloperName(), 
    			prof2.getPublisherName() == null? prof1.getPublisherName(): prof2.getPublisherName(),
    			prof2.getGenre() == null? prof1.getGenre(): prof2.getGenre(),
    			prof2.getYear() == null? prof1.getYear(): prof2.getYear(),
    			prof2.getDbversionId() == -1? prof1.getDbversionId(): prof2.getDbversionId(),
    			prof2.getSetup() == null? prof1.getSetup(): prof2.getSetup(),
    			prof2.getSetupParameters() == null? prof1.getSetupParameters(): prof2.getSetupParameters(),
    			prof2.getNotes() == null? prof1.getNotes(): prof2.getNotes(),
    			prof2.getLink(0) == null? prof1.getLink(0): prof2.getLink(0),
    			prof2.getLink(1) == null? prof1.getLink(1): prof2.getLink(1),
    			prof2.isDefault() == null? prof1.isDefault(): prof2.isDefault(),
    			prof2.getStatus() == null? prof1.getStatus(): prof2.getStatus(),
    			prof2.getConfPathAndFile() == null? prof1.getConfPathAndFile(): prof2.getConfPathAndFile(),
    			prof2.getCaptures() == null? prof1.getCaptures(): prof2.getCaptures(),
    			prof2.getLink(2) == null? prof1.getLink(2): prof2.getLink(2),
    			prof2.getLink(3) == null? prof1.getLink(3): prof2.getLink(3),
    			prof2.getCustomString(0) == null? prof1.getCustomString(0): prof2.getCustomString(0),
    			prof2.getCustomString(1) == null? prof1.getCustomString(1): prof2.getCustomString(1),
    			prof2.getCustomString(2) == null? prof1.getCustomString(2): prof2.getCustomString(2),
    			prof2.getCustomString(3) == null? prof1.getCustomString(3): prof2.getCustomString(3),
    			prof2.getCustomString(4) == null? prof1.getCustomString(4): prof2.getCustomString(4),
    			prof2.getCustomString(5) == null? prof1.getCustomString(5): prof2.getCustomString(5),
    			prof2.getCustomString(6) == null? prof1.getCustomString(6): prof2.getCustomString(6),
    			prof2.getCustomString(7) == null? prof1.getCustomString(7): prof2.getCustomString(7),
    			prof2.getCustomInt(0) == -1? prof1.getCustomInt(0): prof2.getCustomInt(0),
    			prof2.getCustomInt(1) == -1? prof1.getCustomInt(1): prof2.getCustomInt(1),
    			prof2.getLinkTitle(0) == null? prof1.getLinkTitle(0): prof2.getLinkTitle(0),
    			prof2.getLinkTitle(1) == null? prof1.getLinkTitle(1): prof2.getLinkTitle(1),
    			prof2.getLinkTitle(2) == null? prof1.getLinkTitle(2): prof2.getLinkTitle(2),
    			prof2.getLinkTitle(3) == null? prof1.getLinkTitle(3): prof2.getLinkTitle(3));
    }

    public String getDeveloperName() {
        return developerName;
    }

    public String getGenre() {
        return genre;
    }

    public String getPublisherName() {
        return publisherName;
    }

    public String getYear() {
        return year;
    }

    public int getDbversionId() {
        return dbversionId;
    }

    public boolean hasSetup() {
        return !"".equals(setup);
    }

    public String hasSetupString() {
        return hasSetup() ? Settings.getInstance().msg("general.yes"): Settings.getInstance().msg("general.no");
    }

    public String[] getLinks() {
        return link.clone();
    }

    public String getLink(final int index) {
        return link[index];
    }
    
    public String getLinkTitle(final int index) {
        return linkTitle[index];
    }
    
    public String[] getLinkTitles() {
        return linkTitle.clone();
    }
    
    public String getLinkAsUrl(final int index) {
        String res = link[index];
        if ((res != null) && res.length() > 0 && res.indexOf("://") == -1) {
            try {
                res = FileUtils.getUrlFromFile(FileUtils.canonicalToData(res));
            } catch (MalformedURLException e1) {
                // nothing we can do, but to keep the current url
            }
        }
        return res;
    }

    public String getNotes() {
        return notes;
    }

    public String getSetup() {
        return setup;
    }

    public String getSetupParameters() {
        return setupParams;
    }

    public String getStatus() {
        return status;
    }

    public String getConfPathAndFile() {
        return confPathAndFile;
    }

    public File getCanonicalConfFile() {
        return FileUtils.canonicalToData(confPathAndFile);
    }
    
    public String getConfFileAsUrl() {
        try {
            return FileUtils.getUrlFromFile(getCanonicalConfFile());
        } catch (MalformedURLException e1) {
            return getCanonicalConfFile().getPath();
        }
    }

    public String getCaptures() {
        return captures;
    }

    public File getCanonicalCaptures() {
        return FileUtils.canonicalToData(captures);
    }
    
    public String getCapturesAsUrl() {
        try {
            return FileUtils.getUrlFromFile(getCanonicalCaptures());
        } catch (MalformedURLException e1) {
            return getCanonicalCaptures().getPath();
        }
    }

    public String getCustomString(final int index) {
        return customString[index];
    }

    public String[] getCustomStrings() {
        return customString.clone();
    }

    public int getCustomInt(final int index) {
        return customInt[index];
    }

    public int[] getCustomInts() {
        return customInt.clone();
    }
}
