/*
 *  Copyright (C) 2006-2010  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.gui;

import java.io.File;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.dbgl.gui.BrowseButton.BrowseType;
import org.dbgl.gui.BrowseButton.CanonicalType;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.DFendImportThread;


public final class DFendImportDialog extends Dialog {

	private Text location;
	private Text logText;
	private DosboxVersion defaultDbversion;
	private DFendImportThread importThread;
	private Button cancelButton;
	private Label profileLabel;
	private Shell shell;
	private Settings settings;


	public DFendImportDialog(final Shell parent, final int style) {
		super(parent, style);
	}

	public DFendImportDialog(final Shell parent) {
		this(parent, SWT.NONE);
	}
	
	public void setDefaultDosboxVersion(final DosboxVersion dbversion) {
		this.defaultDbversion = dbversion;
	}
	
	public Object open() {
	    settings = Settings.getInstance();
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (importThread != null && !importThread.isAlive() && !cancelButton.getText().equals(settings.msg("button.finish"))) {
				if (importThread.isEverythingOk())
					GeneralPurposeDialogs.infoMessage(shell, settings.msg("dialog.dfendimport.notice.importok"));
				else
					GeneralPurposeDialogs.warningMessage(shell, settings.msg("dialog.dfendimport.error.problem"));
				profileLabel.setText(settings.msg("dialog.dfendimport.reviewlog"));
				profileLabel.pack();
				cancelButton.setText(settings.msg("button.finish"));
				cancelButton.setEnabled(true);
			}	
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return importThread;
	}

	private void createContents() {
		shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
		shell.setLayout(new GridLayout());
        shell.addControlListener(new SizeControlAdapter(shell, "dfendimportdialog"));
		shell.setText(settings.msg("dialog.dfendimport.title"));

		final Group optionsGroup = new Group(shell, SWT.NONE);
		optionsGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		optionsGroup.setText(settings.msg("dialog.dfendimport.options"));
		final GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 3;
		optionsGroup.setLayout(gridLayout);

		final Label dfendLocLabel = new Label(optionsGroup, SWT.NONE);
		dfendLocLabel.setText(settings.msg("dialog.dfendimport.dfendpath"));

		location = new Text(optionsGroup, SWT.BORDER);
		location.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		location.setText(BrowseButton.DFEND_PATH + BrowseButton.DFEND_PROFILES);

		final BrowseButton browseButton = new BrowseButton(optionsGroup, SWT.NONE);
		browseButton.connect(shell, location, null, BrowseType.FILE, CanonicalType.DFEND, false, null);

		final Label cleanUpLabel = new Label(optionsGroup, SWT.NONE);
		cleanUpLabel.setText(settings.msg("dialog.dfendimport.cleanup"));

		final Button cleanup = new Button(optionsGroup, SWT.CHECK);
		cleanup.setText(settings.msg("dialog.dfendimport.removesections"));
		cleanup.setSelection(true);
		new Label(optionsGroup, SWT.NONE);

		final Button startImportButton = new Button(optionsGroup, SWT.NONE);
		shell.setDefaultButton(startImportButton);
		startImportButton.setLayoutData(new GridData(120, SWT.DEFAULT));
		startImportButton.setText(settings.msg("dialog.dfendimport.startimport"));

		cancelButton = new Button(optionsGroup, SWT.NONE);
		cancelButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent event) {
				shell.close();
			}
		});
		cancelButton.setLayoutData(new GridData(80, SWT.DEFAULT));
		cancelButton.setText(settings.msg("button.cancel"));
		new Label(optionsGroup, SWT.NONE);

		final Group progressGroup = new Group(shell, SWT.NONE);
		progressGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		progressGroup.setText(settings.msg("dialog.dfendimport.progress"));
		progressGroup.setLayout(new GridLayout());

		final ProgressBar progressBar = new ProgressBar(progressGroup, SWT.NONE);
		progressBar.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

		profileLabel = new Label(progressGroup, SWT.NONE);

		logText = new Text(progressGroup, SWT.V_SCROLL | SWT.MULTI | SWT.READ_ONLY | SWT.BORDER | SWT.H_SCROLL);
		logText.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
		startImportButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent event) {
				try {
					importThread = new DFendImportThread(logText, progressBar, profileLabel, new File(location.getText()), cleanup.getSelection(), defaultDbversion);
					location.setEnabled(false);
					browseButton.setEnabled(false);
					cleanup.setEnabled(false);
					startImportButton.setEnabled(false);
					cancelButton.setEnabled(false);
					importThread.start();
				} catch (Exception e) {
					GeneralPurposeDialogs.warningMessage(shell, e);
					importThread = null;
				}
			}
		});
	}
}
