/*
 *  Copyright (C) 2006-2010  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.util;

import java.util.HashMap;
import java.util.Map;


public final class StringUtils {

    public static String[] textAreaToStringArray(final String contents, final String del) {
        int start = 0;
        int length = del.length();
        int finish = contents.length();
        while (contents.indexOf(del, start) == start) {
            start += length;
        }
        while (finish >= length && (contents.indexOf(del, finish - length) == (finish - length))) {
            finish -= length;
        }
        return contents.substring(start, finish).split(del);
    }

    public static String[] mountToStringArray(final String paths) {
        if (paths.length() <= 0) {
            return new String[0];
        }
        return paths.split("\" \"");
    }

    public static String intArrayToString(final int[] list) {
        StringBuffer result = new StringBuffer();
        for (int value: list) {
            result.append(value).append(' ');
        }
        return result.toString();
    }

    public static String booleanArrayToString(final boolean[] list) {
        StringBuffer result = new StringBuffer();
        for (boolean value: list) {
            result.append(value).append(' ');
        }
        return result.toString();
    }

    public static String stringArrayToString(final String[] list, final String delimiter) {
        StringBuffer result = new StringBuffer();
        for (String value: list) {
            result.append(value).append(delimiter);
        }
        return result.toString();
    }

    public static Map<String, String> stringArrayToMap(final String[] list) {
        Map<String, String> result = new HashMap<String, String>();
        for (String entry: list) {
            String[] pair = entry.split("=");
            if (pair.length == 2) {
	            String key = pair[0].trim();
	            String value = pair[1].trim();
	            if (key.length() > 0  && value.length() > 0) {
	            	result.put(key, value);
	            }
            }
        }
        return result;
    }

    public static int[] stringToIntArray(final String input) {
        if (input.length() <= 0) {
            return new int[0];
        }
        String[] values = input.split(" ");
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; i++) {
            try {
                result[i] = Integer.parseInt(values[i]);
            } catch (NumberFormatException e) {
                result[i] = -1;
            }
        }
        return result;
    }

    public static boolean[] stringToBooleanArray(final String input) {
        if (input.length() <= 0) {
            return new boolean[0];
        }
        String[] values = input.split(" ");
        boolean[] result = new boolean[values.length];
        for (int i = 0; i < values.length; i++) {
            result[i] = Boolean.parseBoolean(values[i]);
        }
        return result;
    }

    public static int countCharacters(final String string, final char charToCount) {
        int result = 0;
        for (int i = 0; i < string.length(); i++) {
            if (string.charAt(i) == charToCount) {
                result++;
            }
        }
        return result;
    }

    public static String shorten(final String s, final int length) {
        if (s == null || s.length() <= length)
            return s;
        return new StringBuffer(s.substring(0, length / 2 - 2)).append("....").append(s.substring(s.length() - length / 2 + 2)).toString();
    }

    public static String toString(Exception exception) {
    	return exception.getMessage() != null ? exception.getMessage(): exception.toString();
    }
}
