/*
 *  Copyright (C) 2006-2011  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.model;

import java.io.IOException;
import org.dbgl.swtdesigner.SWTImageManager;
import org.eclipse.swt.graphics.ImageData;


public class WebProfile implements Comparable<WebProfile> {

    private String title;
	private String platform;
	private String year;
	private String url;
	private String developerName;
    private String publisherName;
    private String genre;
    private String notes;
    private int rank;
    private String coreGameCoverUrl;
    private SearchEngineImageInformation[] webImages;
    
	
    public WebProfile() { 
    }

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	public String getPlatform() {
		return platform;
	}

	public void setPlatform(String platform) {
		this.platform = platform;
	}

	public String getYear() {
		return year;
	}

	public void setYear(String year) {
		this.year = year;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getScreenshotsUrl() {
		return url + "/screenshots";
	}
	
	public String getCoverArtUrl() {
		return url + "/cover-art";
	}
	
	public String getCoreGameCoverUrl() {
		return coreGameCoverUrl;
	}

	public void setCoreGameCoverUrl(String coreGameCoverUrl) {
		this.coreGameCoverUrl = coreGameCoverUrl;
	}

	public ImageData getWebImage(int i) throws IOException {
		if (webImages[i].data == null)
			webImages[i].data = SWTImageManager.getImageData(webImages[i].url);
		return webImages[i].data;
	}

	public SearchEngineImageInformation[] getWebImages() {
		return webImages;
	}

	public void setWebImages(SearchEngineImageInformation[] webImages) {
		this.webImages = webImages;
	}

	public String getDeveloperName() {
		return developerName;
	}

	public void setDeveloperName(String developerName) {
		this.developerName = developerName;
	}

	public String getPublisherName() {
		return publisherName;
	}

	public void setPublisherName(String publisherName) {
		this.publisherName = publisherName;
	}

	public String getGenre() {
		return genre;
	}

	public void setGenre(String genre) {
		this.genre = genre;
	}
	
	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}

	public int getRank() {
		return rank;
	}

	public void setRank(int rank) {
		this.rank = rank;
	}

	public int compareTo(WebProfile otherProfile) {
		if (otherProfile.platform.equalsIgnoreCase(platform)) {
			return title.compareToIgnoreCase(otherProfile.title);
		}
		return platform.compareToIgnoreCase(otherProfile.platform);
	}
}
