/*
 *  Copyright (C) 2006-2016  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;


public class StreamReader extends Thread {

	private InputStream is;
	private StringWriter sw;

	public StreamReader(InputStream is) {
		this.is = is;
		this.sw = new StringWriter();
	}

	@Override
	public void run() {
		try {
			int c;
			while ((c = is.read()) != -1)
				sw.write(c);
			sw.close();
			is.close();
		} catch (IOException ioe) {
			ioe.printStackTrace();
		}
	}

	public String getResult() {
		return sw.toString();
	}
}