/*
 *  Copyright (C) 2006-2019  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.gui.dialog;

import org.dbgl.constants.Constants;
import org.dbgl.gui.abstractdialog.BaseDialog;
import org.dbgl.service.ImageService;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.hsqldb.persist.HsqlDatabaseProperties;


public class AboutDialog extends BaseDialog<Object> {

	public AboutDialog(Shell parent) {
		super(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL | SWT.RESIZE);
	}

	@Override
	protected String getDialogTitle() {
		return text_.get("dialog.about.title");
	}

	@Override
	protected void onShellCreated() {
		shell_.setSize(660, 410);

		GridLayout layout = new GridLayout(2, false);
		layout.marginTop = 2;
		layout.marginBottom = 5;
		shell_.setLayout(layout);

		Canvas canvas = new Canvas(shell_, SWT.NONE);
		GridData gridData = new GridData(SWT.LEFT, SWT.CENTER, true, true);
		gridData.heightHint = 256;
		gridData.widthHint = 256;
		canvas.setLayoutData(gridData);
		canvas.addPaintListener(new PaintListener() {
			public void paintControl(PaintEvent e) {
				e.gc.drawImage(ImageService.getResourceImage(getParent().getDisplay(), "ico/256.png"), 0, 0);
			}
		});

		Group group = createGroup(shell_, new GridData(SWT.FILL, SWT.FILL, true, true), null, new GridLayout());
		addLabel(group, text_.get("dialog.about.createdby", new Object[] {Constants.PROGRAM_NAME_FULL, Constants.PROGRAM_VERSION}));
		addLabel(group, text_.get("dialog.about.info", new Object[] {SystemUtils.JVM_ARCH, SystemUtils.JVM_VERSION, SystemUtils.OS_NAME, SystemUtils.OS_VERSION, SystemUtils.OS_ARCH,
				HsqlDatabaseProperties.PRODUCT_NAME, HsqlDatabaseProperties.THIS_FULL_VERSION, String.valueOf(SWT.getVersion()), SWT.getPlatform()}));
		addLabel(group, text_.get("dialog.about.thanks"));

		createLink(group, "<a href=\"http://home.quicknet.nl/qn/prive/blankendaalr/dbgl/\">" + text_.get("dialog.about.website") + "</a>", browseAdapter);

		shell_.setDefaultButton(createButton(group, new GridData(SWT.FILL, SWT.CENTER, true, false), text_.get("button.ok"), null, closeShellAdapter));
	}

	private void addLabel(Group group, String text) {
		GridData gridData = new GridData();
		gridData.widthHint = 360;
		createLabel(group, SWT.WRAP, gridData, text);
	}
}
