/*
 *  Copyright (C) 2006-2019  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.gui.dialog.wizard;

import java.sql.SQLException;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.JobWizardDialog;
import org.dbgl.gui.controls.BrowseButton;
import org.dbgl.gui.controls.BrowseButton.BrowseType;
import org.dbgl.gui.controls.BrowseButton.CanonicalType;
import org.dbgl.gui.thread.MigrateThread;
import org.dbgl.model.FileLocation;
import org.dbgl.model.ICanonicalize;
import org.dbgl.service.FileLocationService;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;


public class MigrateDialog extends JobWizardDialog<String> {

	private Text from_;
	private ICanonicalize canonicalizer_;

	public MigrateDialog(Shell parent) {
		super(parent, "migratedialog");
	}

	@Override
	protected String getDialogTitle() {
		return text_.get("dialog.migration.title");
	}

	@Override
	protected void onShellCreated() {
		Group optionsGroup = createGroup(shell_, text_.get("dialog.migration.options"), 3);

		from_ = createLabelAndText(optionsGroup, text_.get("dialog.migration.from"));
		canonicalizer_ = new BrowseButton(optionsGroup).connect(shell_, from_, null, BrowseType.DIR, CanonicalType.NONE, false, null);
		createLabelAndText(optionsGroup, text_.get("dialog.migration.to"), 2, FileLocationService.getInstance().getDosroot().getPath()).setEditable(false);
		addStep(optionsGroup);

		addFinalStep(text_.get("dialog.migration.progress"), text_.get("dialog.migration.startmigration"));
	}

	@Override
	protected boolean onNext(int step) {
		if (step == 0) {
			if (!isValid())
				return false;
		} else if (step == 1) {
			try {
				job_ = new MigrateThread(log_, progressBar_, status_, new FileLocation(from_.getText(), canonicalizer_));
			} catch (SQLException e) {
				GeneralPurposeDialogs.warningMessage(shell_, e);
				return false;
			}
		} else if (step == 2) {
			if (job_.isEverythingOk())
				GeneralPurposeDialogs.infoMessage(shell_, text_.get("dialog.migration.notice.migrationok"));
			else
				GeneralPurposeDialogs.warningMessage(shell_, text_.get("dialog.migration.error.problem"));

			status_.setText(text_.get("dialog.migration.reviewlog"));
			status_.pack();

			result_ = from_.getText();
		}
		return true;
	}

	private boolean isValid() {
		GeneralPurposeDialogs.initErrorDialog();
		if (from_.getText().equals("")) {
			GeneralPurposeDialogs.addError(text_.get("dialog.migration.required.from"), from_);
		}
		return !GeneralPurposeDialogs.displayErrorDialog(shell_);
	}
}
