/*
 *  Copyright (C) 2006-2020  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.gui.abstractdialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;


public abstract class SizeControlledButtonDialog<T> extends SizeControlledDialog<T> {

	protected Composite contents_;
	protected Composite buttons_;
	protected Composite okCancelButtons_;
	protected Composite otherButtons_;

	protected Button okButton_;
	protected Button cancelButton_;

	public SizeControlledButtonDialog(Shell parent, String dialogName) {
		super(parent, dialogName);
	}

	@Override
	protected void onShellInit() {
		super.onShellInit();

		shell_.setLayout(new GridLayout());

		contents_ = createComposite(shell_, new GridData(SWT.FILL, SWT.FILL, true, true));

		buttons_ = createInnerComposite(shell_, new GridData(SWT.FILL, SWT.FILL, true, false), 2);
		okCancelButtons_ = createInnerComposite(buttons_, new GridData(SWT.BEGINNING, SWT.FILL, true, false), 2);
		otherButtons_ = createInnerComposite(buttons_, new GridData(SWT.BEGINNING, SWT.FILL, false, false), 2);
	}

	protected void createGoButton(String title, SelectionListener listener) {
		okButton_ = createButton(okCancelButtons_, title, listener);

		shell_.setDefaultButton(okButton_);
	}

	protected void createOkButton(SelectionListener listener) {
		createGoButton(text_.get("button.ok"), listener);
	}

	protected void createCancelButton() {
		cancelButton_ = createButton(okCancelButtons_, text_.get("button.cancel"), closeShellAdapter);
	}

	protected void createGoCancelButtons(String title, SelectionListener listener) {
		createGoButton(title, listener);
		createCancelButton();
		setLayoutDataButtons(okButton_, cancelButton_);
	}

	protected void createOkCancelButtons(SelectionListener listener) {
		createGoCancelButtons(text_.get("button.ok"), listener);
	}

}
