/*
 *  Copyright (C) 2006-2020  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.gui.abstractdialog;

import java.util.stream.Stream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;


public abstract class SizeControlledTabbedDialog<T> extends SizeControlledButtonDialog<T> {

	protected TabFolder tabFolder_;

	public SizeControlledTabbedDialog(Shell parent, String dialogName) {
		super(parent, dialogName);
	}

	@Override
	protected void onShellInit() {
		super.onShellInit();

		GridLayout layout = new GridLayout(2, false);
		layout.horizontalSpacing = layout.marginHeight = layout.marginWidth = 0;
		contents_.setLayout(layout);

		tabFolder_ = new TabFolder(contents_, SWT.NONE);
		tabFolder_.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
	}

	protected Composite createTabWithComposite(String title, Layout layout) {
		return createTabWithComposite(tabFolder_, title, layout);
	}

	protected Composite createTabWithComposite(String title, int numColumns) {
		return createTabWithComposite(tabFolder_, title, new GridLayout(numColumns, false));
	}

	protected TabItem getTabItemByComposite(Composite composite) {
		return Stream.of(tabFolder_.getItems()).filter(x -> x.getControl() == composite).findFirst().orElse(null);
	}

	protected TabItem getTabItemByControl(Control control) {
		Composite parent = control.getParent();
		while ((parent != null) && !(parent.getParent() instanceof TabFolder))
			parent = parent.getParent();
		return getTabItemByComposite(parent);
	}
}
