package org.dbgl.gui.controls;

import org.dbgl.service.TextService;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;


public class Composite_ {

	public static Builder on(Composite composite) {
		return new Builder(composite);
	}

	public static class Builder extends ControlBuilder<Builder> {
		private Layout layout_;
		private String text_;

		public Builder(Composite composite) {
			super(composite, SWT.NONE, SWT.BEGINNING, SWT.TOP, false, false);
		}

		public Builder layout(Layout layout) {
			layout_ = layout;
			return this;
		}

		public Builder innerLayout(int numColumns) {
			GridLayout layout = new GridLayout(numColumns, false);
			layout.horizontalSpacing = 4;
			layout.marginWidth = 0;
			layout.marginHeight = 0;
			layout_ = layout;
			return this;
		}

		public Builder tab(String key) {
			text_ = TextService.getInstance().get(key);
			return this;
		}

		public Composite build() {
			Composite composite = new Composite(composite_, style_);
			composite.setLayoutData(layoutData());
			composite.setLayout(layout_);
			if (text_ != null) {
				TabItem tabItem = new TabItem((TabFolder)composite_, style_);
				tabItem.setText(text_);
				tabItem.setControl(composite);
			}
			return composite;
		}
	}
}
