package org.dbgl.gui.controls;

import org.dbgl.service.TextService;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;


public class Spinner_ {

	private final Spinner spinner_;

	private Spinner_(Builder builder) {
		spinner_ = new Spinner(builder.composite_, builder.style_);
		spinner_.setLayoutData(builder.layoutData());
		if (builder.minimum_ != null)
			spinner_.setMinimum(builder.minimum_);
		if (builder.maximum_ != null)
			spinner_.setMaximum(builder.maximum_);
		if (builder.digits_ != null)
			spinner_.setDigits(builder.digits_);
		if (builder.increment_ != null)
			spinner_.setIncrement(builder.increment_);
		if (builder.pageIncrement_ != null)
			spinner_.setPageIncrement(builder.pageIncrement_);

		if (builder.tooltip_ != null)
			spinner_.setToolTipText(builder.tooltip_);

		if (builder.selection_ != null)
			spinner_.setSelection(builder.selection_);
	}

	public Spinner ctrl() {
		return spinner_;
	}

	public static Builder on(Composite composite) {
		return new Builder(composite);
	}

	public static class Builder extends ControlBuilder<Builder> {
		String tooltip_;
		Integer minimum_ = null;
		Integer maximum_ = null;
		Integer digits_ = null;
		Integer increment_ = null;
		Integer pageIncrement_ = null;
		Integer selection_ = null;

		Builder(Composite composite) {
			super(composite, SWT.BORDER, SWT.FILL, SWT.CENTER, false, false);
		}

		public Builder tooltip(String key) {
			tooltip_ = TextService.getInstance().get(key);
			return this;
		}

		public Builder min(int min) {
			minimum_ = min;
			return this;
		}

		public Builder max(int max) {
			maximum_ = max;
			return this;
		}

		public Builder digits(int digits) {
			digits_ = digits;
			return this;
		}

		public Builder incr(int incr) {
			increment_ = incr;
			return this;
		}

		public Builder pageIncr(int pageIncr) {
			pageIncrement_ = pageIncr;
			return this;
		}

		public Builder select(int select) {
			selection_ = select;
			return this;
		}

		public Spinner_ build() {
			return new Spinner_(this);
		}

		public Spinner ctrl() {
			return build().ctrl();
		}
	}
}
