package org.dbgl.gui.controls;

import org.dbgl.service.TextService;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;


public final class Text_ {

	private final Text text_;

	private Text_(Builder builder) {
		text_ = new Text(builder.composite_, builder.style_);
		text_.setLayoutData(builder.layoutData());

		if (builder.focus_)
			text_.setFocus();

		if (builder.tooltip_ != null)
			text_.setToolTipText(builder.tooltip_);

		if (builder.value_ != null)
			text_.setText(builder.value_);

		if (!builder.editable_)
			text_.setEditable(false);
	}

	public Text ctrl() {
		return text_;
	}

	public static Builder on(Composite composite) {
		return new Builder(composite);
	}

	public static final class Builder extends ControlBuilder<Builder> {
		private String tooltip_;
		private String value_;
		private boolean editable_ = true;
		private boolean focus_;

		Builder(Composite composite) {
			super(composite, SWT.BORDER, SWT.FILL, SWT.CENTER, true, false);
		}

		public Builder tooltip(String tooltip) {
			tooltip_ = TextService.getInstance().get(tooltip);
			return this;
		}

		public Builder tooltip(String tooltip, String param) {
			tooltip_ = TextService.getInstance().get(tooltip, param);
			return this;
		}

		public Builder multi() {
			style_ |= SWT.MULTI;
			style_ |= SWT.H_SCROLL;
			style_ |= SWT.V_SCROLL;
			verticalAlignment_ = SWT.FILL;
			grabExcessVerticalSpace_ = true;
			return this;
		}

		public Builder readOnly() {
			style_ |= SWT.READ_ONLY;
			return this;
		}

		public Builder wrap() {
			style_ &= ~SWT.H_SCROLL;
			style_ |= SWT.WRAP;
			return this;
		}

		public Builder nonEditable() {
			editable_ = false;
			return this;
		}

		public Builder val(String value) {
			value_ = value;
			return this;
		}

		public Builder focus() {
			focus_ = true;
			return this;
		}

		public Text_ build() {
			return new Text_(this);
		}

		public Text ctrl() {
			return build().ctrl();
		}
	}
}
