/*
 *  Copyright (C) 2006-2021  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.util.archive;

import java.io.File;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dbgl.util.FilesUtils;
import SevenZip.Archive.IInArchive;


public class SevenzipUtils {

	public static Map<Integer, File> findEntries(IInArchive zArchive, File dirToBeExtracted, File dstDir) {
		Map<Integer, File> result = new LinkedHashMap<>();
		for (int i = 0; i < zArchive.size(); i++) {
			File entryFile = new File(zArchive.getEntry(i).getName());
			if (FilesUtils.areRelated(dirToBeExtracted, entryFile)) {
				String relativeFile = FilesUtils.relativize(dirToBeExtracted, entryFile);
				File dstFile = new File(dstDir, relativeFile);
				result.put(i, dstFile);
			}
		}
		return result;
	}

	public static Map.Entry<Integer, File> findEntry(IInArchive zArchive, File fileToBeExtracted, File dstFile) {
		String entryName = FilesUtils.toArchivePath(fileToBeExtracted, false);
		for (int i = 0; i < zArchive.size(); i++)
			if (zArchive.getEntry(i).getName().equals(entryName))
				return new AbstractMap.SimpleEntry<>(i, dstFile);
		return null;
	}

}
