package org.dbgl.gui.controls;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;


public class CTabFolder_ {

	private final CTabFolder tabFolder_;

	public CTabFolder_(Builder builder) {
		tabFolder_ = new CTabFolder(builder.composite_, builder.style_);
		if (DarkTheme.forced()) {
			tabFolder_.setBackground(builder.composite_.getBackground());
			tabFolder_.setForeground(DarkTheme.tabForeground);
			tabFolder_.setSelectionBackground(builder.composite_.getBackground());
			tabFolder_.setSelectionForeground(DarkTheme.tabSelectedForeground);
		}
		tabFolder_.setLayoutData(builder.layoutData());
	}

	public CTabFolder ctrl() {
		return tabFolder_;
	}

	public static Builder on(Composite composite) {
		return new Builder(composite);
	}

	public static final class Builder extends ControlBuilder<Builder> {

		Builder(Composite composite) {
			super(composite, SWT.NONE, SWT.FILL, SWT.CENTER, true, false);
		}

		public CTabFolder_ build() {
			return new CTabFolder_(this);
		}

		public CTabFolder ctrl() {
			return build().ctrl();
		}
	}
}
