package org.dbgl.gui.controls;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scale;


public class Scale_ {

	private final Scale scale_;

	private Scale_(Builder builder) {
		scale_ = new Scale(builder.composite_, builder.style_);
		if (DarkTheme.forced()) {
			scale_.setBackground(builder.composite_.getBackground());
			scale_.setForeground(DarkTheme.defaultForeground);
		}
		scale_.setLayoutData(builder.layoutData());

		if (builder.minimum_ != null)
			scale_.setMinimum(builder.minimum_);
		if (builder.maximum_ != null)
			scale_.setMaximum(builder.maximum_);
		if (builder.increment_ != null)
			scale_.setIncrement(builder.increment_);
		if (builder.pageIncrement_ != null)
			scale_.setPageIncrement(builder.pageIncrement_);
		if (builder.tooltip_ != null)
			scale_.setToolTipText(builder.tooltip_);
		if (builder.selection_ != null)
			scale_.setSelection(builder.selection_);
	}

	public Scale ctrl() {
		return scale_;
	}

	public static Builder on(Composite composite) {
		return new Builder(composite);
	}

	public static class Builder extends ControlBuilder<Builder> {
		String tooltip_;
		Integer minimum_ = null;
		Integer maximum_ = null;
		Integer increment_ = null;
		Integer pageIncrement_ = null;
		Integer selection_ = null;

		Builder(Composite composite) {
			super(composite, SWT.HORIZONTAL, SWT.FILL, SWT.CENTER, true, false);
		}

		public Builder tooltip(String tooltip) {
			tooltip_ = tooltip;
			return this;
		}

		public Builder vertical() {
			style_ = SWT.VERTICAL;
			horizontalAlignment_ = SWT.CENTER;
			verticalAlignment_ = SWT.FILL;
			grabExcessHorizontalSpace_ = false;
			grabExcessVerticalSpace_ = true;
			return this;
		}

		public Builder min(int min) {
			minimum_ = min;
			return this;
		}

		public Builder max(int max) {
			maximum_ = max;
			return this;
		}

		public Builder incr(int incr) {
			increment_ = incr;
			return this;
		}

		public Builder pageIncr(int pageIncr) {
			pageIncrement_ = pageIncr;
			return this;
		}

		public Builder select(int select) {
			selection_ = select;
			return this;
		}

		public Scale_ build() {
			return new Scale_(this);
		}

		public Scale ctrl() {
			return build().ctrl();
		}
	}
}
