/*
 *  Copyright (C) 2006-2021  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.util.archive;

import java.io.IOException;
import java.io.OutputStream;
import org.dbgl.gui.interfaces.ProgressNotifyable;
import SevenZip.HRESULT;
import SevenZip.Archive.IArchiveExtractCallback;
import SevenZip.Archive.IInArchive;


public class SevenzipExtractSingleFileCallback implements IArchiveExtractCallback {

	private ProgressNotifyable prog_;
	private OutputStream outputStream_;

	public SevenzipExtractSingleFileCallback(ProgressNotifyable prog, OutputStream out) {
		prog_ = prog;
		outputStream_ = out;
	}

	@Override
	public int SetTotal(long size) {
		prog_.setTotal(size);
		return HRESULT.S_OK;
	}

	@Override
	public int SetCompleted(long completeValue) {
		prog_.setProgress(completeValue);
		return HRESULT.S_OK;
	}

	@Override
	public int PrepareOperation(int askExtractMode) {
		return HRESULT.S_OK;
	}

	@Override
	public int SetOperationResult(int operationResult) throws IOException {
		switch (operationResult) {
			case IInArchive.NExtract_NOperationResult_kOK:
				return HRESULT.S_OK;
			case IInArchive.NExtract_NOperationResult_kUnSupportedMethod:
				throw new IOException("Unsupported Method");
			case IInArchive.NExtract_NOperationResult_kCRCError:
				throw new IOException("CRC Failed");
			case IInArchive.NExtract_NOperationResult_kDataError:
				throw new IOException("Data Error");
			default:
				throw new IOException("Unknown Error");
		}
	}

	@Override
	public int GetStream(int index, OutputStream[] outStream, int askExtractMode) throws IOException {
		outStream[0] = askExtractMode == IInArchive.NExtract_NAskMode_kExtract ? outputStream_: null;
		return HRESULT.S_OK;
	}
}
