package exodos;

import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.interfaces.PreProgressNotifyable;


class AsciiProgressBar implements PreProgressNotifyable {

	final String title_;
	final long total_;
	long preProgress_, progress_;

	public AsciiProgressBar(String title, long total) {
		title_ = title;
		total_ = total;
	}

	@Override
	public void setTotal(long total) {
		// not used
	}

	@Override
	public void incrProgress(long progress) {
		progress_ += progress;
		preProgress_ = 0L;
		out();
	}

	@Override
	public void setProgress(long progress) {
		// not used
	}

	@Override
	public void setPreProgress(long preProgress) {
		preProgress_ = preProgress;
		out();
	}

	private void out() {
		int progBlocks = (int)(((float)progress_ / (float)total_) * 25f);
		int preBlocks = (int)(((float)preProgress_ / (float)total_) * 25f);
		StringBuilder s = new StringBuilder();
		s.append(StringUtils.repeat('\u2593', progBlocks));
		s.append(StringUtils.repeat('\u2592', preBlocks));
		s.append(StringUtils.repeat('\u2591', 25 - progBlocks - preBlocks));
		System.out.print(String.format("\r%s %s", StringUtils.rightPad(StringUtils.abbreviate(title_, 68), 70, '.'), s.toString()));
	}
}
