/*
 *  Copyright (C) 2006-2022  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.gui;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import org.dbgl.gui.dialog.MainWindow;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;


public class SendToProfile {

	public static final String SEND_TO_PROFILE = "sendtoprofile ";

	private static final String LOCALHOST = "localhost";

	public static void main(String[] args) {
		if (args.length < 1) {
			System.out.println(TextService.getInstance().get("external.notice.addcmdusage"));
			System.exit(1);
		}

		try (Socket socket = new Socket(LOCALHOST, SettingsService.getInstance().getIntValue("communication", "port")); PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true)) {
			printWriter.println(SEND_TO_PROFILE + args[0]);
		} catch (UnknownHostException e) {
			e.printStackTrace();
			System.exit(1);
		} catch (IOException e) {
			MainWindow.openSendToProfileDialog(args[0]);
		}
	}
}
