/* 
 * Created on 28-jun-2006 by ronald.blankendaal
 * 
 * @file $RCSfile: MainWindow.java,v $
 * @version $Revision: 1.28 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/08/09 19:02:38 $ (UTC date of last check in)
 */

package com.gui;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import swing2swt.layout.BorderLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import com.db.Database;
import com.model.Autoexec;
import com.model.Configuration;
import com.model.Developer;
import com.model.DosboxVersion;
import com.model.Genre;
import com.model.Profile;
import com.model.Publisher;
import com.model.Status;
import com.model.Template;
import com.model.Year;
import com.swtdesigner.SWTResourceManager;
import com.util.FileUtils;
import com.util.ListUtils;


public class MainWindow {

  private Table table_3;
  public static final String CAPTURES_DIR = "captures";
  public static final String TEMPLATES_DIR = "templates";
  public static final String PROFILES_DIR = "profiles";
  public static final String SETUP_CONF = "setup.conf";
  public static final String DFEND_PATH = "/Program Files/D-Fend";
  private static final int THUMB_HEIGHT = 100;
  
  private Display display;
  private Text text;
  private Table table_1;
  private Table table;
  private Link link;
  private Link link_1;
  private ToolBar toolBar_2;
  protected Shell shell;
  private java.util.List<Profile> profilesList;
  private java.util.List<DosboxVersion> dbversionsList;
  private java.util.List<Template> templatesList;
  private Database db = null;
  
  
  /**
   * Launch the application
   * @param args
   */
  public static void main(String[] args) {
    try {
      MainWindow window = new MainWindow();
      window.open();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * Open the window
   */
  public void open() {
    db = Database.getInstance();
    
    display = Display.getDefault();
    createContents();
    shell.open();
    shell.layout();
    while (!shell.isDisposed()) {
      if (!display.readAndDispatch())
        display.sleep();
    }
    display.dispose();
  
    db.shutdown();
  }
  
  /**
   * Create contents of the window
   */
  protected void createContents() {
    profilesList = db.readProfilesList();
    dbversionsList = db.readDosboxVersionsList();
    templatesList = db.readTemplatesList();

    shell = new Shell();
    shell.setLayout(new BorderLayout(0, 0));
    shell.setSize(706, 375);
    shell.setText("DOSBox Game Launcher v0.2");

    final TabFolder tabFolder = new TabFolder(shell, SWT.NONE);

    final TabItem profilesTabItem = new TabItem(tabFolder, SWT.NONE);
    profilesTabItem.setText("Profiles");

    final Composite composite = new Composite(tabFolder, SWT.NONE);
    composite.setLayout(new BorderLayout(0, 0));
    profilesTabItem.setControl(composite);
    
    final ToolBar toolBar = new ToolBar(composite, SWT.NONE);
    toolBar.setLayoutData(BorderLayout.NORTH);

    final ToolItem newItemToolItem = new ToolItem(toolBar, SWT.PUSH);
    newItemToolItem.setText("Add profile");
    newItemToolItem.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doAddProfile();
      }
    });
    
    final ToolItem newItemToolItem_2 = new ToolItem(toolBar, SWT.PUSH);
    newItemToolItem_2.setText("Edit Profile");
    newItemToolItem_2.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doEditProfile();
      }
    });
    
    final ToolItem newItemToolItem_1 = new ToolItem(toolBar, SWT.PUSH);
    newItemToolItem_1.setText("Remove profile");
    newItemToolItem_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doRemoveProfile();
      }
    });

    final TabItem dosboxTabItem = new TabItem(tabFolder, SWT.NONE);
    dosboxTabItem.setText("DOSBox versions");

    final Composite composite_1 = new Composite(tabFolder, SWT.NONE);
    composite_1.setLayout(new BorderLayout(0, 0));
    dosboxTabItem.setControl(composite_1);

    table_1 = new Table(composite_1, SWT.FULL_SELECTION | SWT.BORDER);
    table_1.addTraverseListener(new TraverseListener() {
      public void keyTraversed(final TraverseEvent e) {
        if (e.detail == SWT.TRAVERSE_RETURN)
          doRunDosbox();
      }
    });
    table_1.addMouseListener(new MouseAdapter() {
      public void mouseDoubleClick(final MouseEvent e) {
        doRunDosbox();
      }
    });
    
    table_1.setLinesVisible(true);
    table_1.setHeaderVisible(true);

    final TableColumn newColumnTableColumn_6 = new TableColumn(table_1, SWT.NONE);
    newColumnTableColumn_6.setWidth(201);
    newColumnTableColumn_6.setText("Title");

    final TableColumn newColumnTableColumn_7 = new TableColumn(table_1, SWT.NONE);
    newColumnTableColumn_7.setWidth(218);
    newColumnTableColumn_7.setText("Path");

    final TableColumn newColumnTableColumn_8 = new TableColumn(table_1, SWT.NONE);
    newColumnTableColumn_8.setWidth(100);
    newColumnTableColumn_8.setText("Default");

    final ToolBar toolBar_1 = new ToolBar(composite_1, SWT.NONE);
    toolBar_1.setLayoutData(BorderLayout.NORTH);

    final ToolItem newItemToolItem_3 = new ToolItem(toolBar_1, SWT.PUSH);
    newItemToolItem_3.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doAddDosboxVersion();
      }
    });
    newItemToolItem_3.setText("Add version");

    final ToolItem newItemToolItem_2_1 = new ToolItem(toolBar_1, SWT.PUSH);
    newItemToolItem_2_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doEditDosboxVersion();
      }
    });
    newItemToolItem_2_1.setText("Edit version");

    final ToolItem newItemToolItem_1_1 = new ToolItem(toolBar_1, SWT.PUSH);
    newItemToolItem_1_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doRemoveDosboxVersion();
      }
    });
    newItemToolItem_1_1.setText("Remove version");

    final Menu menu = new Menu(shell, SWT.BAR);
    shell.setMenuBar(menu);

    final MenuItem fileMenuItem = new MenuItem(menu, SWT.CASCADE);
    fileMenuItem.setText("File");

    final Menu menu_1 = new Menu(fileMenuItem);
    fileMenuItem.setMenu(menu_1);

    final MenuItem dfendImportMenuItem = new MenuItem(menu_1, SWT.NONE);
    dfendImportMenuItem.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doDFendImport();
      }
    });
    dfendImportMenuItem.setText("D-Fend Import");

    new MenuItem(menu_1, SWT.SEPARATOR);

    final MenuItem exitMenuItem = new MenuItem(menu_1, SWT.NONE);
    exitMenuItem.setText("Exit");
    exitMenuItem.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        shell.close();
      }
    });

    final ScrolledComposite scrolledComposite = new ScrolledComposite(composite, SWT.BORDER | SWT.H_SCROLL);
    scrolledComposite.setMinHeight(THUMB_HEIGHT + 20);
    scrolledComposite.setLayoutData(BorderLayout.SOUTH);

    toolBar_2 = new ToolBar(scrolledComposite, SWT.NONE);
    scrolledComposite.setContent(toolBar_2);

    final SashForm sashForm = new SashForm(composite, SWT.NONE);
    
    table = new Table(sashForm, SWT.FULL_SELECTION | SWT.BORDER);

    table.setLinesVisible(true);
    table.setLayoutData(BorderLayout.WEST);
    table.setHeaderVisible(true);
    table.addTraverseListener(new TraverseListener() {
      public void keyTraversed(final TraverseEvent e) {
        if ((e.stateMask == SWT.CTRL) && (e.detail == SWT.TRAVERSE_RETURN)) {
          doEditProfile();
        } else if ((e.stateMask == SWT.SHIFT) && (e.detail == SWT.TRAVERSE_RETURN)) {
          doRunProfileSetup();
        } else if (e.detail == SWT.TRAVERSE_RETURN) {
          doRunProfile();
        } 
      }
    });
    table.addMouseListener(new MouseAdapter() {
      public void mouseDoubleClick(final MouseEvent e) {
        doRunProfile();
      }
    });

    final TableColumn newColumnTableColumn = new TableColumn(table, SWT.NONE);
    newColumnTableColumn.setMoveable(true);
    newColumnTableColumn.setWidth(100);
    newColumnTableColumn.setText("Title");

    final TableColumn newColumnTableColumn_5 = new TableColumn(table, SWT.NONE);
    newColumnTableColumn_5.setMoveable(true);
    newColumnTableColumn_5.setWidth(40);
    newColumnTableColumn_5.setText("Setup");

    final TableColumn newColumnTableColumn_1 = new TableColumn(table, SWT.NONE);
    newColumnTableColumn_1.setMoveable(true);
    newColumnTableColumn_1.setWidth(100);
    newColumnTableColumn_1.setText("Developer");

    final TableColumn newColumnTableColumn_2 = new TableColumn(table, SWT.NONE);
    newColumnTableColumn_2.setMoveable(true);
    newColumnTableColumn_2.setWidth(100);
    newColumnTableColumn_2.setText("Publisher");

    final TableColumn newColumnTableColumn_3 = new TableColumn(table, SWT.NONE);
    newColumnTableColumn_3.setMoveable(true);
    newColumnTableColumn_3.setWidth(100);
    newColumnTableColumn_3.setText("Genre");

    final TableColumn newColumnTableColumn_4 = new TableColumn(table, SWT.NONE);
    newColumnTableColumn_4.setMoveable(true);
    newColumnTableColumn_4.setWidth(40);
    newColumnTableColumn_4.setText("Year");

    final TableColumn newColumnTableColumn_9 = new TableColumn(table, SWT.NONE);
    newColumnTableColumn_9.setMoveable(true);
    newColumnTableColumn_9.setWidth(60);
    newColumnTableColumn_9.setText("Status");

    final TableColumn newColumnTableColumn_10 = new TableColumn(table, SWT.NONE);
    newColumnTableColumn_10.setMoveable(true);
    newColumnTableColumn_10.setWidth(40);
    newColumnTableColumn_10.setText("Favorite");

    final TableColumn newColumnTableColumn_11 = new TableColumn(table, SWT.NONE);
    newColumnTableColumn_11.setMoveable(true);
    newColumnTableColumn_11.setWidth(40);
    newColumnTableColumn_11.setText("ID");

    table.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        displayProfileInformation();
      }
    });

    final Composite informationGroup = new Composite(sashForm, SWT.NONE);
    informationGroup.setLayout(new BorderLayout(0, 0));
    text = new Text(informationGroup, SWT.V_SCROLL | SWT.MULTI | SWT.READ_ONLY | SWT.BORDER | SWT.WRAP);

    final Composite composite_2 = new Composite(informationGroup, SWT.NONE);
    composite_2.setLayout(new BorderLayout(0, 0));
    composite_2.setLayoutData(BorderLayout.SOUTH);

    link = new Link(composite_2, SWT.NONE);
    link.setLayoutData(BorderLayout.NORTH);
    link.setText(" ");
    link.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        Program p = Program.findProgram(".html");
        if (p != null) p.execute (e.text);
      }
    });
    
    link_1 = new Link(composite_2, SWT.NONE);
    link_1.setText(" ");
    link_1.setLayoutData(BorderLayout.SOUTH);
    link_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        Program p = Program.findProgram(".html");
        if (p != null) p.execute (e.text);
      }
    });
    
    sashForm.setWeights(new int[] {5, 2});

    final TabItem templatesTabItem = new TabItem(tabFolder, SWT.NONE);
    templatesTabItem.setText("Templates");

    final Composite composite_1_1 = new Composite(tabFolder, SWT.NONE);
    composite_1_1.setLayout(new BorderLayout(0, 0));
    templatesTabItem.setControl(composite_1_1);

    table_3 = new Table(composite_1_1, SWT.FULL_SELECTION | SWT.BORDER);
    table_3.setLinesVisible(true);
    table_3.setHeaderVisible(true);

    final TableColumn newColumnTableColumn_6_1 = new TableColumn(table_3, SWT.NONE);
    newColumnTableColumn_6_1.setWidth(300);
    newColumnTableColumn_6_1.setText("Title");

    final TableColumn newColumnTableColumn_8_1 = new TableColumn(table_3, SWT.NONE);
    newColumnTableColumn_8_1.setWidth(50);
    newColumnTableColumn_8_1.setText("Default");

    final ToolBar toolBar_1_1 = new ToolBar(composite_1_1, SWT.NONE);
    toolBar_1_1.setLayoutData(BorderLayout.NORTH);

    final ToolItem newItemToolItem_3_1 = new ToolItem(toolBar_1_1, SWT.PUSH);
    newItemToolItem_3_1.setText("Add template");
    newItemToolItem_3_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doAddTemplate();
      }
    });

    final ToolItem newItemToolItem_2_1_1 = new ToolItem(toolBar_1_1, SWT.PUSH);
    newItemToolItem_2_1_1.setText("Edit template");
    newItemToolItem_2_1_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doEditTemplate();
      }
    });

    final ToolItem newItemToolItem_1_1_1 = new ToolItem(toolBar_1_1, SWT.PUSH);
    newItemToolItem_1_1_1.setText("Remove template");
    newItemToolItem_1_1_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doRemoveTemplate();
      }
    });
        
    // init values
    for (Profile prof: profilesList) addProfileToTable(prof);
    for (DosboxVersion dbversion: dbversionsList) addDosboxVersionToTable(dbversion);
    for (Template template: templatesList) addTemplateToTable(template);
  }
  
  private void displayNotes(String notes) {
    text.setText(notes);
  }
  
  private void displayLinks(String link1, String link2) {
    if (link1 != null && !link1.equals(""))
      link.setText("<a href=\"" + link1 + "\">" + link1 + "</a>");
    else
      link.setText(" ");
    
    if (link2 != null && !link2.equals(""))
      link_1.setText("<a href=\"" + link2 + "\">" + link2 + "</a>");
    else
      link_1.setText(" ");
  }
  
  private void displayScreenshots(int profileId) {
    ToolItem[] toolItems = toolBar_2.getItems();
    for (int i = 0; i < toolItems.length; i++)
      toolItems[i].dispose();
    File path = new File(CAPTURES_DIR + System.getProperty("file.separator") + profileId + System.getProperty("file.separator"));
    String[] files = path.list();
    if (files != null) {
      for (int i = 0; i < files.length; i++) {
        if (files[i].toLowerCase().endsWith(".png")) {
          Image thumb = SWTResourceManager.getImage(MainWindow.class,
                  "/" + CAPTURES_DIR + System.getProperty("file.separator") +
                  profileId + System.getProperty("file.separator") + files[i]);
          ImageData smallThumb = thumb.getImageData();
          int width = smallThumb.width;
          int height = smallThumb.height;
          double factor = (double)THUMB_HEIGHT / (double)height;
          smallThumb = smallThumb.scaledTo((int)(width * factor), (int)(height * factor));
          final ToolItem toolItem = new ToolItem(toolBar_2, SWT.PUSH);
          toolItem.setImage(new Image(display, smallThumb));
          toolItem.setToolTipText("/" + CAPTURES_DIR + System.getProperty("file.separator") +
                  profileId + System.getProperty("file.separator") + files[i]);
          toolItem.setText(files[i]);
          toolItem.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent e) {
              final Thumb thumbDialog = new Thumb(shell);
              thumbDialog.setThumb(toolItem.getToolTipText());
              thumbDialog.open();
            }
          });
          toolItem.addDisposeListener(new DisposeListener() {
            public void widgetDisposed(DisposeEvent e) {
              toolItem.getImage().dispose();
            }
          });
        }
      }
    }
    toolBar_2.setVisible(toolBar_2.getItemCount() != 0);
    toolBar_2.pack();
  }
  
  private void doAddProfile() {
    if (ListUtils.findTIDefaultDosboxVersion(dbversionsList) == -1) {
      GeneralPurposeDialogs.infoMessage(shell, "You must first define a default DOSBox version!");
      return;
    }
    final EditProfileDialog addProfileDialog = new EditProfileDialog(shell);
    addProfileDialog.setDatabase(db);
    Profile profile = (Profile)addProfileDialog.open();
    if (profile != null) {
      profilesList.add(profile);
      addProfileToTable(profile);
      table.setSelection(table.getItemCount() - 1);
      table.showSelection();
      table.setFocus();
    }
  }
  
  private void doAddDosboxVersion() {
    final EditDosboxVersionDialog addDosboxVersionDialog = new EditDosboxVersionDialog(shell);
    addDosboxVersionDialog.setDatabase(db);
    DosboxVersion dbversion = (DosboxVersion)addDosboxVersionDialog.open();
    if (dbversion != null) {
      dbversionsList.add(dbversion);
      addDosboxVersionToTable(dbversion);
      table_1.setSelection(table_1.getItemCount() - 1);
      table_1.showSelection();
      table_1.setFocus();
    }
  }
  
  private void doAddTemplate() {
    if (ListUtils.findTIDefaultDosboxVersion(dbversionsList) == -1) {
      GeneralPurposeDialogs.infoMessage(shell, "You must first define a default DOSBox version!");
      return;
    }
    final EditTemplateDialog addTemplateDialog = new EditTemplateDialog(shell);
    addTemplateDialog.setDatabase(db);
    Template template = (Template)addTemplateDialog.open();
    if (template != null) {
      templatesList.add(template);
      addTemplateToTable(template);
      table_3.setSelection(table_3.getItemCount() - 1);
      table_3.showSelection();
      table_3.setFocus();
    }
  }
  
  private void doEditProfile() {
    int index = table.getSelectionIndex();
    if (index != -1) {
      final EditProfileDialog editProfileDialog = new EditProfileDialog(shell);
      editProfileDialog.setDatabase(db);
      editProfileDialog.setProfile(profilesList.get(index));
      Profile profile = (Profile)editProfileDialog.open();
      if (profile != null) {
        profilesList.set(index, profile);
        setTableItem(table.getItem(index), profile);
        displayProfileInformation();
      }
    }
  }
  
  private void doEditDosboxVersion() {
    int index = table_1.getSelectionIndex();
    if (index != -1) {
      final EditDosboxVersionDialog editDosboxVersionDialog = new EditDosboxVersionDialog(shell);
      editDosboxVersionDialog.setDatabase(db);
      editDosboxVersionDialog.setDosboxVersion(dbversionsList.get(index));
      DosboxVersion dbversion = (DosboxVersion)editDosboxVersionDialog.open();
      if (dbversion != null) {
        dbversionsList.set(index, dbversion);
        setTableItem(table_1.getItem(index), dbversion);
      }
    }
  }
  
  private void doEditTemplate() {
    int index = table_3.getSelectionIndex();
    if (index != -1) {
      final EditTemplateDialog editTemplateDialog = new EditTemplateDialog(shell);
      editTemplateDialog.setDatabase(db);
      editTemplateDialog.setTemplate(templatesList.get(index));
      Template template = (Template)editTemplateDialog.open();
      if (template != null) {
        templatesList.set(index, template);
        setTableItem(table_3.getItem(index), template);
      }
    }
  }
  
  private void doRemoveProfile() {
    int index = table.getSelectionIndex();
    if (index != -1) {
      if (GeneralPurposeDialogs.confirmMessage(shell, "Do you want to remove the selected profile?")) {
        int profileId = (profilesList.get(index)).getId();
        db.removeProfile(profileId);
        table.remove(index);
        profilesList.remove(index);
        String conffile = PROFILES_DIR + System.getProperty("file.separator") + profileId + ".conf";
        if (GeneralPurposeDialogs.confirmMessage(shell,
                "Do you also want to remove the associated conf file " + conffile + " ?")) {
          FileUtils.removeFile(conffile);
        }
        displayProfileInformation();
        /*
        SWTResourceManager.disposeImages();
        String captures = CAPTURES_DIR + System.getProperty("file.separator") + profileId;
        if (GeneralPurposeDialogs.confirmMessage(shell,
          "Do you also want to remove the associated captures in the directory " + captures + " ?")) {
          FileUtils.removeDir(captures);
        }
        */
      }
    }
  }

  private void doRemoveDosboxVersion() {
    int index = table_1.getSelectionIndex();
    if (index != -1) {
      if (GeneralPurposeDialogs.confirmMessage(shell, "Do you want to remove the selected DOSBox version?")) {
        db.removeDosboxVersion((dbversionsList.get(index)).getId());
        table_1.remove(index);
        dbversionsList.remove(index);
      }
    }
  }
  
  private void doRemoveTemplate() {
    int index = table_3.getSelectionIndex();
    if (index != -1) {
      if (GeneralPurposeDialogs.confirmMessage(shell, "Do you want to remove the selected template?")) {
        int templateId = (templatesList.get(index)).getId();
        db.removeTemplate(templateId);
        table_3.remove(index);
        templatesList.remove(index);
        String conffile = TEMPLATES_DIR + System.getProperty("file.separator") + templateId + ".conf";
        if (GeneralPurposeDialogs.confirmMessage(shell,
                "Do you also want to remove the associated conf file " + conffile + " ?")) {
          FileUtils.removeFile(conffile);
        }
      }
    }
  }
  
  private void addProfileToTable(Profile prof) {
    final TableItem newItemTableItem = new TableItem(table, SWT.BORDER); 
    setTableItem(newItemTableItem, prof);
  }
  
  private void addDosboxVersionToTable(DosboxVersion dbversion) {
    final TableItem newItemTableItem = new TableItem(table_1, SWT.BORDER); 
    setTableItem(newItemTableItem, dbversion);
  }
  
  private void addTemplateToTable(Template template) {
    final TableItem newItemTableItem = new TableItem(table_3, SWT.BORDER); 
    setTableItem(newItemTableItem, template);
  }
  
  private void setTableItem(TableItem newItemTableItem, Profile prof) {
    newItemTableItem.setText(0, prof.getTitle()); // game title
    newItemTableItem.setText(1, prof.hasSetup()); // setup
    newItemTableItem.setText(2, prof.getDeveloperName()); // developer
    newItemTableItem.setText(3, prof.getPublisherName()); // publisher
    newItemTableItem.setText(4, prof.getGenre()); // genre
    newItemTableItem.setText(5, prof.getYear()); // year
    newItemTableItem.setText(6, prof.getStatus()); // status
    newItemTableItem.setText(7, prof.isFavoriteString()); // favorite
    newItemTableItem.setText(8, String.valueOf(prof.getId())); // ID
  }
  
  private void setTableItem(TableItem newItemTableItem, DosboxVersion dbversion) {
    newItemTableItem.setText(0, dbversion.getTitle()); // dosbox version title
    newItemTableItem.setText(1, dbversion.getPath());  // path
    newItemTableItem.setText(2, dbversion.isDefaultVersionString()); // default
  }
  
  private void setTableItem(TableItem newItemTableItem, Template template) {
    newItemTableItem.setText(0, template.getTitle()); // template title
    newItemTableItem.setText(1, template.isDefaultString()); // default
  }
  
  private void doRunProfile() {
    int index = table.getSelectionIndex();
    if (index != -1) {
      Profile prof = profilesList.get(index);
      doRunProfile(prof, prof.getId() + ".conf");
    }
  }
  
  private void doRunProfile(Profile prof, String filename) {
    try {
      int dbversionIndex = ListUtils.findTIDosboxVersion(dbversionsList, prof.getDbversionId());
      DosboxVersion dbversion = dbversionsList.get(dbversionIndex);
      String confs = "";
      if (dbversion.isMultiConfig()) {
        // selected default dosbox config file
        confs = " -conf \"" + dbversion.getPath() + "dosbox.conf\""; 
      }
      // add profile-specific settings
      confs += " -conf \"" + PROFILES_DIR + System.getProperty("file.separator") + filename + "\"";
      String cmd = dbversion.getPath() + "DOSBox.exe" + confs;
      System.out.println(cmd);
      Runtime.getRuntime().exec(cmd);
    } catch (IOException e) {
      System.err.println("Profile could not be started!!\n");
    }
  }
  
  private void doRunProfileSetup() {
    int index = table.getSelectionIndex();
    if (index != -1) {
      Profile prof = profilesList.get(index);
      Configuration conf = new Configuration(PROFILES_DIR + System.getProperty("file.separator") + prof.getId() + ".conf");
      Autoexec autoexec = new Autoexec(conf.getValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC));
      autoexec.setSetup(prof.getSetup());
      autoexec.setSetupParameters(prof.getSetupParameters());
      conf.setValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC, autoexec.toString(true));
      conf.saveToFile(PROFILES_DIR + System.getProperty("file.separator") + SETUP_CONF);
      doRunProfile(prof, SETUP_CONF);
    }
  }
  
  private void doRunDosbox() {
    int index = table_1.getSelectionIndex();
    if (index != -1) {
      DosboxVersion dbversion = dbversionsList.get(index);
      try {
        Runtime.getRuntime().exec(dbversion.getPath() + "DOSBox.exe");
      } catch (IOException e) {
        System.err.println("Dosbox could not be started!!\n");
      }
    }
  }
  
  private void doDFendImport() {
    int defaultDosboxVersionIndex = ListUtils.findTIDefaultDosboxVersion(dbversionsList);
    if (defaultDosboxVersionIndex == -1) {
      GeneralPurposeDialogs.infoMessage(shell, "You must first define a default DOSBox version!");
      return;
    }
    
    FileDialog dialog = new FileDialog (shell, SWT.OPEN);
    dialog.setFilterPath(DFEND_PATH);
    dialog.setFileName("Profiles.dat");
    dialog.setFilterNames (new String [] {"D-Fend Profiles"});
    dialog.setFilterExtensions (new String [] {"Profiles.dat"});
    String dfendProfilesFile = dialog.open();
    if (dfendProfilesFile == null)
      return;
    
    DosboxVersion defaultDBVersion = dbversionsList.get(defaultDosboxVersionIndex);
    Configuration standardProfile = new Configuration(defaultDBVersion.getPath() + "dosbox.conf");
    Configuration profiles = new Configuration(dfendProfilesFile, false);
    Iterator it = profiles.getSections().keySet().iterator();
    while (it.hasNext()) {
      String title = (String)it.next();
      String profFile = profiles.getValue(title, "prof");
      String confFile = profiles.getValue(title, "conf");
      boolean favorite = profiles.getValue(title, "fav").equals("1");
      Configuration dfendExtra = new Configuration(profFile, false);
      String setup = dfendExtra.getValue("Extra", "Setup").toLowerCase();
      String setupParams = dfendExtra.getValue("Extra", "SetupParameters");
      String notes = dfendExtra.getValue("ExtraInfo", "Notes");
      String dev = dfendExtra.getValue("ExtraInfo", "Developer");
      String pub = dfendExtra.getValue("ExtraInfo", "Publisher");
      String gen = dfendExtra.getValue("ExtraInfo", "Genre");
      String yr = dfendExtra.getValue("ExtraInfo", "Year");
      String st = "Unknown";
      String cap = dfendExtra.getValue("dosbox", "captures");
      int devIndex = -1;
      int publIndex = -1;
      int genIndex = -1;
      int yrIndex = -1;
      int statIndex = -1;
      Iterator devIt = db.readDevelopersList().iterator();
      Iterator pubIt = db.readPublishersList().iterator();
      Iterator genIt = db.readGenresList().iterator();
      Iterator yrIt = db.readYearsList().iterator();
      Iterator statIt = db.readStatusList().iterator();
      while (devIt.hasNext()) {
        Developer developer = (Developer)devIt.next();
        if (developer.getName().equals(dev)) { devIndex = developer.getId(); break;}
      }
      while (pubIt.hasNext()) {
        Publisher publisher = (Publisher)pubIt.next();
        if (publisher.getName().equals(pub)) { publIndex = publisher.getId(); break;}
      }
      while (genIt.hasNext()) {
        Genre genre = (Genre)genIt.next();
        if (genre.getName().equals(gen)) { genIndex = genre.getId(); break;}
      }
      while (yrIt.hasNext()) {
        Year year = (Year)yrIt.next();
        if (year.getYear().equals(yr)) { yrIndex = year.getId(); break;}
      }
      while (statIt.hasNext()) {
        Status stat = (Status)statIt.next();
        if (stat.getStat().equals(st)) { statIndex = stat.getId(); break;}
      }
      int profileId = db.addOrEditProfile(title, dev, pub, gen, yr, st, setup, setupParams, notes,
              "", "", favorite, devIndex, publIndex, genIndex, yrIndex, statIndex,
              defaultDBVersion.getId(), -1);
      Configuration dfendProfile = new Configuration(confFile);
      Autoexec autoexec = new Autoexec(dfendProfile.getValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC));
      dfendProfile.setValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC, autoexec.toString(false));
      setCapturesDir(dfendProfile, profileId, cap);
      // clean up profile configuration
      dfendProfile.removeSection("directserial");
      dfendProfile.removeSection("modem");
      dfendProfile.removeSection("ipx");
      dfendProfile.removeSection("sdl");
      dfendProfile.removeValue("gus", "base");
      dfendProfile.removeValue("gus", "rate");
      dfendProfile.removeValue("sblaster", "base");
      dfendProfile.removeValue("sblaster", "type");
      if (dfendProfile.getValue("midi", "mpu401").equals("true")) {
        if (dfendProfile.getValue("midi", "intelligent").equals("true")) {
          dfendProfile.setValue("midi", "mpu401", "intelligent");
        } else if (dfendProfile.getValue("midi", "intelligent").equals("false")) {
          dfendProfile.setValue("midi", "mpu401", "uart");
        }
      } else if (dfendProfile.getValue("midi", "mpu401").equals("false")) {
        dfendProfile.setValue("midi", "mpu401", "none");
      }
      dfendProfile.removeValue("midi", "intelligent");
      dfendProfile.substract(standardProfile);
      dfendProfile.saveToFile(PROFILES_DIR + System.getProperty("file.separator") + profileId + ".conf");
    }
    
    profilesList = db.readProfilesList();
    for (Profile prof: profilesList) addProfileToTable(prof);
  }
  
  public static void setCapturesDir(Configuration profileConf, int profileId, String srcCap) {
    String capturesDir = FileUtils.getCwd();
    if (capturesDir != null) {
      capturesDir += File.separatorChar + CAPTURES_DIR + File.separatorChar + profileId;
      profileConf.setValue("dosbox", "captures", capturesDir);
      
      // Create directory and optionally copy files from src to dst
      FileUtils.createDir(capturesDir);
      if (srcCap != null)
        FileUtils.copyFiles(srcCap, CAPTURES_DIR + File.separatorChar + profileId + File.separatorChar);
    }
  }

  private void displayProfileInformation() {
    int index = table.getSelectionIndex();
    if (index != -1) {
      Profile prof = profilesList.get(index);
      displayScreenshots(prof.getId());
      displayNotes(prof.getNotes());
      displayLinks(prof.getLink1(), prof.getLink2());
    } else {
      displayScreenshots(-1);
      displayNotes("");
      displayLinks("", "");
    }
  }
}
