/* 
 * Created on Jul 23, 2006 by ronald.blankendaal
 * 
 * @file $RCSfile: Mount.java,v $
 * @version $Revision: 1.4 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/08/09 19:02:37 $ (UTC date of last check in)
 */

package com.model;

import com.util.StringUtils;


public class Mount {

  public enum MountingType { DIR, IMAGE, PHYSFS };
  
  private MountingType mountingType;
  private String mountAs;
  private char driveletter;
  private String label;
  private String path;
  private boolean ioctl;
  private String write;
  
  
  public Mount(MountingType mountingType, String mountAs, String driveletter, String path,
          String label, boolean ioctl, String write) {
    this.mountingType = mountingType;
    this.mountAs = mountAs.toLowerCase();
    this.driveletter = driveletter.charAt(0);
    this.path = StringUtils.fixDir(path.toLowerCase());
    this.label = label.toLowerCase();
    this.ioctl = ioctl;
    this.write = StringUtils.fixDir(write.toLowerCase());;
  }

  private void init() {
    mountingType = MountingType.DIR;
    mountAs = "";
    driveletter = '\0';
    label = "";
    path = "";
    ioctl = false;
    write = "";
  }

  public Mount(String mount) {
    init();
    if (mount.equals(""))
      return;
    
    int spaceIndex = mount.indexOf(' ');
    driveletter = mount.charAt(spaceIndex + 1);
    
    int firstQuoteIndex = mount.indexOf('"');
    int secondQuoteIndex = mount.lastIndexOf('"');
    path = mount.substring(firstQuoteIndex + 1, secondQuoteIndex);
    
    if (mount.startsWith("mount ")) {
      int typeIndex = mount.indexOf("-t ");
      if (typeIndex != -1) {
        int spaceIndex2 = mount.indexOf(" ", typeIndex + 3);
        if (spaceIndex2 == -1) spaceIndex2 = mount.length();
        mountAs = mount.substring(typeIndex + 3, spaceIndex2);
      }
      int labelIndex = mount.indexOf("-label ");
      if (labelIndex != -1) {
        int spaceIndex2 = mount.indexOf(" ", labelIndex + 7);
        if (spaceIndex2 == -1) spaceIndex2 = mount.length();
        label = mount.substring(labelIndex + 7, spaceIndex2);
      }
      if (mount.indexOf("-ioctl") != -1) {
        ioctl = true;
      }
      
      // now, lets see if its a physfs mount (zipfile)
      if (path.endsWith(".zip:\\")) {
        mountingType = MountingType.PHYSFS;
        int colonIndex1 = path.indexOf(":");
        if (colonIndex1 == 1)
          colonIndex1 = path.indexOf(":", colonIndex1 + 1);
        int colonIndex2 = path.lastIndexOf(":");
        if (colonIndex1 != colonIndex2) {
          write = StringUtils.fixDir(path.substring(0, colonIndex1));
          path = path.substring(colonIndex1 + 1, colonIndex2);
        } else {
          path = path.substring(0, colonIndex2);
        }
      }
    } else if (mount.startsWith("imgmount ")) {
      mountingType = MountingType.IMAGE;
      mountAs = "iso";
    }
    
    if (mountingType != MountingType.PHYSFS) {
      path = StringUtils.fixDir(path);
    }
  }
  
  public String toString() {
    StringBuffer result = new StringBuffer();
    switch (mountingType) {
      case DIR: 
        result.append("mount " + driveletter + " \"" + path + "\\\"");
        if (ioctl) result.append(" -ioctl");
        break;
      case PHYSFS:
        result.append("mount " + driveletter + " \"");
        if (!write.equals("")) result.append(write + "\\:");
        result.append(path + ":\\\"");
        break;
      case IMAGE:
        result.append("imgmount " + driveletter + " \"" + path + "\"");
        break;
    }
    if (!label.equals("")) result.append(" -label " + label);
    if (!mountAs.equals("")) result.append(" -t " + mountAs);
    return result.toString();
  }

  public char getDriveletter() {
    return driveletter;
  }

  public String getDriveletterString() {
    return String.valueOf(driveletter);
  }

  public boolean isIoctl() {
    return ioctl;
  }

  public String getLabel() {
    return label;
  }

  public String getPath() {
    return path;
  }

  public MountingType getMountingType() {
    return mountingType;
  }
  
  public String getMountAs() {
    return mountAs;
  }
  
  public String getWrite() {
    return write;
  }
}
