/* 
 * Created on Jul 28, 2006 by ronald.blankendaal
 * 
 * @file $RCSfile: ListUtils.java,v $
 * @version $Revision: 1.5 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/08/13 11:25:23 $ (UTC date of last check in)
 */

package com.util;

import java.util.List;
import com.model.DosboxVersion;
import com.model.Profile;
import com.model.Template;


public abstract class ListUtils {

  public static int findTIDosboxVersion(List<DosboxVersion> dbversionsList, int dbversionId) {
    int result = 0;
    for (DosboxVersion dbv: dbversionsList) {
      if (dbv.getId() == dbversionId) return result;
      result++;
    }
    return -1; // not found
  }
  
  public static int findTIDefaultDosboxVersion(List<DosboxVersion> dbversionsList) {
    int result = 0;
    for (DosboxVersion dbv: dbversionsList) {
      if (dbv.isDefaultVersion()) return result;
      result++;
    }
    return -1; // not found
  }
  
  public static int findTIDefaultTemplate(List<Template> templatesList) {
    int result = 0;
    for (Template template: templatesList) {
      if (template.isDefault()) return result;
      result++;
    }
    return -1; // not found
  }
  
  public static int findTIProfile(List<Profile> profilesList, int profileId) {
	  int result = 0;
	  for (Profile prof: profilesList) {
		  if (prof.getId() == profileId) return result;
		  result++;
	  }
	  return -1; // not found
  }
}
