/* 
 * Created on 2-jul-2006 by ronald.blankendaal
 * 
 * @file $RCSfile: EditDosboxVersionDialog.java,v $
 * @version $Revision: 1.6 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/08/09 19:02:38 $ (UTC date of last check in)
 */

package com.gui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import com.db.Database;
import com.model.DosboxVersion;


public class EditDosboxVersionDialog extends Dialog {

  private Text path;
  private Text title;
  protected Object result;
  protected Shell shell;

  private Database db;
  
  /**
   * Create the dialog
   * @param parent
   * @param style
   */
  public EditDosboxVersionDialog(Shell parent, int style) {
    super(parent, style);
  }

  /**
   * Create the dialog
   * @param parent
   */
  public EditDosboxVersionDialog(Shell parent) {
    this(parent, SWT.NONE);
  }

  public void setDatabase(Database db) {
    this.db = db;
  }
  
  public void setDosboxVersion(DosboxVersion dbversion) {
    this.result = dbversion;
  }

  /**
   * Open the dialog
   * @return the result
   */
  public Object open() {
    createContents();
    shell.open();
    shell.layout();
    Display display = getParent().getDisplay();
    while (!shell.isDisposed()) {
      if (!display.readAndDispatch())
        display.sleep();
    }
    return result;
  }

  /**
   * Create contents of the dialog
   */
  protected void createContents() {
    shell = new Shell(getParent(), SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
    final GridLayout gridLayout = new GridLayout();
    gridLayout.numColumns = 3;
    shell.setLayout(gridLayout);
    shell.setSize(500, 375);
    if (result != null) {
      // meaning we are essentially editing an existing dosbox version
      shell.setText("Edit Dosbox Version");
    } else {
      shell.setText("Add Dosbox Version");
    }

    final Label titleLabel = new Label(shell, SWT.NONE);
    titleLabel.setText("Title");

    title = new Text(shell, SWT.BORDER);
    title.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(shell, SWT.NONE);

    final Label pathLabel = new Label(shell, SWT.NONE);
    pathLabel.setText("Path");

    path = new Text(shell, SWT.BORDER);
    path.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Button browseButton = new Button(shell, SWT.NONE);
    browseButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        DirectoryDialog dialog = new DirectoryDialog (shell);
        dialog.setFilterPath (path.getText());
        String result = dialog.open();
        if (result != null) {
          path.setText(result);
        }
      }
    });
    browseButton.setText("Browse..");

    final Label multiconfSupportLabel = new Label(shell, SWT.NONE);
    multiconfSupportLabel.setText("Multiconf support");

    final Button multiconf = new Button(shell, SWT.CHECK);
    new Label(shell, SWT.NONE);

    final Label defaultLabel = new Label(shell, SWT.NONE);
    defaultLabel.setText("Default");

    final Button isDefaultButton = new Button(shell, SWT.CHECK);
    new Label(shell, SWT.NONE);

    final Button okButton = new Button(shell, SWT.NONE);
    okButton.setText("OK");
    okButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        if (!isValid())
          return;
        if (!path.getText().endsWith(System.getProperty("file.separator")))
          path.setText(path.getText() + System.getProperty("file.separator"));
        int dbversionId = db.addOrEditDosboxVersion(title.getText(), path.getText(),
                multiconf.getSelection(), isDefaultButton.getSelection(),
                result != null ? ((DosboxVersion)result).getId(): -1);
        result = new DosboxVersion(dbversionId, title.getText(), path.getText(),
                multiconf.getSelection(), isDefaultButton.getSelection());
        shell.close();
      }
    });
    
    final Button cancelButton = new Button(shell, SWT.NONE);
    cancelButton.setText("Cancel");
    cancelButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        result = null;
        shell.close();
      }
    });
    
    // init values
    if (result != null) {
      // meaning we are essentially editing an existing dosbox version
      // so we need to set previous values
      title.setText(((DosboxVersion)result).getTitle());
      path.setText(((DosboxVersion)result).getPath());
      isDefaultButton.setSelection(((DosboxVersion)result).isDefaultVersion());
      multiconf.setSelection(((DosboxVersion)result).isMultiConfig());
    }
  }
  
  private boolean isValid() {
    GeneralPurposeDialogs.initErrorDialog();
    if (title.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter a dosbox version title", title);
    if (path.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter a path to the dosbox executable", path);
    return !GeneralPurposeDialogs.displayErrorDialog(shell);
  }
}
