/* 
 * Created on Jul 9, 2006 by ronald.blankendaal
 * 
 * @file $RCSfile: EditMountDialog.java,v $
 * @version $Revision: 1.9 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/08/09 19:02:38 $ (UTC date of last check in)
 */

package com.gui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import com.model.Mount;


public class EditMountDialog extends Dialog {

  private Text mount_label_1;
  private Combo mount_type_1;
  private Text write;
  private Text zip;
  private Button mountZipButton;
  private Button mountImageAsButton;
  private Button mountADirectoryButton;
  private Text mount_image;
  private Text mount_label;
  private Combo mount_type;
  private Text mount_dir;
  private Combo driveletter;
  protected Object result;
  protected Shell shell;

  /**
   * Create the dialog
   * @param parent
   * @param style
   */
  public EditMountDialog(Shell parent, int style) {
    super(parent, style);
  }

  /**
   * Create the dialog
   * @param parent
   */
  public EditMountDialog(Shell parent) {
    this(parent, SWT.NONE);
  }

  public void setMount(String mount) {
    this.result = mount;
  }
  
  /**
   * Open the dialog
   * @return the result
   */
  public Object open() {
    createContents();
    shell.open();
    shell.layout();
    Display display = getParent().getDisplay();
    while (!shell.isDisposed()) {
      if (!display.readAndDispatch())
        display.sleep();
    }
    return result;
  }

  /**
   * Create contents of the dialog
   */
  protected void createContents() {
    shell = new Shell(getParent(), SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
    final GridLayout gridLayout = new GridLayout();
    gridLayout.numColumns = 4;
    shell.setLayout(gridLayout);
    shell.setSize(500, 375);
    if (result != null) {
      // meaning we are essentially editing an existing mount point
      shell.setText("Edit Mount Point");
    } else {
      shell.setText("Add Mount Point");
    }

    final Label driveLetterLabel = new Label(shell, SWT.NONE);
    driveLetterLabel.setText("Drive Letter");

    driveletter = new Combo(shell, SWT.READ_ONLY);
    driveletter.setItems(new String[] {"a", "b", "c", "d", "e", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y"});
    driveletter.select(2);
    driveletter.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(shell, SWT.NONE);
    new Label(shell, SWT.NONE);

    mountADirectoryButton = new Button(shell, SWT.RADIO);
    mountADirectoryButton.setText("Mount Directory");

    mount_dir = new Text(shell, SWT.BORDER);
    mount_dir.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

    final Button browseButton = new Button(shell, SWT.NONE);
    browseButton.setText("Browse..");
    browseButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        DirectoryDialog dialog = new DirectoryDialog (shell);
        dialog.setFilterPath (mount_dir.getText());
        String result = dialog.open();
        if (result != null) {
          mount_dir.setText(result);
        }
      }
    });
    
    new Label(shell, SWT.NONE);

    final Label asLabel = new Label(shell, SWT.NONE);
    asLabel.setText("As");

    mount_type = new Combo(shell, SWT.READ_ONLY);
    mount_type.setItems(new String[] {"", "cdrom", "dir", "floppy"});
    mount_type.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(shell, SWT.NONE);
    new Label(shell, SWT.NONE);

    final Label label = new Label(shell, SWT.NONE);
    label.setText("Label");

    mount_label = new Text(shell, SWT.BORDER);
    mount_label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(shell, SWT.NONE);
    new Label(shell, SWT.NONE);

    final Label lowlevelCdLabel = new Label(shell, SWT.NONE);
    lowlevelCdLabel.setText("Force ioctl");

    final Button ioctlButton = new Button(shell, SWT.CHECK);
    ioctlButton.setLayoutData(new GridData());
    new Label(shell, SWT.NONE);

    final Label label_1 = new Label(shell, SWT.SEPARATOR | SWT.HORIZONTAL);
    label_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 4, 1));

    mountImageAsButton = new Button(shell, SWT.RADIO);
    mountImageAsButton.setText("Mount CD-Image");

    mount_image = new Text(shell, SWT.BORDER);
    mount_image.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

    final Button browseButton_1 = new Button(shell, SWT.NONE);
    browseButton_1.setText("Browse..");
    browseButton_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        FileDialog dialog = new FileDialog (shell, SWT.OPEN);
        dialog.setFilterNames (new String [] {"CD Images", "*.*"});
        dialog.setFilterExtensions (new String [] {"*.iso;*.cue", "*.*"});
        String result = dialog.open();
        if (result != null) {
          mount_image.setText(result);
        }
      }
    });

    final Label label_2 = new Label(shell, SWT.SEPARATOR | SWT.HORIZONTAL);
    label_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 4, 1));

    mountZipButton = new Button(shell, SWT.RADIO);
    mountZipButton.setLayoutData(new GridData());
    mountZipButton.setText("Mount Zip");

    final Label zipLabel = new Label(shell, SWT.NONE);
    zipLabel.setLayoutData(new GridData());
    zipLabel.setText("Zip");

    zip = new Text(shell, SWT.BORDER);
    zip.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Button browseButton_2 = new Button(shell, SWT.NONE);
    browseButton_2.setText("Browse..");
    browseButton_2.setText("Browse..");
    browseButton_2.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        FileDialog dialog = new FileDialog (shell, SWT.OPEN);
        dialog.setFilterNames (new String [] {"Zip files", "*.*"});
        dialog.setFilterExtensions (new String [] {"*.zip", "*.*"});
        String result = dialog.open();
        if (result != null) {
          zip.setText(result);
        }
      }
    });
    new Label(shell, SWT.NONE);

    final Label writeLabel = new Label(shell, SWT.NONE);
    writeLabel.setLayoutData(new GridData());
    writeLabel.setText("Write");

    write = new Text(shell, SWT.BORDER);
    write.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

    final Button browseButton_3 = new Button(shell, SWT.NONE);
    browseButton_3.setText("Browse..");
    browseButton_3.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        DirectoryDialog dialog = new DirectoryDialog (shell);
        dialog.setFilterPath (write.getText());
        String result = dialog.open();
        if (result != null) {
          write.setText(result);
        }
      }
    });
    new Label(shell, SWT.NONE);

    final Label asLabel_1 = new Label(shell, SWT.NONE);
    asLabel_1.setText("As");

    mount_type_1 = new Combo(shell, SWT.READ_ONLY);
    mount_type_1.setItems(new String[] {"", "cdrom", "dir", "floppy"});
    mount_type_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(shell, SWT.NONE);
    new Label(shell, SWT.NONE);

    final Label label_3 = new Label(shell, SWT.NONE);
    label_3.setText("Label");

    mount_label_1 = new Text(shell, SWT.BORDER);
    mount_label_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(shell, SWT.NONE);

    final Button okButton = new Button(shell, SWT.NONE);
    okButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        if (!isValid())
          return;
        Mount mount = null;
        if (mountADirectoryButton.getSelection())
          mount = new Mount(Mount.MountingType.DIR, mount_type.getText(), driveletter.getText(),
                  mount_dir.getText(), mount_label.getText(), ioctlButton.getSelection(), "");
        else if (mountImageAsButton.getSelection())
          mount = new Mount(Mount.MountingType.IMAGE, "iso", driveletter.getText(),
                  mount_image.getText(), "", false, "");
        else if (mountZipButton.getSelection())
          mount = new Mount(Mount.MountingType.PHYSFS, mount_type_1.getText(), driveletter.getText(),
                  zip.getText(), mount_label_1.getText(), false, write.getText());
        result = mount.toString();
        shell.close();
      }
    });
    okButton.setText("OK");

    final Button cancelButton = new Button(shell, SWT.NONE);
    cancelButton.setText("Cancel");
    cancelButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        result = null;
        shell.close();
      }
    });
    
    mount_dir.addModifyListener(new ModifyListener() {
      public void modifyText(final ModifyEvent e) {
        mountADirectoryButton.setSelection(true);
        mountImageAsButton.setSelection(false);
        mountZipButton.setSelection(false);
      }
    });
    mount_image.addModifyListener(new ModifyListener() {
      public void modifyText(final ModifyEvent e) {
        mountADirectoryButton.setSelection(false);
        mountImageAsButton.setSelection(true);
        mountZipButton.setSelection(false);
      }
    });
    zip.addModifyListener(new ModifyListener() {
      public void modifyText(final ModifyEvent e) {
        mountADirectoryButton.setSelection(false);
        mountImageAsButton.setSelection(false);
        mountZipButton.setSelection(true);
      }
    });
    
    new Label(shell, SWT.NONE);
    new Label(shell, SWT.NONE);
    
    if (result != null) {
      // meaning we are essentially editing an existing mount point
      // so we need to set previous values
      Mount mount = new Mount((String)result);
      driveletter.setText(mount.getDriveletterString());
      switch (mount.getMountingType()) {
        case DIR:
          mountADirectoryButton.setSelection(true);
          mount_dir.setText(mount.getPath());
          if (!mount.getMountAs().equals(""))
            mount_type.setText(mount.getMountAs());
          mount_label.setText(mount.getLabel());
          ioctlButton.setSelection(mount.isIoctl());
          break;
        case PHYSFS:
          mountZipButton.setSelection(true);
          zip.setText(mount.getPath());
          write.setText(mount.getWrite());
          if (!mount.getMountAs().equals(""))
            mount_type_1.setText(mount.getMountAs());
          mount_label_1.setText(mount.getLabel());
          break;
        case IMAGE:
          mountImageAsButton.setSelection(true);
          mount_image.setText(mount.getPath());
      }
    } else {
      // new mount point, set default values
      mountADirectoryButton.setSelection(true);
    }
  }
  
  private boolean isValid() {
    GeneralPurposeDialogs.initErrorDialog();
    if (mountADirectoryButton.getSelection() && mount_dir.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter a path to mount", mount_dir);
    else if (mountImageAsButton.getSelection() && mount_image.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter an image to mount", mount_image);
    else if (mountZipButton.getSelection() && zip.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter an zip to mount", zip);
    return !GeneralPurposeDialogs.displayErrorDialog(shell);
  }
}
