/* 
 * Created on Jul 23, 2006 by ronald.blankendaal
 * 
 * @file $RCSfile: FileUtils.java,v $
 * @version $Revision: 1.5 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/08/09 19:02:37 $ (UTC date of last check in)
 */

package com.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;


public abstract class FileUtils {

  public static String getCwd() {
    try {
      return new File(".").getCanonicalPath();
    } catch(IOException ex) {
      System.err.println("Couldn't get current working directory!!\n");
    }
    return null; // this shouldn't ever fail
  }
  
  public static void createDir(String dir) {
    if (!new File(dir).exists() && !new File(dir).mkdirs())
      System.err.println("Couldn't create " + dir + " directory!!\n");
  }
  
  public static void copyFiles(String srcDir, String dstDir) {
    File[] srcFiles = new File(srcDir).listFiles();
    if (srcFiles != null)
      for (File src: srcFiles)
        if (src.isFile()) FileUtils.copy(src, new File(dstDir + src.getName()));
  }
  
  /** Fast & simple file copy. */
  public static void copy(File source, File dest) {
       FileChannel in = null, out = null;
       try {          
         in = new FileInputStream(source).getChannel();
         out = new FileOutputStream(dest).getChannel();
         in.transferTo(0, in.size(), out);
       } catch (IOException e) {
         System.err.println("Couldn't copy file " + source + " to directory " + dest + "!!\n");
       } finally {
         if (in != null) try {in.close();} catch (IOException ex) {}
         if (out != null) try {out.close();} catch (IOException ex) {}
       }
  }
  
  public static void removeFile(String filename) {
    File file = new File(filename);
    if (file.isFile())
      file.delete();
  }
  
  public static void removeDir(String dirname) {
    File dir = new File(dirname);
    if (dir.isDirectory())
      dir.delete();
  }
}
