/* 
 * Created on 2-jul-2006 by ronald.blankendaal
 * 
 * @file $RCSfile: EditDosboxVersionDialog.java,v $
 * @version $Revision: 1.7 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/08/20 21:32:17 $ (UTC date of last check in)
 */

package com.gui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import swing2swt.layout.BorderLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import com.db.Database;
import com.model.DosboxVersion;


public class EditDosboxVersionDialog extends Dialog {

  private Text path;
  private Text title;
  protected Object result;
  protected Shell shell;

  private Database db;
  
  /**
   * Create the dialog
   * @param parent
   * @param style
   */
  public EditDosboxVersionDialog(Shell parent, int style) {
    super(parent, style);
  }

  /**
   * Create the dialog
   * @param parent
   */
  public EditDosboxVersionDialog(Shell parent) {
    this(parent, SWT.NONE);
  }

  public void setDatabase(Database db) {
    this.db = db;
  }
  
  public void setDosboxVersion(DosboxVersion dbversion) {
    this.result = dbversion;
  }

  /**
   * Open the dialog
   * @return the result
   */
  public Object open() {
    createContents();
    shell.open();
    shell.layout();
    Display display = getParent().getDisplay();
    while (!shell.isDisposed()) {
      if (!display.readAndDispatch())
        display.sleep();
    }
    return result;
  }

  /**
   * Create contents of the dialog
   */
  protected void createContents() {
    shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
    shell.setLayout(new BorderLayout(0, 0));
    shell.setSize(500, 200);
    if (result != null) {
      // meaning we are essentially editing an existing dosbox version
      shell.setText("Edit Dosbox Version");
    } else {
      shell.setText("Add Dosbox Version");
    }

    final Composite composite = new Composite(shell, SWT.NONE);
    final GridLayout gridLayout_1 = new GridLayout();
    gridLayout_1.numColumns = 3;
    composite.setLayout(gridLayout_1);

    final Label titleLabel = new Label(composite, SWT.NONE);
    titleLabel.setText("Title");

    title = new Text(composite, SWT.BORDER);
    title.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(composite, SWT.NONE);

    final Label pathLabel = new Label(composite, SWT.NONE);
    pathLabel.setText("Path");

    path = new Text(composite, SWT.BORDER);
    path.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    
    final Button browseButton = new Button(composite, SWT.NONE);
    browseButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        DirectoryDialog dialog = new DirectoryDialog (shell);
        dialog.setFilterPath (path.getText());
        String result = dialog.open();
        if (result != null) {
          path.setText(result);
        }
      }
    });
    browseButton.setText("Browse..");

    final Label multiconfSupportLabel = new Label(composite, SWT.NONE);
    multiconfSupportLabel.setText("Multiconf support");

    final Button multiconf = new Button(composite, SWT.CHECK);
    new Label(composite, SWT.NONE);

    final Label defaultLabel = new Label(composite, SWT.NONE);
    defaultLabel.setText("Default");

    final Button isDefaultButton = new Button(composite, SWT.CHECK);
    new Label(composite, SWT.NONE);

    final Composite composite_1 = new Composite(shell, SWT.NONE);
    composite_1.setLayoutData(BorderLayout.SOUTH);
    composite_1.setLayout(new RowLayout());

    final Button okButton = new Button(composite_1, SWT.NONE);
    final RowData rowData = new RowData();
    rowData.width = 80;
    okButton.setLayoutData(rowData);
    shell.setDefaultButton(okButton);
    okButton.setText("OK");
    okButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        if (!isValid())
          return;
        if (!path.getText().endsWith(System.getProperty("file.separator")))
          path.setText(path.getText() + System.getProperty("file.separator"));
        int dbversionId = db.addOrEditDosboxVersion(title.getText(), path.getText(),
                multiconf.getSelection(), isDefaultButton.getSelection(),
                result != null ? ((DosboxVersion)result).getId(): -1);
        result = new DosboxVersion(dbversionId, title.getText(), path.getText(),
                multiconf.getSelection(), isDefaultButton.getSelection());
        shell.close();
      }
    });
    
    final Button cancelButton = new Button(composite_1, SWT.NONE);
    final RowData rowData_1 = new RowData();
    rowData_1.width = 80;
    cancelButton.setLayoutData(rowData_1);
    cancelButton.setText("Cancel");
    cancelButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        result = null;
        shell.close();
      }
    });
    
    // init values
    if (result != null) {
      // meaning we are essentially editing an existing dosbox version
      // so we need to set previous values
      title.setText(((DosboxVersion)result).getTitle());
      path.setText(((DosboxVersion)result).getPath());
      isDefaultButton.setSelection(((DosboxVersion)result).isDefaultVersion());
      multiconf.setSelection(((DosboxVersion)result).isMultiConfig());
    }
  }
  
  private boolean isValid() {
    GeneralPurposeDialogs.initErrorDialog();
    if (title.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter a dosbox version title", title);
    if (path.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter a path to the dosbox executable", path);
    return !GeneralPurposeDialogs.displayErrorDialog(shell);
  }
}
