/* 
 * Created on 28-jun-2006 by ronald.blankendaal
 * 
 * @file $RCSfile: MainWindow.java,v $
 * @version $Revision: 1.34 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/08/20 22:29:50 $ (UTC date of last check in)
 */

package com.gui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import swing2swt.layout.BorderLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import com.db.Database;
import com.model.Autoexec;
import com.model.Configuration;
import com.model.Developer;
import com.model.DosboxVersion;
import com.model.Genre;
import com.model.Profile;
import com.model.Publisher;
import com.model.Status;
import com.model.Template;
import com.model.Year;
import com.swtdesigner.SWTResourceManager;
import com.util.FileUtils;
import com.util.ListUtils;
import com.util.StringUtils;


public class MainWindow {

  private Table template_table;
  public static final String CAPTURES_DIR = "captures";
  public static final String TEMPLATES_DIR = "templates";
  public static final String PROFILES_DIR = "profiles";
  public static final String DOSBOX_CONF = "dosbox.conf";
  public static final String SETUP_CONF = "setup.conf";
  public static final String DFEND_PATH = "/Program Files/D-Fend";
  private static final int THUMB_HEIGHT = 100;
  private static final String SETTINGS_CONF = "settings.conf";
  
  private Display display;
  private Text text;
  private Table dosboxversion_table;
  private Table profile_table;
  private Link link;
  private Link link_1;
  private ToolBar toolBar_2;
  protected Shell shell;
  private java.util.List<Profile> profilesList;
  private java.util.List<DosboxVersion> dbversionsList;
  private java.util.List<Template> templatesList;
  private Database db = null;
  private Configuration settings = null;
  
  
  /**
   * Launch the application
   * @param args
   */
  public static void main(String[] args) {
    try {
      MainWindow window = new MainWindow();
      window.open();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * Open the window
   */
  public void open() {
    db = Database.getInstance();
    loadSettings();
    
    display = Display.getDefault();
    createContents();
    shell.open();
    shell.layout();
    while (!shell.isDisposed()) {
      if (!display.readAndDispatch())
        display.sleep();
    }
    display.dispose();

    saveSettings();
    db.shutdown();
  }
  
  /**
   * Create contents of the window
   */
  protected void createContents() {
    profilesList = db.readProfilesList(settings.getIntValue("gui", "sortcolumn"),
    		settings.getBooleanValue("gui", "sortascending"));
    dbversionsList = db.readDosboxVersionsList();
    templatesList = db.readTemplatesList();

    shell = new Shell();
    shell.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		boolean isMaximized = shell.getMaximized();
    		if (!isMaximized) {
    			Rectangle rec = shell.getBounds();
        		settings.setIntValue("gui", "width", rec.width);
        		settings.setIntValue("gui", "height", rec.height);
        		settings.setIntValue("gui", "x", rec.x);
        		settings.setIntValue("gui", "y", rec.y);
    		}
    		settings.setBooleanValue("gui", "maximized", isMaximized);
    	} });
    shell.addControlListener(new ControlAdapter() {
    	public void controlMoved(final ControlEvent e) {
    		if (!shell.getMaximized()) {
    			Rectangle rec = shell.getBounds();
    			settings.setIntValue("gui", "x", rec.x);
    			settings.setIntValue("gui", "y", rec.y);
    		}
    	} });
    shell.setLayout(new BorderLayout(0, 0));
    shell.setMaximized(settings.getBooleanValue("gui", "maximized"));
    shell.setLocation(settings.getIntValue("gui", "x"), settings.getIntValue("gui", "y"));
    shell.setSize(settings.getIntValue("gui", "width"), settings.getIntValue("gui", "height"));
    shell.setText("DOSBox Game Launcher v0.4");

    final TabFolder tabFolder = new TabFolder(shell, SWT.NONE);

    final TabItem profilesTabItem = new TabItem(tabFolder, SWT.NONE);
    profilesTabItem.setText("Profiles");

    final Composite composite = new Composite(tabFolder, SWT.NONE);
    composite.setLayout(new BorderLayout(0, 0));
    profilesTabItem.setControl(composite);
    
    final ToolBar toolBar = new ToolBar(composite, SWT.NONE);
    toolBar.setLayoutData(BorderLayout.NORTH);

    final ToolItem newItemToolItem = new ToolItem(toolBar, SWT.PUSH);
    newItemToolItem.setText("Add profile");
    newItemToolItem.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doAddProfile();
      }
    });
    
    final ToolItem newItemToolItem_2 = new ToolItem(toolBar, SWT.PUSH);
    newItemToolItem_2.setText("Edit Profile");
    newItemToolItem_2.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doEditProfile();
      }
    });
    
    final ToolItem newItemToolItem_1 = new ToolItem(toolBar, SWT.PUSH);
    newItemToolItem_1.setText("Remove profile");
    newItemToolItem_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doRemoveProfile();
      }
    });

    final TabItem dosboxTabItem = new TabItem(tabFolder, SWT.NONE);
    dosboxTabItem.setText("DOSBox versions");

    final Composite composite_1 = new Composite(tabFolder, SWT.NONE);
    composite_1.setLayout(new BorderLayout(0, 0));
    dosboxTabItem.setControl(composite_1);

    dosboxversion_table = new Table(composite_1, SWT.FULL_SELECTION | SWT.BORDER);
    dosboxversion_table.addTraverseListener(new TraverseListener() {
      public void keyTraversed(final TraverseEvent e) {
        if (e.detail == SWT.TRAVERSE_RETURN)
          doRunDosbox();
      }
    });
    dosboxversion_table.addMouseListener(new MouseAdapter() {
      public void mouseDoubleClick(final MouseEvent e) {
        doRunDosbox();
      }
    });
    
    dosboxversion_table.setLinesVisible(true);
    dosboxversion_table.setHeaderVisible(true);

    final TableColumn newColumnTableColumn_6 = new TableColumn(dosboxversion_table, SWT.NONE);
    newColumnTableColumn_6.setWidth(201);
    newColumnTableColumn_6.setText("Title");

    final TableColumn newColumnTableColumn_7 = new TableColumn(dosboxversion_table, SWT.NONE);
    newColumnTableColumn_7.setWidth(218);
    newColumnTableColumn_7.setText("Path");

    final TableColumn newColumnTableColumn_8 = new TableColumn(dosboxversion_table, SWT.NONE);
    newColumnTableColumn_8.setWidth(100);
    newColumnTableColumn_8.setText("Default");

    final ToolBar toolBar_1 = new ToolBar(composite_1, SWT.NONE);
    toolBar_1.setLayoutData(BorderLayout.NORTH);

    final ToolItem newItemToolItem_3 = new ToolItem(toolBar_1, SWT.PUSH);
    newItemToolItem_3.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doAddDosboxVersion();
      }
    });
    newItemToolItem_3.setText("Add version");

    final ToolItem newItemToolItem_2_1 = new ToolItem(toolBar_1, SWT.PUSH);
    newItemToolItem_2_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doEditDosboxVersion();
      }
    });
    newItemToolItem_2_1.setText("Edit version");

    final ToolItem newItemToolItem_1_1 = new ToolItem(toolBar_1, SWT.PUSH);
    newItemToolItem_1_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doRemoveDosboxVersion();
      }
    });
    newItemToolItem_1_1.setText("Remove version");

    final Menu menu = new Menu(shell, SWT.BAR);
    shell.setMenuBar(menu);

    final MenuItem fileMenuItem = new MenuItem(menu, SWT.CASCADE);
    fileMenuItem.setText("File");

    final Menu menu_1 = new Menu(fileMenuItem);
    fileMenuItem.setMenu(menu_1);

    final MenuItem dfendImportMenuItem = new MenuItem(menu_1, SWT.NONE);
    dfendImportMenuItem.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doDFendImport();
      }
    });
    dfendImportMenuItem.setText("D-Fend Import");

    new MenuItem(menu_1, SWT.SEPARATOR);

    final MenuItem exitMenuItem = new MenuItem(menu_1, SWT.NONE);
    exitMenuItem.setText("Exit");
    exitMenuItem.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        shell.close();
      }
    });

    final ScrolledComposite scrolledComposite = new ScrolledComposite(composite, SWT.BORDER | SWT.H_SCROLL);
    scrolledComposite.setMinHeight(THUMB_HEIGHT + 20);
    scrolledComposite.setLayoutData(BorderLayout.SOUTH);

    toolBar_2 = new ToolBar(scrolledComposite, SWT.NONE);
    scrolledComposite.setContent(toolBar_2);

    final SashForm sashForm = new SashForm(composite, SWT.NONE);
    
    profile_table = new Table(sashForm, SWT.FULL_SELECTION | SWT.BORDER);

    profile_table.setLinesVisible(true);
    profile_table.setLayoutData(BorderLayout.WEST);
    profile_table.setHeaderVisible(true);
    profile_table.addTraverseListener(new TraverseListener() {
      public void keyTraversed(final TraverseEvent e) {
        if ((e.stateMask == SWT.CTRL) && (e.detail == SWT.TRAVERSE_RETURN)) {
          doEditProfile();
        } else if ((e.stateMask == SWT.SHIFT) && (e.detail == SWT.TRAVERSE_RETURN)) {
          doRunProfileSetup();
        } else if (e.detail == SWT.TRAVERSE_RETURN) {
          doRunProfile();
        } 
      }
    });
    profile_table.addMouseListener(new MouseAdapter() {
      public void mouseDoubleClick(final MouseEvent e) {
        doRunProfile();
      }
    });

    final TableColumn profileTitleColumn = new TableColumn(profile_table, SWT.NONE);
    profileTitleColumn.setMoveable(true);
    profileTitleColumn.setWidth(settings.getIntValue("gui", "column1width"));
    profileTitleColumn.setText("Title");
    profileTitleColumn.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doReorderProfiles(0, e);
    	} });
    profileTitleColumn.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		settings.setIntValue("gui", "column1width", profileTitleColumn.getWidth());
    	}
    	public void controlMoved(final ControlEvent e) {
    		settings.setValue("gui", "columnorder",
    				StringUtils.intArrayToString(profile_table.getColumnOrder()));
    	} });
    
    final TableColumn profileSetupColumn = new TableColumn(profile_table, SWT.NONE);
    profileSetupColumn.setMoveable(true);
    profileSetupColumn.setWidth(settings.getIntValue("gui", "column2width"));
    profileSetupColumn.setText("Setup");
    profileSetupColumn.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doReorderProfiles(1, e);
    	} });
    profileSetupColumn.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		settings.setIntValue("gui", "column2width", profileSetupColumn.getWidth());
    	}
    	public void controlMoved(final ControlEvent e) {
    		settings.setValue("gui", "columnorder",
    				StringUtils.intArrayToString(profile_table.getColumnOrder()));
    	} });
    
    final TableColumn profileDeveloperColumn = new TableColumn(profile_table, SWT.NONE);
    profileDeveloperColumn.setMoveable(true);
    profileDeveloperColumn.setWidth(settings.getIntValue("gui", "column3width"));
    profileDeveloperColumn.setText("Developer");
    profileDeveloperColumn.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doReorderProfiles(2, e);
    	} });
    profileDeveloperColumn.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		settings.setIntValue("gui", "column3width", profileDeveloperColumn.getWidth());
    	}
    	public void controlMoved(final ControlEvent e) {
    		settings.setValue("gui", "columnorder",
    				StringUtils.intArrayToString(profile_table.getColumnOrder()));
    	} });
    
    final TableColumn profilePublisherColumn = new TableColumn(profile_table, SWT.NONE);
    profilePublisherColumn.setMoveable(true);
    profilePublisherColumn.setWidth(settings.getIntValue("gui", "column4width"));
    profilePublisherColumn.setText("Publisher");
    profilePublisherColumn.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doReorderProfiles(3, e);
    	} });
    profilePublisherColumn.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		settings.setIntValue("gui", "column4width", profilePublisherColumn.getWidth());
    	}
    	public void controlMoved(final ControlEvent e) {
    		settings.setValue("gui", "columnorder",
    				StringUtils.intArrayToString(profile_table.getColumnOrder()));
    	} });
    
    final TableColumn profileGenreColumn = new TableColumn(profile_table, SWT.NONE);
    profileGenreColumn.setMoveable(true);
    profileGenreColumn.setWidth(settings.getIntValue("gui", "column5width"));
    profileGenreColumn.setText("Genre");
    profileGenreColumn.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doReorderProfiles(4, e);
    	} });
    profileGenreColumn.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		settings.setIntValue("gui", "column5width", profileGenreColumn.getWidth());
    	}
    	public void controlMoved(final ControlEvent e) {
    		settings.setValue("gui", "columnorder",
    				StringUtils.intArrayToString(profile_table.getColumnOrder()));
    	} });
    
    final TableColumn profileYearColumn = new TableColumn(profile_table, SWT.NONE);
    profileYearColumn.setMoveable(true);
    profileYearColumn.setWidth(settings.getIntValue("gui", "column6width"));
    profileYearColumn.setText("Year");
    profileYearColumn.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doReorderProfiles(5, e);
    	} });
    profileYearColumn.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		settings.setIntValue("gui", "column6width", profileYearColumn.getWidth());
    	}
    	public void controlMoved(final ControlEvent e) {
    		settings.setValue("gui", "columnorder",
    				StringUtils.intArrayToString(profile_table.getColumnOrder()));
    	} });
    
    final TableColumn profileStatusColumn = new TableColumn(profile_table, SWT.NONE);
    profileStatusColumn.setMoveable(true);
    profileStatusColumn.setWidth(settings.getIntValue("gui", "column7width"));
    profileStatusColumn.setText("Status");
    profileStatusColumn.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doReorderProfiles(6, e);
    	} });
    profileStatusColumn.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		settings.setIntValue("gui", "column7width", profileStatusColumn.getWidth());
    	}
    	public void controlMoved(final ControlEvent e) {
    		settings.setValue("gui", "columnorder",
    				StringUtils.intArrayToString(profile_table.getColumnOrder()));
    	} });
    
    final TableColumn profileFavoriteColumn = new TableColumn(profile_table, SWT.NONE);
    profileFavoriteColumn.setMoveable(true);
    profileFavoriteColumn.setWidth(settings.getIntValue("gui", "column8width"));
    profileFavoriteColumn.setText("Favorite");
    profileFavoriteColumn.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doReorderProfiles(7, e);
    	} });
    profileFavoriteColumn.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		settings.setIntValue("gui", "column8width", profileFavoriteColumn.getWidth());
    	}
    	public void controlMoved(final ControlEvent e) {
    		settings.setValue("gui", "columnorder",
    				StringUtils.intArrayToString(profile_table.getColumnOrder()));
    	} });
    
    final TableColumn profileIdColumn = new TableColumn(profile_table, SWT.NONE);
    profileIdColumn.setMoveable(true);
    profileIdColumn.setWidth(settings.getIntValue("gui", "column9width"));
    profileIdColumn.setText("ID");
    profileIdColumn.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doReorderProfiles(8, e);
    	} });
    profileIdColumn.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		settings.setIntValue("gui", "column9width", profileIdColumn.getWidth());
    	}
    	public void controlMoved(final ControlEvent e) {
    		settings.setValue("gui", "columnorder",
    				StringUtils.intArrayToString(profile_table.getColumnOrder()));
    	} });
    
    profile_table.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        displayProfileInformation();
      } });

    final Composite informationGroup = new Composite(sashForm, SWT.NONE);
    informationGroup.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		settings.setValue("gui", "sashweights",
    				StringUtils.intArrayToString(sashForm.getWeights()));
    	}
    });
    informationGroup.setLayout(new BorderLayout(0, 0));
    text = new Text(informationGroup, SWT.V_SCROLL | SWT.MULTI | SWT.READ_ONLY | SWT.BORDER | SWT.WRAP);

    final Composite composite_2 = new Composite(informationGroup, SWT.NONE);
    composite_2.setLayout(new BorderLayout(0, 0));
    composite_2.setLayoutData(BorderLayout.SOUTH);

    link = new Link(composite_2, SWT.NONE);
    link.setLayoutData(BorderLayout.NORTH);
    link.setText(" ");
    link.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        Program p = Program.findProgram(".html");
        if (p != null) p.execute (e.text);
      }
    });
    
    link_1 = new Link(composite_2, SWT.NONE);
    link_1.setText(" ");
    link_1.setLayoutData(BorderLayout.SOUTH);
    link_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        Program p = Program.findProgram(".html");
        if (p != null) p.execute (e.text);
      }
    });
    
    sashForm.setWeights(StringUtils.stringToIntArray(settings.getValue("gui", "sashweights")));

    final TabItem templatesTabItem = new TabItem(tabFolder, SWT.NONE);
    templatesTabItem.setText("Templates");

    final Composite composite_1_1 = new Composite(tabFolder, SWT.NONE);
    composite_1_1.setLayout(new BorderLayout(0, 0));
    templatesTabItem.setControl(composite_1_1);

    template_table = new Table(composite_1_1, SWT.FULL_SELECTION | SWT.BORDER);
    template_table.setLinesVisible(true);
    template_table.setHeaderVisible(true);

    final TableColumn newColumnTableColumn_6_1 = new TableColumn(template_table, SWT.NONE);
    newColumnTableColumn_6_1.setWidth(300);
    newColumnTableColumn_6_1.setText("Title");

    final TableColumn newColumnTableColumn_8_1 = new TableColumn(template_table, SWT.NONE);
    newColumnTableColumn_8_1.setWidth(50);
    newColumnTableColumn_8_1.setText("Default");

    final ToolBar toolBar_1_1 = new ToolBar(composite_1_1, SWT.NONE);
    toolBar_1_1.setLayoutData(BorderLayout.NORTH);

    final ToolItem newItemToolItem_3_1 = new ToolItem(toolBar_1_1, SWT.PUSH);
    newItemToolItem_3_1.setText("Add template");
    newItemToolItem_3_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doAddTemplate();
      }
    });

    final ToolItem newItemToolItem_2_1_1 = new ToolItem(toolBar_1_1, SWT.PUSH);
    newItemToolItem_2_1_1.setText("Edit template");
    newItemToolItem_2_1_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doEditTemplate();
      }
    });

    final ToolItem newItemToolItem_1_1_1 = new ToolItem(toolBar_1_1, SWT.PUSH);
    newItemToolItem_1_1_1.setText("Remove template");
    newItemToolItem_1_1_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doRemoveTemplate();
      }
    });
        
    // init values
    for (Profile prof: profilesList) addProfileToTable(prof);
    for (DosboxVersion dbversion: dbversionsList) addDosboxVersionToTable(dbversion);
    for (Template template: templatesList) addTemplateToTable(template);
    
    profile_table.setSortColumn(profile_table.getColumn(settings.getIntValue("gui", "sortcolumn")));
    profile_table.setSortDirection(settings.getBooleanValue("gui", "sortascending")? SWT.UP: SWT.DOWN);
    profile_table.setColumnOrder(StringUtils.stringToIntArray(settings.getValue("gui", "columnorder")));
  }
  
  private void doReorderProfiles(int columnId, SelectionEvent e) {
	  TableColumn sortColumn = profile_table.getSortColumn();
	  TableColumn currentColumn = (TableColumn) e.widget;
	  int dir = profile_table.getSortDirection();
	  if (sortColumn == currentColumn) {
		  dir = dir == SWT.UP ? SWT.DOWN : SWT.UP;
	  } else {
		  profile_table.setSortColumn(currentColumn);
		  dir = SWT.UP;
	  }
	  int currentProfileId = -1;
	  if (profile_table.getSelectionIndex() != -1)
		  currentProfileId = profilesList.get(profile_table.getSelectionIndex()).getId();
	  profilesList = db.readProfilesList(columnId, dir == SWT.UP);
	  for (int i = 0; i < profilesList.size(); i++)
		  setTableItem(profile_table.getItem(i), profilesList.get(i));
	  profile_table.setSortDirection(dir);
	  if (currentProfileId != -1) {
		  profile_table.setSelection(ListUtils.findTIProfile(profilesList, currentProfileId));
		  profile_table.showSelection();
	  }
	  settings.setIntValue("gui", "sortcolumn", columnId);
	  settings.setBooleanValue("gui", "sortascending", dir == SWT.UP);
  }
  
  private void displayNotes(String notes) {
    text.setText(notes);
  }
  
  private void displayLinks(String link1, String link2) {
    if (link1 != null && !link1.equals(""))
      link.setText("<a href=\"" + link1 + "\">" + link1 + "</a>");
    else
      link.setText(" ");
    
    if (link2 != null && !link2.equals(""))
      link_1.setText("<a href=\"" + link2 + "\">" + link2 + "</a>");
    else
      link_1.setText(" ");
  }
  
  private void displayScreenshots(int profileId) {
    ToolItem[] toolItems = toolBar_2.getItems();
    for (int i = 0; i < toolItems.length; i++)
      toolItems[i].dispose();
    File path = new File(CAPTURES_DIR + System.getProperty("file.separator") + profileId + System.getProperty("file.separator"));
    String[] files = path.list();
    if (files != null) {
      for (int i = 0; i < files.length; i++) {
        if (files[i].toLowerCase().endsWith(".png")) {
          Image thumb = SWTResourceManager.getImage(CAPTURES_DIR + System.getProperty("file.separator") +
                  profileId + System.getProperty("file.separator") + files[i]);
          ImageData smallThumb = thumb.getImageData();
          int width = smallThumb.width;
          int height = smallThumb.height;
          double factor = (double)THUMB_HEIGHT / (double)height;
          smallThumb = smallThumb.scaledTo((int)(width * factor), (int)(height * factor));
          final ToolItem toolItem = new ToolItem(toolBar_2, SWT.PUSH);
          toolItem.setImage(new Image(display, smallThumb));
          toolItem.setToolTipText(CAPTURES_DIR + System.getProperty("file.separator") +
                  profileId + System.getProperty("file.separator") + files[i]);
          toolItem.setText(files[i]);
          toolItem.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent e) {
              final Thumb thumbDialog = new Thumb(shell);
              thumbDialog.setThumb(toolItem.getToolTipText());
              thumbDialog.open();
            }
          });
          toolItem.addDisposeListener(new DisposeListener() {
            public void widgetDisposed(DisposeEvent e) {
              toolItem.getImage().dispose();
            }
          });
        }
      }
    }
    toolBar_2.setVisible(toolBar_2.getItemCount() != 0);
    toolBar_2.pack();
  }
  
  private void doAddProfile() {
    if (ListUtils.findTIDefaultDosboxVersion(dbversionsList) == -1) {
      GeneralPurposeDialogs.infoMessage(shell, "You must first define a default DOSBox version!");
      return;
    }
    final EditProfileDialog addProfileDialog = new EditProfileDialog(shell);
    addProfileDialog.setDatabase(db);
    Profile profile = (Profile)addProfileDialog.open();
    if (profile != null) {
      profilesList.add(profile);
      addProfileToTable(profile);
      profile_table.setSelection(profile_table.getItemCount() - 1);
      profile_table.showSelection();
      profile_table.setFocus();
    }
  }
  
  private void doAddDosboxVersion() {
    final EditDosboxVersionDialog addDosboxVersionDialog = new EditDosboxVersionDialog(shell);
    addDosboxVersionDialog.setDatabase(db);
    DosboxVersion dbversion = (DosboxVersion)addDosboxVersionDialog.open();
    if (dbversion != null)
    	updateDosboxVersionList(dbversion);
  }
  
  private void doAddTemplate() {
    if (ListUtils.findTIDefaultDosboxVersion(dbversionsList) == -1) {
      GeneralPurposeDialogs.infoMessage(shell, "You must first define a default DOSBox version!");
      return;
    }
    final EditTemplateDialog addTemplateDialog = new EditTemplateDialog(shell);
    addTemplateDialog.setDatabase(db);
    Template template = (Template)addTemplateDialog.open();
    if (template != null)
    	updateTemplateList(template);
  }
  
  private void doEditProfile() {
    int index = profile_table.getSelectionIndex();
    if (index != -1) {
      final EditProfileDialog editProfileDialog = new EditProfileDialog(shell);
      editProfileDialog.setDatabase(db);
      editProfileDialog.setProfile(profilesList.get(index));
      Profile profile = (Profile)editProfileDialog.open();
      if (profile != null) {
        profilesList.set(index, profile);
        setTableItem(profile_table.getItem(index), profile);
        displayProfileInformation();
      }
    }
  }
  
  private void doEditDosboxVersion() {
    int index = dosboxversion_table.getSelectionIndex();
    if (index != -1) {
      final EditDosboxVersionDialog editDosboxVersionDialog = new EditDosboxVersionDialog(shell);
      editDosboxVersionDialog.setDatabase(db);
      editDosboxVersionDialog.setDosboxVersion(dbversionsList.get(index));
      DosboxVersion dbversion = (DosboxVersion)editDosboxVersionDialog.open();
      if (dbversion != null)
      	updateDosboxVersionList(dbversion);
    }
  }
  
  private void updateDosboxVersionList(DosboxVersion dbversion) {
  	dbversionsList = db.readDosboxVersionsList();
    dosboxversion_table.removeAll();
    for (DosboxVersion version: dbversionsList) addDosboxVersionToTable(version);
    dosboxversion_table.setSelection(ListUtils.findTIDosboxVersion(dbversionsList, dbversion.getId()));
	  dosboxversion_table.showSelection();
	  dosboxversion_table.setFocus();
  }
  
  private void updateTemplateList(Template template) {
  	templatesList = db.readTemplatesList();
    template_table.removeAll();
    for (Template temp: templatesList) addTemplateToTable(temp);
    template_table.setSelection(ListUtils.findTITemplate(templatesList, template.getId()));
	  template_table.showSelection();
	  template_table.setFocus();
  }
  
  private void doEditTemplate() {
    int index = template_table.getSelectionIndex();
    if (index != -1) {
      final EditTemplateDialog editTemplateDialog = new EditTemplateDialog(shell);
      editTemplateDialog.setDatabase(db);
      editTemplateDialog.setTemplate(templatesList.get(index));
      Template template = (Template)editTemplateDialog.open();
      if (template != null)
      	updateTemplateList(template);
    }
  }
  
  private void doRemoveProfile() {
    int index = profile_table.getSelectionIndex();
    if (index != -1) {
      if (GeneralPurposeDialogs.confirmMessage(shell, "Do you want to remove the selected profile?")) {
        int profileId = (profilesList.get(index)).getId();
        db.removeProfile(profileId);
        profile_table.remove(index);
        profilesList.remove(index);
        String conffile = PROFILES_DIR + System.getProperty("file.separator") + profileId + ".conf";
        if (GeneralPurposeDialogs.confirmMessage(shell,
                "Do you also want to remove the associated conf file " + conffile + " ?")) {
          FileUtils.removeFile(conffile);
        }
        displayProfileInformation();
        /*
        SWTResourceManager.disposeImages();
        String captures = CAPTURES_DIR + System.getProperty("file.separator") + profileId;
        if (GeneralPurposeDialogs.confirmMessage(shell,
          "Do you also want to remove the associated captures in the directory " + captures + " ?")) {
          FileUtils.removeDir(captures);
        }
        */
      }
    }
  }

  private void doRemoveDosboxVersion() {
    int index = dosboxversion_table.getSelectionIndex();
    if (index != -1) {
      if (GeneralPurposeDialogs.confirmMessage(shell, "Do you want to remove the selected DOSBox version?")) {
        db.removeDosboxVersion((dbversionsList.get(index)).getId());
        dosboxversion_table.remove(index);
        dbversionsList.remove(index);
      }
    }
  }
  
  private void doRemoveTemplate() {
    int index = template_table.getSelectionIndex();
    if (index != -1) {
      if (GeneralPurposeDialogs.confirmMessage(shell, "Do you want to remove the selected template?")) {
        int templateId = (templatesList.get(index)).getId();
        db.removeTemplate(templateId);
        template_table.remove(index);
        templatesList.remove(index);
        String conffile = TEMPLATES_DIR + System.getProperty("file.separator") + templateId + ".conf";
        if (GeneralPurposeDialogs.confirmMessage(shell,
                "Do you also want to remove the associated conf file " + conffile + " ?")) {
          FileUtils.removeFile(conffile);
        }
      }
    }
  }
  
  private void addProfileToTable(Profile prof) {
    final TableItem newItemTableItem = new TableItem(profile_table, SWT.BORDER); 
    setTableItem(newItemTableItem, prof);
  }
  
  private void addDosboxVersionToTable(DosboxVersion dbversion) {
    final TableItem newItemTableItem = new TableItem(dosboxversion_table, SWT.BORDER); 
    setTableItem(newItemTableItem, dbversion);
  }
  
  private void addTemplateToTable(Template template) {
    final TableItem newItemTableItem = new TableItem(template_table, SWT.BORDER); 
    setTableItem(newItemTableItem, template);
  }
  
  private void setTableItem(TableItem newItemTableItem, Profile prof) {
    newItemTableItem.setText(0, prof.getTitle());
    newItemTableItem.setText(1, prof.hasSetup());
    newItemTableItem.setText(2, prof.getDeveloperName());
    newItemTableItem.setText(3, prof.getPublisherName());
    newItemTableItem.setText(4, prof.getGenre());
    newItemTableItem.setText(5, prof.getYear());
    newItemTableItem.setText(6, prof.getStatus());
    newItemTableItem.setText(7, prof.isFavoriteString()); 
    newItemTableItem.setText(8, String.valueOf(prof.getId()));
  }
  
  private void setTableItem(TableItem newItemTableItem, DosboxVersion dbversion) {
    newItemTableItem.setText(0, dbversion.getTitle());
    newItemTableItem.setText(1, dbversion.getPath());
    newItemTableItem.setText(2, dbversion.isDefaultVersionString());
  }
  
  private void setTableItem(TableItem newItemTableItem, Template template) {
    newItemTableItem.setText(0, template.getTitle());
    newItemTableItem.setText(1, template.isDefaultString());
  }
  
  private void doRunProfile() {
    int index = profile_table.getSelectionIndex();
    if (index != -1) {
      Profile prof = profilesList.get(index);
      doRunProfile(prof, prof.getId() + ".conf");
    }
  }
  
  private void executeCommand(List<String> execCommands) throws IOException {
  	String[] rtCmds = new String[execCommands.size()];
  	for (int i = 0; i < execCommands.size(); i++) {
    	rtCmds[i] = execCommands.get(i);
    	System.out.print(rtCmds[i] + " ");
    }
    System.out.println();
    Process proc = Runtime.getRuntime().exec(rtCmds);
    StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "DOSBox stderr");            
    StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "DOSBox stdout");
    outputGobbler.start();
    errorGobbler.start();
  }
  
  private void doRunProfile(Profile prof, String filename) {
    try {
      int dbversionIndex = ListUtils.findTIDosboxVersion(dbversionsList, prof.getDbversionId());
      DosboxVersion dbversion = dbversionsList.get(dbversionIndex);
      List<String> confs = new ArrayList<String>();
      if (dbversion.getPath().indexOf('/') != -1) {
    		// *nix
      	confs.add(dbversion.getPath() + "dosbox");
      } else {
      	// Windows
      	confs.add(dbversion.getPath() + "DOSBox.exe");
      }
      if (dbversion.isMultiConfig()) {
        // selected default dosbox config file
      	confs.add("-conf");
        confs.add(dbversion.getPath() + DOSBOX_CONF); 
      }
      // add profile-specific settings
      confs.add("-conf");
      confs.add(PROFILES_DIR + System.getProperty("file.separator") + filename);
      executeCommand(confs);
    } catch (IOException e) {
      System.err.println("Profile could not be started!!\n");
    }
  }
  
  private void doRunProfileSetup() {
    int index = profile_table.getSelectionIndex();
    if (index != -1) {
      Profile prof = profilesList.get(index);
      Configuration conf = new Configuration(PROFILES_DIR + System.getProperty("file.separator") + prof.getId() + ".conf");
      Autoexec autoexec = new Autoexec(conf.getValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC));
      autoexec.setSetup(prof.getSetup());
      autoexec.setSetupParameters(prof.getSetupParameters());
      conf.setValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC, autoexec.toString(true));
      conf.saveToFile(PROFILES_DIR + System.getProperty("file.separator") + SETUP_CONF);
      doRunProfile(prof, SETUP_CONF);
    }
  }
  
  private void doRunDosbox() {
    int index = dosboxversion_table.getSelectionIndex();
    if (index != -1) {
      try {
      	DosboxVersion dbversion = dbversionsList.get(index);
      	List<String> confs = new ArrayList<String>();
        if (dbversion.getPath().indexOf('/') != -1) {
      		// *nix
        	confs.add(dbversion.getPath() + "dosbox");
        } else {
        	// Windows
        	confs.add(dbversion.getPath() + "DOSBox.exe");
        }
        confs.add("-conf");
        confs.add(dbversion.getPath() + DOSBOX_CONF); 
        executeCommand(confs);
      } catch (IOException e) {
        System.err.println("Dosbox could not be started!!\n");
      }
    }
  }
  
  private void loadSettings() {
	settings = new Configuration(SETTINGS_CONF);
	settings.createSection("gui");
	if (settings.getValue("gui", "width").equals(""))
		settings.setValue("gui", "width", "706");
	if (settings.getValue("gui", "height").equals(""))
		settings.setValue("gui", "height", "375");
	if (settings.getValue("gui", "x").equals(""))
		settings.setValue("gui", "x", "10");
	if (settings.getValue("gui", "y").equals(""))
		settings.setValue("gui", "y", "10");
	if (settings.getValue("gui", "maximized").equals(""))
		settings.setBooleanValue("gui", "maximized", false);
	if (settings.getValue("gui", "column1width").equals(""))
		settings.setValue("gui", "column1width", "100");
	if (settings.getValue("gui", "column2width").equals(""))
		settings.setValue("gui", "column2width", "40");
	if (settings.getValue("gui", "column3width").equals(""))
		settings.setValue("gui", "column3width", "100");
	if (settings.getValue("gui", "column4width").equals(""))
		settings.setValue("gui", "column4width", "100");
	if (settings.getValue("gui", "column5width").equals(""))
		settings.setValue("gui", "column5width", "100");
	if (settings.getValue("gui", "column6width").equals(""))
		settings.setValue("gui", "column6width", "40");
	if (settings.getValue("gui", "column7width").equals(""))
		settings.setValue("gui", "column7width", "60");
	if (settings.getValue("gui", "column8width").equals(""))
		settings.setValue("gui", "column8width", "40");
	if (settings.getValue("gui", "column9width").equals(""))
		settings.setValue("gui", "column9width", "40");
	if (settings.getValue("gui", "sortcolumn").equals(""))
		settings.setIntValue("gui", "sortcolumn", 0);
	if (settings.getValue("gui", "sortascending").equals(""))
		settings.setBooleanValue("gui", "sortascending", true);
	if (settings.getValue("gui", "columnorder").equals(""))
		settings.setValue("gui", "columnorder", "0 1 2 3 4 5 6 7 8");
	if (settings.getValue("gui", "sashweights").equals(""))
		settings.setValue("gui", "sashweights", "5 2");
  }
  
  private void saveSettings() {
	  settings.saveToFile(SETTINGS_CONF, true);
  }
  
  private void doDFendImport() {
    int defaultDosboxVersionIndex = ListUtils.findTIDefaultDosboxVersion(dbversionsList);
    if (defaultDosboxVersionIndex == -1) {
      GeneralPurposeDialogs.infoMessage(shell, "You must first define a default DOSBox version!");
      return;
    }
    
    FileDialog dialog = new FileDialog (shell, SWT.OPEN);
    dialog.setFilterPath(DFEND_PATH);
    dialog.setFileName("Profiles.dat");
    dialog.setFilterNames (new String [] {"D-Fend Profiles"});
    dialog.setFilterExtensions (new String [] {"Profiles.dat"});
    String dfendProfilesFile = dialog.open();
    if (dfendProfilesFile == null)
      return;
    
    boolean performCleanup = GeneralPurposeDialogs.confirmMessageYN(shell, "Would you like to perform some extra profile cleanup " +
    		"(remove sections directserial, modem, ipx and sdl) while importing?");

    DosboxVersion defaultDBVersion = dbversionsList.get(defaultDosboxVersionIndex);
    Configuration standardProfile = new Configuration(defaultDBVersion.getPath() + DOSBOX_CONF);
    Configuration profiles = new Configuration(dfendProfilesFile, false);
    Iterator it = profiles.getSections().keySet().iterator();
    while (it.hasNext()) {
      String title = (String)it.next();
      String profFile = profiles.getValue(title, "prof");
      String confFile = profiles.getValue(title, "conf");
      boolean favorite = profiles.getValue(title, "fav").equals("1");
      Configuration dfendExtra = new Configuration(profFile, false);
      String setup = dfendExtra.getValue("Extra", "Setup").toLowerCase();
      String setupParams = dfendExtra.getValue("Extra", "SetupParameters");
      String notes = dfendExtra.getValue("ExtraInfo", "Notes");
      String dev = dfendExtra.getValue("ExtraInfo", "Developer");
      String pub = dfendExtra.getValue("ExtraInfo", "Publisher");
      String gen = dfendExtra.getValue("ExtraInfo", "Genre");
      String yr = dfendExtra.getValue("ExtraInfo", "Year");
      String st = "Unknown";
      String cap = dfendExtra.getValue("dosbox", "captures");
      int devIndex = -1;
      int publIndex = -1;
      int genIndex = -1;
      int yrIndex = -1;
      int statIndex = -1;
      Iterator devIt = db.readDevelopersList().iterator();
      Iterator pubIt = db.readPublishersList().iterator();
      Iterator genIt = db.readGenresList().iterator();
      Iterator yrIt = db.readYearsList().iterator();
      Iterator statIt = db.readStatusList().iterator();
      while (devIt.hasNext()) {
        Developer developer = (Developer)devIt.next();
        if (developer.getName().equals(dev)) { devIndex = developer.getId(); break;}
      }
      while (pubIt.hasNext()) {
        Publisher publisher = (Publisher)pubIt.next();
        if (publisher.getName().equals(pub)) { publIndex = publisher.getId(); break;}
      }
      while (genIt.hasNext()) {
        Genre genre = (Genre)genIt.next();
        if (genre.getName().equals(gen)) { genIndex = genre.getId(); break;}
      }
      while (yrIt.hasNext()) {
        Year year = (Year)yrIt.next();
        if (year.getYear().equals(yr)) { yrIndex = year.getId(); break;}
      }
      while (statIt.hasNext()) {
        Status stat = (Status)statIt.next();
        if (stat.getStat().equals(st)) { statIndex = stat.getId(); break;}
      }
      int profileId = db.addOrEditProfile(title, dev, pub, gen, yr, st, setup, setupParams, notes,
              "", "", favorite, devIndex, publIndex, genIndex, yrIndex, statIndex,
              defaultDBVersion.getId(), -1);
      Configuration dfendProfile = new Configuration(confFile);
      Autoexec autoexec = new Autoexec(dfendProfile.getValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC));
      dfendProfile.setValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC, autoexec.toString(false));
      setCapturesDir(dfendProfile, profileId, cap);
      
      // clean up profile configuration
      if (performCleanup) {
	      dfendProfile.removeSection("directserial");
	      dfendProfile.removeSection("modem");
	      dfendProfile.removeSection("ipx");
	      dfendProfile.removeSection("sdl");
      }
      dfendProfile.removeValue("gus", "base");
      dfendProfile.removeValue("gus", "rate");
      dfendProfile.removeValue("sblaster", "base");
      dfendProfile.removeValue("sblaster", "type");
      if (dfendProfile.getValue("midi", "mpu401").equals("true")) {
        if (dfendProfile.getValue("midi", "intelligent").equals("true")) {
          dfendProfile.setValue("midi", "mpu401", "intelligent");
        } else if (dfendProfile.getValue("midi", "intelligent").equals("false")) {
          dfendProfile.setValue("midi", "mpu401", "uart");
        }
      } else if (dfendProfile.getValue("midi", "mpu401").equals("false")) {
        dfendProfile.setValue("midi", "mpu401", "none");
      }
      dfendProfile.removeValue("midi", "intelligent");
      if (defaultDBVersion.isMultiConfig())
    	  dfendProfile.substract(standardProfile);
      dfendProfile.saveToFile(PROFILES_DIR + System.getProperty("file.separator") + profileId + ".conf");
    }
    
    profilesList = db.readProfilesList(settings.getIntValue("gui", "sortcolumn"),
    		settings.getBooleanValue("gui", "sortascending"));
    profile_table.removeAll();
    for (Profile prof: profilesList) addProfileToTable(prof);
  }
  
  public static void setCapturesDir(Configuration profileConf, int profileId, String srcCap) {
    String capturesDir = FileUtils.getCwd();
    if (capturesDir != null) {
      capturesDir += File.separatorChar + CAPTURES_DIR + File.separatorChar + profileId;
      profileConf.setValue("dosbox", "captures", capturesDir);
      
      // Create directory and optionally copy files from src to dst
      FileUtils.createDir(capturesDir);
      if (srcCap != null)
        FileUtils.copyFiles(srcCap, CAPTURES_DIR + File.separatorChar + profileId + File.separatorChar);
    }
  }

  private void displayProfileInformation() {
    int index = profile_table.getSelectionIndex();
    if (index != -1) {
      Profile prof = profilesList.get(index);
      displayScreenshots(prof.getId());
      displayNotes(prof.getNotes());
      displayLinks(prof.getLink1(), prof.getLink2());
    } else {
      displayScreenshots(-1);
      displayNotes("");
      displayLinks("", "");
    }
  }
}
