/* 
 * Created on Jul 19, 2006 by ronald.blankendaal
 * 
 * @file $RCSfile: Autoexec.java,v $
 * @version $Revision: 1.12 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/08/20 21:27:01 $ (UTC date of last check in)
 */

package com.model;

import java.util.ArrayList;
import java.util.List;
import com.util.StringUtils;


public class Autoexec {

  private List<Mount> mountingpoints;
  private boolean loadfix;
  private int loadfixValue;
  private String main;
  private String setup;
  private String img1;
  private String img2;
  private boolean exit;
  private boolean isBooter;
  private String mainParams;
  private String setupParams;


  public Autoexec(String[] mountingpoints, boolean loadfix, String loadfixValue,
          String main, String setup, String mainParams, String setupParams,
          String img1, String img2, boolean exit) {
    this.mountingpoints = new ArrayList<Mount>();
    for (String mount: mountingpoints)
      this.mountingpoints.add(new Mount(mount));
    this.loadfix = loadfix;
    try {
      this.loadfixValue = Integer.parseInt(loadfixValue);
    } catch (NumberFormatException e) {
      this.loadfixValue = 0;
    }
    this.main = main.toLowerCase();
    this.setup = setup.toLowerCase();
    this.img1 = img1.toLowerCase();
    this.img2 = img2.toLowerCase();
    this.exit = exit;
    this.mainParams = mainParams;
    this.setupParams = setupParams;
  }

  public Autoexec(String autoexec) {
    init();
    
    if (autoexec.equals(""))
      return;
    
    String[] orgLines = autoexec.split("\n");
    char driveletter = '\0';
    char imgdriveletter1 = '\0';
    char imgdriveletter2 = '\0';
    String remainder = "";
    String executable = "";
    String image1 = "";
    String image2 = "";
    int exeIndex = -1;
    
    for (String orgLine: orgLines) {
      String line = orgLine.toLowerCase();
      if (line.startsWith("mount") || line.startsWith("imgmount")) {
        mountingpoints.add(new Mount(line));
      } else if (line.endsWith(":") && line.length() == 2) {
        driveletter = line.charAt(0);
      } else if (line.startsWith("cd " + System.getProperty("file.separator"))) {
        remainder = StringUtils.fixDir(line.substring(3));
      } else if (line.startsWith("cd ") && line.endsWith(System.getProperty("file.separator"))) {
        remainder = StringUtils.fixDir(line.substring(3));
      } else if (line.startsWith("cd" + System.getProperty("file.separator"))) {
        remainder = StringUtils.fixDir(line.substring(2));
      } else if ((exeIndex = line.indexOf(".com")) != -1 || 
                 (exeIndex = line.indexOf(".exe")) != -1 ||
                 (exeIndex = line.indexOf(".bat")) != -1) {
        executable = line;
        // If there is a space BEFORE executable name, strip everything before it
        int spaceBeforeIndex = executable.lastIndexOf(" ", exeIndex);
        if (spaceBeforeIndex != -1) {
          executable = executable.substring(spaceBeforeIndex + 1);
        }
        // If there is a space AFTER executable name, define it as being parameters
        int spaceAfterIndex = executable.indexOf(" ");
        if (spaceAfterIndex != -1) {
          mainParams = orgLine.substring(spaceBeforeIndex + spaceAfterIndex + 2);
          executable = executable.substring(0, spaceAfterIndex);
        }
      } else if (line.startsWith("boot ")) {
        isBooter = true;
        int spaceIndex = line.indexOf(' ', 5);
        if (spaceIndex != -1) {
          imgdriveletter2 = line.charAt(spaceIndex + 1);
          image2 = StringUtils.fixDir(line.substring(spaceIndex + 3));
        } else {
          spaceIndex = line.length();
        }
        imgdriveletter1 = line.charAt(5);
        image1 = StringUtils.fixDir(line.substring(7, spaceIndex));
      } else if (line.startsWith("exit")) {
        exit = true;
      }
      
      if (line.startsWith("loadfix -") && !line.startsWith("loadfix -f")) {
        loadfix = true;
        int endIndex = line.indexOf(' ', 9);
        if (endIndex == -1)
          endIndex = line.length();
        try {
          this.loadfixValue = Integer.parseInt(line.substring(9, endIndex));
        } catch (NumberFormatException e) {
          this.loadfixValue = 0;
        }
      }
    }
    
    for (Mount mount: mountingpoints) {
      char mount_drive = mount.getDriveletter();
      String mountPath = mount.getPath();
      if (driveletter == mount_drive) {
        main = mountPath + remainder + System.getProperty("file.separator") + executable;
      } else {
        if (imgdriveletter1 == mount_drive)
          img1 = mountPath + image1;
        if (imgdriveletter2 == mount_drive)
          img2 = mountPath + image2;
      } 
    }
  }

  private void init() {
    mountingpoints = new ArrayList<Mount>();
    loadfix = false;
    loadfixValue = 0;
    main = "";
    setup = "";
    img1 = "";
    img2 = "";
    exit = false;
    isBooter = false;
    mainParams = "";
    setupParams = "";
  }
  
  public String toString(boolean isSetup) {
    StringBuffer result = new StringBuffer();
    
    for (Mount mount: mountingpoints)
      result.append(mount.toString() + "\n");
    
    if (!main.equals("")) {
      
      String[] dosboxLocation = convertToDosboxPath(isSetup? setup: main);
      result.append(dosboxLocation[0] + "\n"); // move to drive
      result.append("cd " + dosboxLocation[1] + "\\\n"); // move to dir
      if (loadfix)
        result.append("loadfix -" + loadfixValue + "\n");
      if (dosboxLocation[2].endsWith(".bat"))
        result.append("call ");
      result.append(dosboxLocation[2]);
      
      if (isSetup && !setupParams.equals(""))
        result.append(" " + setupParams);
      else if (!isSetup && !mainParams.equals(""))
        result.append(" " + mainParams);
       
      if (loadfix)
        result.append("\nloadfix -f");
      if (exit)
        result.append("\nexit");

    } else if (!img1.equals("")) {

      if (loadfix)
        result.append("loadfix -" + loadfixValue + "\n");
      String[] dosboxLocation = convertToDosboxPath(img1);
      result.append("boot " + dosboxLocation[0] + dosboxLocation[1] + "\\" + dosboxLocation[2]);
      if (img2 != "") {
        dosboxLocation = convertToDosboxPath(img2);
        result.append(" " + dosboxLocation[0] + dosboxLocation[1] + "\\" + dosboxLocation[2]);
      }
      if (loadfix)
        result.append("\nloadfix -f");
      if (exit)
        result.append("\nexit");

    } else {
    	
    	// a template
    	if (exit)
            result.append("exit");

    }
    
    return result.toString();
  }
  
  private String[] convertToDosboxPath(String hostFileLocation) {
	  String[] result = new String[3];
	  result[0] = ""; result[1] = "";
	  int firstSlashIndex = hostFileLocation.indexOf(System.getProperty("file.separator"));
	  int lastSlashIndex = hostFileLocation.lastIndexOf(System.getProperty("file.separator"));
	  if (firstSlashIndex == -1 || lastSlashIndex == -1) {
		  result[2] = hostFileLocation;
		  return result;
	  }
	  char hostDrive = '\0';
	  char mountDrive = '\0';
	  if (hostFileLocation.charAt(1) == ':') {
		  // we're on a windows-based OS with drive letters
		  hostDrive = hostFileLocation.charAt(0);
	  }
	  String hostDir = StringUtils.fixDir(hostFileLocation.substring(firstSlashIndex, lastSlashIndex));
	  result[2] = hostFileLocation.substring(lastSlashIndex + 1);
	  for (Mount mount: mountingpoints) {
		  String mountDir = mount.getPath();
		  if (mountDir.charAt(1) == ':') {
			  // we're on a windows-based OS with drive letters
			  mountDrive = mount.getPath().charAt(0);
			  mountDir = mountDir.substring(2);
		  }
		  if ((hostDrive == mountDrive) && hostDir.startsWith(mountDir)) {
			  result[0] = mount.getDriveletter() + ":";
			  result[1] = StringUtils.fixDir(hostDir.substring(mountDir.length()));
			  break;
		  }
	  }
	  // translate *nix paths to dosbox paths
	  result[2].replace('/', '\\');
	  return result;
  }

  public boolean isExit() {
    return exit;
  }

  public String getImg1() {
    return img1;
  }

  public String getImg2() {
    return img2;
  }

  public boolean isLoadfix() {
    return loadfix;
  }

  public String getLoadfixValue() {
    return loadfixValue > 0? String.valueOf(loadfixValue): "";
  }

  public String getMain() {
    return main;
  }

  public String[] getMountingpoints() {
    String[] result = new String[mountingpoints.size()];
    int i = 0;
    for (Mount mount: mountingpoints)
      result[i++] = mount.toString();
    return result;
  }

  public String getSetup() {
    return setup;
  }
  
  public void setSetup(String setup) {
    this.setup = setup;
  }
  
  public void setSetupParameters(String setupParams) {
    this.setupParams = setupParams;
  }
  
  public boolean isBooter() {
    return isBooter;
  }
  
  public String getMainParameters() {
    return mainParams;
  }

  public String getSetupParameters() {
    return setupParams;
  }
}
