/* 
 * Created on 3-jul-2006 by ronald.blankendaal
 * 
 * @file $RCSfile: Configuration.java,v $
 * @version $Revision: 1.13 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/08/30 09:53:41 $ (UTC date of last check in)
 */

package com.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.TreeMap;


public class Configuration {

  private java.util.HashMap<String, Section> sections;
  public static final String AUTOEXEC = "autoexec";
  
  public java.util.HashMap getSections() {
    return sections;
  }
  
  public class Section {
    private java.util.HashMap<String, String> sectionItems;
    
    public java.util.HashMap getSectionItems() {
      return sectionItems;
    }
    
    public Section(Section sec) {
      sectionItems = new java.util.HashMap<String, String>();
      for (String key: sec.sectionItems.keySet())
        sectionItems.put(new String(key), new String(sec.sectionItems.get(key)));
    }
    
    public Section() {
      sectionItems = new java.util.HashMap<String, String>();
    }
    
    public void addAutoexecItem(String value) {
      if (sectionItems.containsKey(AUTOEXEC))
        sectionItems.put(AUTOEXEC, sectionItems.get(AUTOEXEC) + "\n" + value);
      else
        sectionItems.put(AUTOEXEC, value); 
    }
    
    public void substract(Section sec) {
      for (String key: sec.sectionItems.keySet()) {
        if (sectionItems.containsKey(key)) {
          String value = sec.sectionItems.get(key);
          String thisvalue = sectionItems.get(key);
          if (thisvalue.equals(value))
            sectionItems.remove(key);
        }
      }
    }
    
    public String toString() {
      StringBuffer result = new StringBuffer();
      for (String key: sectionItems.keySet()) {
        String value = sectionItems.get(key);
        if (key.equals(AUTOEXEC)) {
          result.append(value + "\n");
        } else {
          result.append(key + "=" + value + "\n");
        }
      }
      return result.toString();
    }
    
    public String toStringOrdered() {
        StringBuffer result = new StringBuffer();
        for (String key: new TreeMap<String, String>(sectionItems).keySet()) {
          String value = sectionItems.get(key);
          if (key.equals(AUTOEXEC)) {
            result.append(value + "\n");
          } else {
            result.append(key + "=" + value + "\n");
          }
        }
        return result.toString();
      }
  }
  
  public Configuration(Configuration conf) {
    sections = new java.util.HashMap<String, Section>();
    for (String key: conf.sections.keySet())
      sections.put(key, new Section(conf.sections.get(key)));
  }
  
  public Configuration() {
    sections = new java.util.HashMap<String, Section>();
  }
  
  public Configuration(String file) {
    sections = new java.util.HashMap<String, Section>();
    parseConfigurationFile(file, true);
  }
  
  public Configuration(String file, boolean toLowerCase) {
    sections = new java.util.HashMap<String, Section>();
    parseConfigurationFile(file, toLowerCase);
  }
  
  public void saveToFile(String file){
	  saveToFile(file, false);
  }
  
  public void saveToFile(String file, boolean ordered) {
    try {
      BufferedWriter configData = new BufferedWriter(new FileWriter(file));
      if (ordered)
    	  configData.write(toStringOrdered());
      else
    	  configData.write(toString());
      configData.flush();
      configData.close();
    } catch (IOException e) {
      System.err.println("Something went wrong while trying to save " + file);
      System.err.println(e.toString());
    }
  }

	public void parseConfigurationFile(String file) {
    parseConfigurationFile(file, true);
  }
  
  public void parseConfigurationFile(String file, boolean toLowerCase) {
    try {
      BufferedReader configData = new BufferedReader(new FileReader(file));
      String textLine;
      String currentSectionTitle = null;
      Section currentSection = null;

      while ((textLine = configData.readLine()) != null) {
        textLine = textLine.trim();
        String orgTextLine = textLine.trim();
        if (toLowerCase)
          textLine = textLine.toLowerCase();
        if ((textLine.length() > 0) && !textLine.startsWith("#")) {
          if (textLine.startsWith("[")) { // a new section starts here
            int start = textLine.indexOf(("["));
            int end = textLine.lastIndexOf("]");
            if (end == -1) {
              System.err.println("Parsing error in line: " + textLine);
            } else {
              currentSectionTitle = textLine.substring(start + 1, end);
              if (sections.containsKey(currentSectionTitle)) {
                currentSection = sections.get(currentSectionTitle);
              } else {
                currentSection = new Section();
                sections.put(currentSectionTitle, currentSection);
              }
            }
          } else { // an item starts here
            if (currentSectionTitle != null) {
            	if (currentSectionTitle.equals(AUTOEXEC)) { // autoexec config item
            		currentSection.addAutoexecItem(orgTextLine);
	            } else {                                     // normal config item
	              int end = textLine.indexOf("=");
	              if (end == -1) {
	                System.err.println("Parsing error in " + file + ", line: " + textLine);
	              } else {
	                String name = textLine.substring(0, end).trim();
	                String value = textLine.substring(end + 1).trim();
	                currentSection.sectionItems.put(name, value);
	              }
	            }
            } else { // value before section
            	System.err.println("Parsing error (no section) in " + file + ", line: " + textLine);
            }
          }
        }
      }
      configData.close();
    }
    catch (FileNotFoundException e) {
      System.err.println("Could not read " + file);
    }
    catch (IOException e) {
      System.err.println("Something went wrong while trying to read " + file);
      System.err.println(e.toString());
    }
  }
  
  public boolean hasValue(String sectionTitle, String sectionItem) {
		return sections.containsKey(sectionTitle) &&
			sections.get(sectionTitle).sectionItems.containsKey(sectionItem);
	}
	
	public String getValue(String sectionTitle, String sectionItem) {
	  String result = null;
	  if (sections.containsKey(sectionTitle))
	    result = sections.get(sectionTitle).sectionItems.get(sectionItem);
	  if (result == null)
	    return ""; // in case the item was not found
	  return result;
	}

	public int getIntValue(String sectionTitle, String sectionItem) {
	  try {
		  return Integer.parseInt(getValue(sectionTitle, sectionItem));
	  } catch (NumberFormatException e) {
		  return -1; // value is not a number
	  }
  }
  
  public boolean getBooleanValue(String sectionTitle, String sectionItem) {
	  return Boolean.valueOf(getValue(sectionTitle, sectionItem));
  }
  
  public void createSection(String sectionTitle) {
	  if (!sections.containsKey(sectionTitle))
		  sections.put(sectionTitle, new Section());
  }
  
  public void setValue(String sectionTitle, String sectionItem, String value) {
    if (sections.containsKey(sectionTitle))
      sections.get(sectionTitle).sectionItems.put(sectionItem, value);
  }
  
  public void updateValue(String sectionTitle, String sectionItem, String value) {
    if (sections.containsKey(sectionTitle))
    	if (sections.get(sectionTitle).sectionItems.containsKey(sectionItem))
    		sections.get(sectionTitle).sectionItems.put(sectionItem, value);
  }
  
  public void setIntValue(String sectionTitle, String sectionItem, int value) {
	  setValue(sectionTitle, sectionItem, String.valueOf(value));
  }
  
  public void setBooleanValue(String sectionTitle, String sectionItem, boolean value) {
	  setValue(sectionTitle, sectionItem, String.valueOf(value));
  }
	  
  public void removeSection(String title) {
    sections.remove(title);
  }
  
  public void removeValue(String sectionTitle, String sectionItem) {
    if (sections.containsKey(sectionTitle)) {
      Section sec = sections.get(sectionTitle);
      sec.sectionItems.remove(sectionItem);
      if (sec.sectionItems.isEmpty())
        sections.remove(sectionTitle);
    }
  }
  
  public void substract(Configuration conf) {
    for (String key: conf.sections.keySet()) {
      if (sections.containsKey(key)) {
        Section mysec = sections.get(key);
        mysec.substract(conf.sections.get(key));
        if (mysec.sectionItems.isEmpty())
          sections.remove(key);
      }
    }
  }
  
  public String toString() {
    StringBuffer result = new StringBuffer();
    StringBuffer autoexec = new StringBuffer();
    for (String key: sections.keySet())
      if (!key.equals(AUTOEXEC)) {
        result.append("[" + key + "]\n");
        result.append((sections.get(key)).toString() + "\n");
      } else {
        autoexec.append("[" + key + "]\n");
        autoexec.append((sections.get(key)).toString());
      }
    return result.toString() + autoexec.toString();
  }
  
  public String toStringOrdered() {
	  StringBuffer result = new StringBuffer();
	  StringBuffer autoexec = new StringBuffer();
	  for (String key: sections.keySet())
		  if (!key.equals(AUTOEXEC)) {
			  result.append("[" + key + "]\n");
			  result.append((sections.get(key)).toStringOrdered() + "\n");
		  } else {
			  autoexec.append("[" + key + "]\n");
			  autoexec.append((sections.get(key)).toString());
		  }
	  return result.toString() + autoexec.toString();
  }
}
