/* 
 * Created on 1-jul-2006 by ronald.blankendaal
 * 
 * @file $RCSfile: DosboxVersion.java,v $
 * @version $Revision: 1.4 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/09/12 18:16:14 $ (UTC date of last check in)
 */

package com.model;

import java.io.File;
import java.io.IOException;
import com.gui.MainWindow;


public class DosboxVersion {

  private int id;
  private String title;
  private String path;
  private boolean multiConfig;
  private boolean defaultVersion;
  
  
  public DosboxVersion(int id, String title, String path, boolean multiConfig, boolean version) {
    this.id = id;
    this.title = title;
    this.path = path;
    this.multiConfig = multiConfig;
    this.defaultVersion = version;
  }
  /**
   * @return Returns the defaultVersion.
   */
  public boolean isDefaultVersion() {
    return defaultVersion;
  }
  /**
   * @return Returns the defaultVersion as String.
   */
  public String isDefaultVersionString() {
    return defaultVersion ? "Yes": "No";
  }
  /**
   * @return Returns multiConfig.
   */
  public boolean isMultiConfig() {
    return multiConfig;
  }
  /**
   * @return Returns multiConfig as String.
   */
  public String isMultiConfigString() {
    return multiConfig ? "Yes": "No";
  }
  /**
   * @return Returns the id.
   */
  public int getId() {
    return id;
  }
  /**
   * @return Returns the path.
   */
  public String getPath() {
    return path;
  }
  
  /**
   * @return Returns the canonical path.
   */
  public String getCanonicalPath() {
  	try {
			return new File(path).getCanonicalPath();
		} catch (IOException e) {
			return new File(path).getAbsolutePath();
		}
  }
  
  /**
   * @return Returns the title.
   */
  public String getTitle() {
    return title;
  }
  
  public String getExecutable() {
  	if (path.indexOf('/') != -1) {
  		// *nix
  		try {
  			return new File(path + "dosbox").getCanonicalPath();
  		} catch (IOException e) {
  			return new File(path + "dosbox").getAbsolutePath();
  		}
  	} else {
  		// Windows
  		try {
  			return new File(path + "DOSBox.exe").getCanonicalPath();
  		} catch (IOException e) {
  			return new File(path + "DOSBox.exe").getAbsolutePath();
  		}
  	}
  }
  
  public String getConfigFile() {
  	try {
			return new File(path + MainWindow.DOSBOX_CONF).getCanonicalPath();
		} catch (IOException e) {
			return new File(path + MainWindow.DOSBOX_CONF).getAbsolutePath();
		}
  }
}
