/* 
 * Created on Jul 17, 2006 by ronald.blankendaal
 * 
 * @file $RCSfile: GeneralPurposeDialogs.java,v $
 * @version $Revision: 1.10 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/09/12 18:28:12 $ (UTC date of last check in)
 */

package com.gui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import com.util.StringUtils;


public abstract class GeneralPurposeDialogs {

  private static List<String> errorMessages;
  private static Control wgt;
  private static TabItem tab;


  public static void infoMessage(Shell shell, String theMessage) {
    MessageBox messageBox = new MessageBox(shell, SWT.APPLICATION_MODAL | SWT.ICON_INFORMATION | SWT.OK);
    messageBox.setText("Information");
    messageBox.setMessage(theMessage);
    messageBox.open();
  }
  
  private static void infoMessage(Shell shell, String theMessage, Control wgt) {
    infoMessage(shell, theMessage);
    wgt.setFocus();
  }
  
  private static void infoMessage(Shell shell, String theMessage, Control wgt, TabItem tabItem) {
    TabFolder folder = tabItem.getParent();
    folder.setSelection(tabItem);
    infoMessage(shell, theMessage);
    wgt.setFocus();
  }
  
  public static boolean confirmMessage(Shell shell, String theMessage) {
	  MessageBox messageBox = new MessageBox(shell, SWT.APPLICATION_MODAL | SWT.ICON_WARNING | SWT.YES | SWT.NO);
	  messageBox.setText("Information");
	  messageBox.setMessage(theMessage);
	  return messageBox.open() == SWT.YES;
  }
  
  public static void initErrorDialog() {
    errorMessages = new ArrayList<String>();
    wgt = null;
    tab = null;
  }
  
  public static void addError(String msg, Control widget) {
    if (errorMessages.isEmpty())
      wgt = widget;
    errorMessages.add(msg);
  }
  
  public static void addError(String msg, Control widget, TabItem tabItem) {
    if (errorMessages.isEmpty()) {
      wgt = widget;
      tab = tabItem;
    }
    errorMessages.add(msg);
  }
  
  public static boolean displayErrorDialog(Shell shell) {
    boolean errors = !errorMessages.isEmpty();
    if (errors)
      if (tab != null)
        infoMessage(shell, StringUtils.listToString(errorMessages), wgt, tab);
      else
        infoMessage(shell, StringUtils.listToString(errorMessages), wgt);
    return errors;
  }
}
