/* 
 * Created on Jul 23, 2006 by ronald.blankendaal
 * 
 * @file $RCSfile: FileUtils.java,v $
 * @version $Revision: 1.6 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/09/12 18:17:43 $ (UTC date of last check in)
 */

package com.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.List;
import com.gui.MainWindow;
import com.gui.StreamGobbler;
import com.model.Configuration;


public abstract class FileUtils {

  public static String getCwd() {
    try {
      return new File(".").getCanonicalPath();
    } catch(IOException ex) {
      System.err.println("Couldn't get current working directory!!\n");
    }
    return null; // this shouldn't ever fail
  }
  
  public static void createDir(String dir) {
    if (!new File(dir).exists() && !new File(dir).mkdirs())
      System.err.println("Couldn't create " + dir + " directory!!\n");
  }
  
  public static void copyFiles(String srcDir, String dstDir) {
    File[] srcFiles = new File(srcDir).listFiles();
    if (srcFiles != null)
      for (File src: srcFiles)
        if (src.isFile()) FileUtils.copy(src, new File(dstDir + src.getName()));
  }
  
  /** Fast & simple file copy. */
  public static void copy(File source, File dest) {
       FileChannel in = null, out = null;
       try {          
         in = new FileInputStream(source).getChannel();
         out = new FileOutputStream(dest).getChannel();
         in.transferTo(0, in.size(), out);
       } catch (IOException e) {
         System.err.println("Couldn't copy file " + source + " to directory " + dest + "!!\n");
       } finally {
         if (in != null) try {in.close();} catch (IOException ex) {}
         if (out != null) try {out.close();} catch (IOException ex) {}
       }
  }
  
  public static void removeFile(String filename) {
    File file = new File(filename);
    if (file.isFile())
      file.delete();
  }
  
  public static void removeDir(String dirname) {
    File dir = new File(dirname);
    if (dir.isDirectory())
      dir.delete();
  }
  
  public static boolean isExistingReadableFile(String filename) {
    File file = new File(filename);
    return file.isFile() && file.canRead();
  }
  
  public static void executeCommand(List<String> execCommands, String cwd, 
  		boolean waitFor) throws IOException {
  	String[] rtCmds = new String[execCommands.size()];
  	for (int i = 0; i < execCommands.size(); i++) {
    	rtCmds[i] = execCommands.get(i);
    	System.out.print(rtCmds[i] + " ");
    }
    System.out.println();
    File dir = (cwd != null)? new File(cwd): null;
  	Process proc = Runtime.getRuntime().exec(rtCmds, null, dir);
    StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "DOSBox stderr");            
    StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "DOSBox stdout");
    outputGobbler.start();
    errorGobbler.start();
    if (waitFor)
    	try {	proc.waitFor();} catch (InterruptedException e) {}
  }
  
  public static void setCapturesDir(Configuration profileConf, int profileId, String srcCap) {
    String capturesDir = getCwd();
    if (capturesDir != null) {
      capturesDir += File.separatorChar + MainWindow.CAPTURES_DIR + File.separatorChar + profileId;
      profileConf.setValue("dosbox", "captures", capturesDir);
      
      // Create directory and optionally copy files from src to dst
      createDir(capturesDir);
      if (srcCap != null)
        copyFiles(srcCap, MainWindow.CAPTURES_DIR + File.separatorChar + profileId + File.separatorChar);
    }
  }
  
  public static String getProfileConfig(String filename) {
  	String result = getCwd();
  	if (result != null) {
  		result += File.separatorChar + MainWindow.PROFILES_DIR + File.separatorChar + filename;
  	}
  	return result;
  }
}
