/* 
 * Created on 1-jul-2006 by ronald.blankendaal
 * 
 * @file $RCSfile: DosboxVersion.java,v $
 * @version $Revision: 1.6 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/10/03 21:41:45 $ (UTC date of last check in)
 */

package com.model;

import com.util.FileUtils;
import com.util.PlatformUtils;


public class DosboxVersion {

  private int id;
  private String title;
  private String path;
  private boolean multiConfig;
  private boolean defaultVersion;
  
  
  public DosboxVersion(int id, String title, String path, boolean multiConfig, boolean version) {
    this.id = id;
    this.title = title;
    this.path = path;
    this.multiConfig = multiConfig;
    this.defaultVersion = version;
  }
  /**
   * @return Returns the defaultVersion.
   */
  public boolean isDefaultVersion() {
    return defaultVersion;
  }
  /**
   * @return Returns the defaultVersion as String.
   */
  public String isDefaultVersionString() {
    return defaultVersion ? "Yes": "No";
  }
  /**
   * @return Returns multiConfig.
   */
  public boolean isMultiConfig() {
    return multiConfig;
  }
  /**
   * @return Returns multiConfig as String.
   */
  public String isMultiConfigString() {
    return multiConfig ? "Yes": "No";
  }
  /**
   * @return Returns the id.
   */
  public int getId() {
    return id;
  }
  /**
   * @return Returns the path.
   */
  public String getPath() {
    return path;
  }
  
  /**
   * @return Returns the canonical path.
   */
  public String getCanonicalPath() {
  	return FileUtils.getCanonicalPath(path);
  }
  
  /**
   * @return Returns the title.
   */
  public String getTitle() {
    return title;
  }
  
  public String getExecutable() {
  	return FileUtils.getCanonicalPath(path + PlatformUtils.DB_EXECUTABLE);
  }
  
  public String getConfigFile() {
  	return FileUtils.getCanonicalPath(path + FileUtils.DOSBOX_CONF);
  }
  
  public void toggleDefault() {
  	defaultVersion = !defaultVersion;
  }
}
