package com.gui;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.swt.widgets.Shell;
import com.db.Database;
import com.model.DosboxVersion;
import com.model.Settings;
import com.util.ListUtils;


public class SendToProfile extends Shell {

	private static final String LOCALHOST = "localhost";
	
	
	/**
	 * Launch the application
	 * 
	 * @param args
	 */
	public static void main(String args[]) {
		if (args.length < 1) {
			System.err.println("Usage: add.bat <dos-executable>|<booter image>|<config-file>");
      System.exit(1);
		}
		
		try {
			
			Settings settings = Settings.getInstance();
      Socket socket = new Socket(LOCALHOST, settings.getIntValue("communication", "port"));
      new PrintWriter(socket.getOutputStream(), true).println("sendtoprofile " + args[0]);
  	  socket.close();
      
    } catch (UnknownHostException e) {
      System.err.println("Unknown host: " + LOCALHOST);
      System.exit(1);
    } catch  (IOException e) {
      System.out.println("Could not make socket connection, DBGL is probably not running");
      openDialogMyself(args[0]);
    }
	}
	
	private static void openDialogMyself(String file) {
		Database db = Database.getInstance();

		Shell shell = new Shell();
		shell.setMinimized(true);
		shell.open();
		shell.setText("Send to profile");
		java.util.List<DosboxVersion> dbversionsList = db.readDosboxVersionsList();
		if (ListUtils.findTIDefaultDosboxVersion(dbversionsList) == -1) {
			GeneralPurposeDialogs.infoMessage(shell, "You must first define a default DOSBox version!");
			db.shutdown();
			return;
		}

		EditProfileDialog editProfDialog = new EditProfileDialog(shell);
		editProfDialog.sendToProfile(file);
		editProfDialog.open();

		db.shutdown();
	}
}
