package com.util;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import com.db.Database;
import com.model.Autoexec;
import com.model.Configuration;
import com.model.Developer;
import com.model.DosboxVersion;
import com.model.Genre;
import com.model.Publisher;
import com.model.Status;
import com.model.Year;


public class DFendImportThread extends Thread {

	private String title;
	private int profileNumber;
	StringBuffer messageLog;
	private boolean performCleanup;
	private DosboxVersion defaultDBVersion;
	private Configuration standardProfile;
	private Configuration profiles;
	private Display display;
	private Text log;
	private ProgressBar progressBar;
	private Label profileLabel;
	
	
	public DFendImportThread(String dfendProfilesFile, boolean performCleanup, DosboxVersion defaultDBVersion,
			Text log, ProgressBar progressBar, Label profileLabel) throws IOException {
		this.performCleanup = performCleanup;
		this.defaultDBVersion = defaultDBVersion;
		this.standardProfile = new Configuration(defaultDBVersion.getConfigFile());
		this.log = log;
		this.progressBar = progressBar;
		this.profileLabel = profileLabel;
		this.display = log.getShell().getDisplay();
		this.profiles = new Configuration(dfendProfilesFile, false);
    this.progressBar.setMaximum(profiles.getSectionKeys().size());
    this.profileNumber = 0;
	}
	
	public void run() {
		Database db = Database.getInstance();
    
    Iterator it = profiles.getSectionKeys().iterator();
    while (it.hasNext()) {
    	messageLog = new StringBuffer();
    	
    	title = (String)it.next();
    	String profFile = profiles.getValue(title, "prof");
      String confFile = profiles.getValue(title, "conf");
      boolean favorite = profiles.getValue(title, "fav").equals("1");
      try {
      	Configuration dfendExtra = new Configuration(profFile, false);
	      String setup = dfendExtra.getValue("Extra", "Setup");
	      String setupParams = dfendExtra.getValue("Extra", "SetupParameters");
	      String notes = dfendExtra.getValue("ExtraInfo", "Notes");
	      String dev = dfendExtra.getValue("ExtraInfo", "Developer");
	      String pub = dfendExtra.getValue("ExtraInfo", "Publisher");
	      String gen = dfendExtra.getValue("ExtraInfo", "Genre");
	      String yr = dfendExtra.getValue("ExtraInfo", "Year");
	      String st = "Unknown";
	      String cap = dfendExtra.getValue("dosbox", "captures");
	      int devIndex = -1;
	      int publIndex = -1;
	      int genIndex = -1;
	      int yrIndex = -1;
	      int statIndex = -1;
	      Iterator devIt = db.readDevelopersList().iterator();
	      Iterator pubIt = db.readPublishersList().iterator();
	      Iterator genIt = db.readGenresList().iterator();
	      Iterator yrIt = db.readYearsList().iterator();
	      Iterator statIt = db.readStatusList().iterator();
	      while (devIt.hasNext()) {
	        Developer developer = (Developer)devIt.next();
	        if (developer.getName().equals(dev)) { devIndex = developer.getId(); break;}
	      }
	      while (pubIt.hasNext()) {
	        Publisher publisher = (Publisher)pubIt.next();
	        if (publisher.getName().equals(pub)) { publIndex = publisher.getId(); break;}
	      }
	      while (genIt.hasNext()) {
	        Genre genre = (Genre)genIt.next();
	        if (genre.getName().equals(gen)) { genIndex = genre.getId(); break;}
	      }
	      while (yrIt.hasNext()) {
	        Year year = (Year)yrIt.next();
	        if (year.getYear().equals(yr)) { yrIndex = year.getId(); break;}
	      }
	      while (statIt.hasNext()) {
	        Status stat = (Status)statIt.next();
	        if (stat.getStat().equals(st)) { statIndex = stat.getId(); break;}
	      }
	      
	      int profileId = db.addOrEditProfile(title, dev, pub, gen, yr, st, setup, setupParams, notes,
	      		"", "", favorite, devIndex, publIndex, genIndex, yrIndex, statIndex,
	      		defaultDBVersion.getId(), -1);
	      final Configuration dfendProfile = new Configuration(confFile);
	      Autoexec autoexec = new Autoexec(dfendProfile.getValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC));
	      dfendProfile.setValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC, autoexec.toString(false));
	      
	      String dstCap = FileUtils.constructCapturesDir(profileId);
	      FileUtils.createDir(dstCap);
	      FileUtils.copyFiles(cap, dstCap);
	      dfendProfile.setValue("dosbox", "captures", FileUtils.constructCanonicalCapturesDir(profileId));
	      
	      // clean up profile configuration
	      if (performCleanup) {
		      dfendProfile.removeSection("directserial");
		      dfendProfile.removeSection("modem");
		      dfendProfile.removeSection("ipx");
		      dfendProfile.removeSection("sdl");
	      }
	      dfendProfile.removeValue("gus", "base");
	      dfendProfile.removeValue("gus", "rate");
	      dfendProfile.removeValue("sblaster", "base");
	      dfendProfile.removeValue("sblaster", "type");
	      if (dfendProfile.getValue("midi", "mpu401").equals("true")) {
	        if (dfendProfile.getValue("midi", "intelligent").equals("true"))
	          dfendProfile.setValue("midi", "mpu401", "intelligent");
	        else if (dfendProfile.getValue("midi", "intelligent").equals("false"))
	          dfendProfile.setValue("midi", "mpu401", "uart");
	      } else if (dfendProfile.getValue("midi", "mpu401").equals("false")) {
	        dfendProfile.setValue("midi", "mpu401", "none");
	      }
	      dfendProfile.removeValue("midi", "intelligent");
	      if (defaultDBVersion.isMultiConfig())
	    	  dfendProfile.substract(standardProfile);
	      
	      String newConfFile = FileUtils.constructUniqueConfigFile(profileId, title, dfendProfile.getGameLocation());
	      dfendProfile.saveToFile(newConfFile);
	      
	      db.updateProfileConf(newConfFile, dstCap, profileId);
	      
	      messageLog.append(dfendExtra.getParsingProblems());
	      messageLog.append(dfendProfile.getParsingProblems());
	      
      } catch (IOException e) {
      	messageLog.append(e.getMessage() + "\n");
      }
      
      if (display.isDisposed() || log.isDisposed() || progressBar.isDisposed()) break;
			display.asyncExec(new Runnable() {
				public void run() {
					profileLabel.setText("Importing " + title + "...");
					profileLabel.pack();
					log.append(messageLog.toString());
					progressBar.setSelection(profileNumber++);
				}
			});
    }
	}
}
