package com.gui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import com.model.Configuration;
import com.model.Settings;
import swing2swt.layout.BorderLayout;


public class SettingsDialog extends Dialog {

	public final static String[] confLocations = {"In DBGL profiles subdirectory", "In game directory"};
	public final static String[] confFilenames = {"Filename by unique ID", "Filename by profile title"};
	
	private Combo confFilename;
	private Combo confLocation;
	private Text port;
	private int previousSelection = -1;
	private Text values;
	private Configuration conf;
	private List options;
	protected Object result;

	protected Shell shell;

	/**
	 * Create the dialog
	 * @param parent
	 * @param style
	 */
	public SettingsDialog(Shell parent, int style) {
		super(parent, style);
	}

	/**
	 * Create the dialog
	 * @param parent
	 */
	public SettingsDialog(Shell parent) {
		this(parent, SWT.NONE);
	}

	/**
	 * Open the dialog
	 * @return the result
	 */
	public Object open() {
		conf = new Configuration(Settings.getInstance());
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		return result;
	}

	/**
	 * Create contents of the dialog
	 */
	protected void createContents() {
		shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
		shell.setLayout(new BorderLayout(0, 0));
		shell.setSize(500, 375);
		shell.setText("Settings");

		final TabFolder tabFolder = new TabFolder(shell, SWT.NONE);

		final TabItem generalTabItem = new TabItem(tabFolder, SWT.NONE);
		generalTabItem.setText("General");

		final Composite composite = new Composite(tabFolder, SWT.NONE);
		composite.setLayout(new GridLayout());
		generalTabItem.setControl(composite);

		final Group dosboxGroup = new Group(composite, SWT.NONE);
		dosboxGroup.setText("DOSBox");
		final GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		dosboxGroup.setLayout(gridLayout);

		final Label showConsoleLabel = new Label(dosboxGroup, SWT.NONE);
		showConsoleLabel.setText("Hide DOSBox Status Window");

		final Button console = new Button(dosboxGroup, SWT.CHECK);
		console.setSelection(conf.getBooleanValue("dosbox", "hideconsole"));

		final Group sendToGroup = new Group(composite, SWT.NONE);
		sendToGroup.setText("Send To (Requires restart)");
		final GridLayout gridLayout_2 = new GridLayout();
		gridLayout_2.numColumns = 2;
		sendToGroup.setLayout(gridLayout_2);

		final Label enableCommunicationLabel = new Label(sendToGroup, SWT.NONE);
		enableCommunicationLabel.setText("Enable communication port");

		final Button portEnabled = new Button(sendToGroup, SWT.CHECK);
		portEnabled.setSelection(conf.getBooleanValue("communication", "port_enabled"));
		portEnabled.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent e) {
				port.setEnabled(portEnabled.getSelection());
			}
		});

		final Label portnumberLabel = new Label(sendToGroup, SWT.NONE);
		portnumberLabel.setText("Port");

		port = new Text(sendToGroup, SWT.BORDER);
		port.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		port.setText(conf.getValue("communication", "port"));
		port.setEnabled(portEnabled.getSelection());

		final Group profileDefaultsGroup = new Group(composite, SWT.NONE);
		profileDefaultsGroup.setText("Profile defaults");
		final GridLayout gridLayout_3 = new GridLayout();
		gridLayout_3.numColumns = 3;
		profileDefaultsGroup.setLayout(gridLayout_3);

		final Label configurationFileLabel = new Label(profileDefaultsGroup, SWT.NONE);
		configurationFileLabel.setText("Configuration file");

		confLocation = new Combo(profileDefaultsGroup, SWT.READ_ONLY);
		confLocation.setItems(confLocations);
		confLocation.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		confLocation.select(conf.getIntValue("profiledefaults", "confpath"));

		confFilename = new Combo(profileDefaultsGroup, SWT.READ_ONLY);
		confFilename.setItems(confFilenames);
		confFilename.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		confFilename.select(conf.getIntValue("profiledefaults", "conffile"));

		final TabItem dynamicOptionsTabItem = new TabItem(tabFolder, SWT.NONE);
		dynamicOptionsTabItem.setText("Dynamic options");

		final Composite composite_1 = new Composite(tabFolder, SWT.NONE);
		composite_1.setLayout(new FillLayout());
		dynamicOptionsTabItem.setControl(composite_1);

		final Group dynamicOptionsGroup = new Group(composite_1, SWT.NONE);
		final GridLayout gridLayout_1 = new GridLayout();
		gridLayout_1.numColumns = 2;
		dynamicOptionsGroup.setLayout(gridLayout_1);
		dynamicOptionsGroup.setText("Dynamic options");

		final Label optionsLabel = new Label(dynamicOptionsGroup, SWT.NONE);
		optionsLabel.setText("Options");

		final Label valuesLabel = new Label(dynamicOptionsGroup, SWT.NONE);
		valuesLabel.setText("Values");

		options = new List(dynamicOptionsGroup, SWT.V_SCROLL | SWT.BORDER);
		options.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent e) {
				storeValues();
				previousSelection = options.getSelectionIndex();
				values.setText(conf.getMultilineValues("profile", options.getItem(previousSelection)));
			}
		});
		options.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		for (String s: conf.getItems("profile"))
			options.add(s);

		values = new Text(dynamicOptionsGroup, SWT.V_SCROLL | SWT.MULTI | SWT.BORDER | SWT.H_SCROLL);
		values.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

		final Composite composite_7 = new Composite(shell, SWT.NONE);
		composite_7.setLayout(new RowLayout());
		composite_7.setLayoutData(BorderLayout.SOUTH);

		final Button okButton = new Button(composite_7, SWT.NONE);
		okButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent e) {
				conf.setBooleanValue("dosbox", "hideconsole", console.getSelection());
				conf.setBooleanValue("communication", "port_enabled", portEnabled.getSelection());
				conf.setValue("communication", "port", port.getText());
				conf.setIntValue("profiledefaults", "confpath", confLocation.getSelectionIndex());
				conf.setIntValue("profiledefaults", "conffile", confFilename.getSelectionIndex());
				storeValues();
				Settings settings = Settings.getInstance();
				settings.updateWithValuesFrom(conf);
				shell.close();
			}
		});
		shell.setDefaultButton(okButton);
		final RowData rowData = new RowData();
		rowData.width = 80;
		okButton.setLayoutData(rowData);
		okButton.setText("OK");

		final Button cancelButton = new Button(composite_7, SWT.NONE);
		final RowData rowData_1 = new RowData();
		rowData_1.width = 80;
		cancelButton.setLayoutData(rowData_1);
		cancelButton.setText("Cancel");
		cancelButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        shell.close();
      }
    });
	}
	
	private void storeValues() {
		if (previousSelection != -1)
			conf.setMultilineValues("profile", options.getItem(previousSelection), values.getText(), values.getLineDelimiter());
	}
}
