/* 
 * Created on Jul 23, 2006 by ronald.blankendaal
 * 
 * @file $RCSfile: StringUtils.java,v $
 * @version $Revision: 1.9 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/10/08 19:04:28 $ (UTC date of last check in)
 */

package com.util;

import java.io.File;
import java.util.List;


public abstract class StringUtils {

  public static String fixDir(String input) {
    if (input.equals("") || input.equals(File.separatorChar))
      return "";
    StringBuffer result = new StringBuffer(input);
    if (!input.startsWith(File.separator) && 
    		(input.length() < 2 || input.charAt(1) != ':'))
      result.insert(0, File.separatorChar);
    if (input.endsWith(File.separator))
      result.deleteCharAt(result.length() - 1);
    return result.toString();
  }
  
  public static String listToString(List<String> list) {
    StringBuffer result = new StringBuffer();
    for (String line: list)
      result.append(line + "\n");
    return result.toString();
  }
  
  public static String intArrayToString(int[] list) {
	  StringBuffer result = new StringBuffer();
	  for (int value: list)
		  result.append(value + " ");
	  return result.toString();
  }
  
  public static String StringArrayToString(String[] list) {
	  StringBuffer result = new StringBuffer();
	  for (String value: list)
		  result.append(value + "\n");
	  return result.toString();
  }
  
  public static int[] stringToIntArray(String input) {
	  String[] values = input.split(" ");
	  int[] result = new int[values.length];
	  for (int i = 0; i < values.length; i++)
		  try {
			  result[i] = Integer.parseInt(values[i]);
		  } catch (NumberFormatException e) {
			  result[i] = -1;
		  }
	  return result;
  }
}
