/* 
 * Created on 28-jun-2006 by ronald.blankendaal
 * 
 * @file $RCSfile: MainWindow.java,v $
 * @version $Revision: 1.52 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/11/19 21:40:17 $ (UTC date of last check in)
 */

package com.gui;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import swing2swt.layout.BorderLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import com.connect.Messaging;
import com.db.Database;
import com.model.DosboxVersion;
import com.model.Profile;
import com.model.Settings;
import com.model.Template;
import com.swtdesigner.SWTResourceManager;
import com.util.FileUtils;
import com.util.ListUtils;
import com.util.PlatformUtils;


public class MainWindow {

	public static final String PROGRAM_NAME = "DOSBox Game Launcher v0.52";
  private static final int THUMB_HEIGHT = 100;
  
  private Display display;
  protected Shell shell;
  private java.util.List<Profile> profilesList;
  private java.util.List<DosboxVersion> dbversionsList;
  private java.util.List<Template> templatesList;
  private Database db = null;
  private Settings settings = null;
  private String currentThumbFile = null;
  
  private Table template_table;
  private Table dosboxversion_table;
  private Table profile_table;
  private Text notesField;
  private ToolBar thumbsToolBar;
  private Link link1;
  private Link link2;
  
  /**
   * Launch the application
   * @param args
   */
  public static void main(String[] args) {
    try {
      MainWindow window = new MainWindow();
      window.open();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * Open the window
   */
  public void open() {
    db = Database.getInstance();
    settings = Settings.getInstance();

    display = Display.getDefault();
    createContents();
    
    Messaging mess = null;
    if (settings.getBooleanValue("communication", "port_enabled")) {
    	mess = new Messaging(settings.getIntValue("communication", "port"), this);
    	mess.start();
    }
    
    shell.open();
    shell.layout();
    while (!shell.isDisposed()) {
      if (!display.readAndDispatch())
        display.sleep();
    }
    SWTResourceManager.dispose();
    display.dispose();

    if (mess != null)
    	mess.close();

    try {
			settings.save();
		} catch (IOException e) {
			GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
		}
    try { db.shutdown(); } catch (SQLException e) {}
  }
  
  /**
   * Create contents of the window
   */
  protected void createContents() {
  	shell = new Shell();
    try {
			profilesList = db.readProfilesList(settings.getIntValue("gui", "sortcolumn"),
					settings.getBooleanValue("gui", "sortascending"));
			dbversionsList = db.readDosboxVersionsList();
			templatesList = db.readTemplatesList();
    } catch (SQLException e) {
    	GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
		}
    shell.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		boolean isMaximized = shell.getMaximized();
    		if (!isMaximized) {
    			Rectangle rec = shell.getBounds();
        		settings.setIntValue("gui", "width", rec.width);
        		settings.setIntValue("gui", "height", rec.height);
        		settings.setIntValue("gui", "x", rec.x);
        		settings.setIntValue("gui", "y", rec.y);
    		}
    		settings.setBooleanValue("gui", "maximized", isMaximized);
    	} });
    shell.addControlListener(new ControlAdapter() {
    	public void controlMoved(final ControlEvent e) {
    		if (!shell.getMaximized()) {
    			Rectangle rec = shell.getBounds();
    			settings.setIntValue("gui", "x", rec.x);
    			settings.setIntValue("gui", "y", rec.y);
    		}
    	} });
    shell.setLayout(new BorderLayout(0, 0));
    shell.setMaximized(settings.getBooleanValue("gui", "maximized"));
    shell.setLocation(settings.getIntValue("gui", "x"), settings.getIntValue("gui", "y"));
    shell.setSize(settings.getIntValue("gui", "width"), settings.getIntValue("gui", "height"));
    shell.setText(PROGRAM_NAME);

    final Menu menu = new Menu(shell, SWT.BAR);
    shell.setMenuBar(menu);

    final MenuItem fileMenuItem = new MenuItem(menu, SWT.CASCADE);
    fileMenuItem.setText("File");

    final Menu menu_1 = new Menu(fileMenuItem);
    fileMenuItem.setMenu(menu_1);

    if (PlatformUtils.IS_WINDOWS) {
	    final MenuItem dfendImportMenuItem = new MenuItem(menu_1, SWT.NONE);
	    dfendImportMenuItem.addSelectionListener(new SelectionAdapter() {
	      public void widgetSelected(final SelectionEvent e) {
	        doDFendImport();
	      }
	    });
	    dfendImportMenuItem.setText("Import D-Fend Profiles");
	
	    new MenuItem(menu_1, SWT.SEPARATOR);
    }
    
    final MenuItem confImportMenuItem = new MenuItem(menu_1, SWT.NONE);
    confImportMenuItem.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doImportConfigfile();
      }
    });
    confImportMenuItem.setText("Import Profile");
    new MenuItem(menu_1, SWT.SEPARATOR);
    
    final MenuItem settingsMenuItem = new MenuItem(menu_1, SWT.NONE);
    settingsMenuItem.setText("Adjust Settings");
    settingsMenuItem.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doOpenSettingsDialog();
      }
    });

    final MenuItem exitMenuItem = new MenuItem(menu_1, SWT.NONE);
    exitMenuItem.setText("Exit");
    exitMenuItem.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        shell.close();
      }
    });
    
    final TabFolder tabFolder = new TabFolder(shell, SWT.NONE);

    final TabItem profilesTabItem = new TabItem(tabFolder, SWT.NONE);
    profilesTabItem.setText("Profiles");

    final Composite composite = new Composite(tabFolder, SWT.NONE);
    composite.setLayout(new BorderLayout(0, 0));
    profilesTabItem.setControl(composite);
    
    final ToolBar toolBar = new ToolBar(composite, SWT.NONE);
    toolBar.setLayoutData(BorderLayout.NORTH);

    final ToolItem newItemToolItem = new ToolItem(toolBar, SWT.PUSH);
    newItemToolItem.setText("Add profile");
    newItemToolItem.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doAddProfile();
      }
    });
    
    final ToolItem newItemToolItem_2 = new ToolItem(toolBar, SWT.PUSH);
    newItemToolItem_2.setText("Edit Profile");
    newItemToolItem_2.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doEditProfile();
      }
    });
    
    final ToolItem newItemToolItem_1 = new ToolItem(toolBar, SWT.PUSH);
    newItemToolItem_1.setText("Remove profile");
    newItemToolItem_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doRemoveProfile();
      }
    });

    final SashForm sashForm = new SashForm(composite, SWT.NONE);
    
    profile_table = new Table(sashForm, SWT.FULL_SELECTION | SWT.BORDER);
    
    final Composite informationGroup = new Composite(sashForm, SWT.NONE);
    informationGroup.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		settings.setIntValues("gui", "sashweights", sashForm.getWeights());
    	}
    });
    informationGroup.setLayout(new BorderLayout(0, 0));
    notesField = new Text(informationGroup, SWT.V_SCROLL | SWT.MULTI | SWT.READ_ONLY | SWT.BORDER | SWT.WRAP);

    final Composite composite_2 = new Composite(informationGroup, SWT.NONE);
    composite_2.setLayout(new BorderLayout(0, 0));
    composite_2.setLayoutData(BorderLayout.SOUTH);

    link1 = new Link(composite_2, SWT.NONE);
    link1.setLayoutData(BorderLayout.NORTH);
    link1.setText(" ");
    link1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        PlatformUtils.openForBrowsing(e.text);
      }
    });
    
    link2 = new Link(composite_2, SWT.NONE);
    link2.setText(" ");
    link2.setLayoutData(BorderLayout.SOUTH);
    link2.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
      	PlatformUtils.openForBrowsing(e.text);
      }
    });
    
    final ScrolledComposite scrolledComposite = new ScrolledComposite(composite, SWT.BORDER | SWT.H_SCROLL);
    scrolledComposite.setMinHeight(THUMB_HEIGHT + 20);
    scrolledComposite.setLayoutData(BorderLayout.SOUTH);

    thumbsToolBar = new ToolBar(scrolledComposite, SWT.NONE);
    thumbsToolBar.addMouseListener(new MouseAdapter() {
    	public void mouseDown(final MouseEvent e) {
    		currentThumbFile = thumbsToolBar.getItem(new Point(e.x, e.y)).getToolTipText();
    	}
    });
    scrolledComposite.setContent(thumbsToolBar);
    
    final Menu menu_thumb = new Menu(thumbsToolBar);
    thumbsToolBar.setMenu(menu_thumb);

    final MenuItem thumbMenuItem = new MenuItem(menu_thumb, SWT.NONE);
    thumbMenuItem.setText("Remove");
    thumbMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doRemoveThumb();
    	}
    });
    
    profile_table.addKeyListener(new KeyAdapter() {
    	public void keyPressed(final KeyEvent e) {
    		if (e.keyCode == SWT.DEL) {
        	doRemoveProfile();
        } else if (e.keyCode == SWT.INSERT) {
        	doAddProfile();
        } else if (e.keyCode == SWT.F2) {
        	doEditProfile(true);
        } else if (e.stateMask == SWT.CTRL && (Character.toLowerCase(e.keyCode) == 'm')) {
        	doToggleFavoriteProfile();
        }
    	}
    });

    profile_table.setLayoutData(BorderLayout.WEST);
    profile_table.addTraverseListener(new TraverseListener() {
      public void keyTraversed(final TraverseEvent e) {
        if ((e.stateMask == SWT.CTRL) && (e.detail == SWT.TRAVERSE_RETURN)) {
          doEditProfile();
        } else if ((e.stateMask == SWT.SHIFT) && (e.detail == SWT.TRAVERSE_RETURN)) {
          doRunProfile(true);
        } else if (e.detail == SWT.TRAVERSE_RETURN) {
          doRunProfile(false);
        } 
      }
    });
    profile_table.addMouseListener(new MouseAdapter() {
      public void mouseDoubleClick(final MouseEvent e) {
        doRunProfile(false);
      }
    });

    profile_table.setLinesVisible(true);
    profile_table.setHeaderVisible(true);
    
    addProfileColumn("Title", 0);
    addProfileColumn("Setup", 1);
    addProfileColumn("Developer", 2);
    addProfileColumn("Publisher", 3);
    addProfileColumn("Genre", 4);
    addProfileColumn("Year", 5);
    addProfileColumn("Status", 6);
    addProfileColumn("Favorite", 7);
    addProfileColumn("ID", 8);
    
    profile_table.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        displayProfileInformation();
      } });

    final Menu menu_2 = new Menu(profile_table);
    profile_table.setMenu(menu_2);

    final MenuItem runMenuItem = new MenuItem(menu_2, SWT.NONE);
    runMenuItem.setText("Run");
    runMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doRunProfile(false);
    	}
    });

    final MenuItem setupMenuItem = new MenuItem(menu_2, SWT.NONE);
    setupMenuItem.setText("Setup");
    setupMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doRunProfile(true);
    	}
    });

    new MenuItem(menu_2, SWT.SEPARATOR);

    final MenuItem addMenuItem = new MenuItem(menu_2, SWT.NONE);
    addMenuItem.setText("Add");
    addMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doAddProfile();
    	}
    });
    
    final MenuItem editMenuItem = new MenuItem(menu_2, SWT.NONE);
    editMenuItem.setText("Edit");
    editMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doEditProfile();
    	}
    });

    final MenuItem removeMenuItem = new MenuItem(menu_2, SWT.NONE);
    removeMenuItem.setText("Remove");
    removeMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doRemoveProfile();
    	}
    });
    
    new MenuItem(menu_2, SWT.SEPARATOR);
    
    final MenuItem toggleMenuItem = new MenuItem(menu_2, SWT.NONE);
    toggleMenuItem.setText("Toggle favorite");
    toggleMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doToggleFavoriteProfile();
    	}
    });
    
    if (PlatformUtils.IS_WINDOWS) {
  	  new MenuItem(menu_2, SWT.SEPARATOR);
	    final MenuItem shortcutMenuItem = new MenuItem(menu_2, SWT.NONE);
	    shortcutMenuItem.setText("Create shortcut");
	    shortcutMenuItem.addSelectionListener(new SelectionAdapter() {
	    	public void widgetSelected(final SelectionEvent e) {
	    		doCreateShortcut();
	    	}
	    });
    }
    
    menu_2.addMenuListener(new MenuAdapter() {
    	public void menuShown(final MenuEvent e) {
    		if (profile_table.getSelectionIndex() != -1)
    			setupMenuItem.setEnabled(profilesList.get(profile_table.getSelectionIndex()).hasSetupBoolean());
    	}
    });
    
    sashForm.setWeights(settings.getIntValues("gui", "sashweights"));
    
    final TabItem dosboxTabItem = new TabItem(tabFolder, SWT.NONE);
    dosboxTabItem.setText("DOSBox versions");

    final Composite composite_1 = new Composite(tabFolder, SWT.NONE);
    composite_1.setLayout(new BorderLayout(0, 0));
    dosboxTabItem.setControl(composite_1);
    
    final ToolBar toolBar_1 = new ToolBar(composite_1, SWT.NONE);
    toolBar_1.setLayoutData(BorderLayout.NORTH);

    final ToolItem newItemToolItem_3 = new ToolItem(toolBar_1, SWT.PUSH);
    newItemToolItem_3.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doAddDosboxVersion();
      }
    });
    newItemToolItem_3.setText("Add version");

    final ToolItem newItemToolItem_2_1 = new ToolItem(toolBar_1, SWT.PUSH);
    newItemToolItem_2_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doEditDosboxVersion();
      }
    });
    newItemToolItem_2_1.setText("Edit version");

    final ToolItem newItemToolItem_1_1 = new ToolItem(toolBar_1, SWT.PUSH);
    newItemToolItem_1_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doRemoveDosboxVersion();
      }
    });
    newItemToolItem_1_1.setText("Remove version");

    dosboxversion_table = new Table(composite_1, SWT.FULL_SELECTION | SWT.BORDER);
    dosboxversion_table.addKeyListener(new KeyAdapter() {
    	public void keyPressed(final KeyEvent e) {
    		if (e.keyCode == SWT.DEL) {
        	doRemoveDosboxVersion();
        } else if (e.keyCode == SWT.INSERT) {
        	doAddDosboxVersion();
        } else if (e.stateMask == SWT.CTRL && (Character.toLowerCase(e.keyCode) == 'm')) {
        	doToggleDefaultVersion();
        }
    	}
    });
    dosboxversion_table.addTraverseListener(new TraverseListener() {
      public void keyTraversed(final TraverseEvent e) {
        if (e.detail == SWT.TRAVERSE_RETURN)
          doRunDosbox();
      }
    });
    dosboxversion_table.addMouseListener(new MouseAdapter() {
      public void mouseDoubleClick(final MouseEvent e) {
        doRunDosbox();
      }
    });
    
    dosboxversion_table.setLinesVisible(true);
    dosboxversion_table.setHeaderVisible(true);

    addDBColumn("Title", 0);
    addDBColumn("Path", 1);
    addDBColumn("Default", 2);
    
    final Menu menu_4 = new Menu(dosboxversion_table);
    dosboxversion_table.setMenu(menu_4);

    final MenuItem runDBMenuItem = new MenuItem(menu_4, SWT.NONE);
    runDBMenuItem.setText("Run");
    runDBMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doRunDosbox();
    	}
    });

    new MenuItem(menu_4, SWT.SEPARATOR);

    final MenuItem addDBMenuItem = new MenuItem(menu_4, SWT.NONE);
    addDBMenuItem.setText("Add");
    addDBMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doAddDosboxVersion();
    	}
    });
    
    final MenuItem editDBMenuItem = new MenuItem(menu_4, SWT.NONE);
    editDBMenuItem.setText("Edit");
    editDBMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doEditDosboxVersion();
    	}
    });

    final MenuItem removeDBMenuItem = new MenuItem(menu_4, SWT.NONE);
    removeDBMenuItem.setText("Remove");
    removeDBMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doRemoveDosboxVersion();
    	}
    });
    
    new MenuItem(menu_4, SWT.SEPARATOR);
    
    final MenuItem toggleDefaultMenuItem = new MenuItem(menu_4, SWT.NONE);
    toggleDefaultMenuItem.setText("Toggle default");
    toggleDefaultMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doToggleDefaultVersion();
    	}
    });
    
    final TabItem templatesTabItem = new TabItem(tabFolder, SWT.NONE);
    templatesTabItem.setText("Templates");

    final Composite composite_1_1 = new Composite(tabFolder, SWT.NONE);
    composite_1_1.setLayout(new BorderLayout(0, 0));
    templatesTabItem.setControl(composite_1_1);
    
    final ToolBar toolBar_1_1 = new ToolBar(composite_1_1, SWT.NONE);
    toolBar_1_1.setLayoutData(BorderLayout.NORTH);

    final ToolItem newItemToolItem_3_1 = new ToolItem(toolBar_1_1, SWT.PUSH);
    newItemToolItem_3_1.setText("Add template");
    newItemToolItem_3_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doAddTemplate();
      }
    });

    final ToolItem newItemToolItem_2_1_1 = new ToolItem(toolBar_1_1, SWT.PUSH);
    newItemToolItem_2_1_1.setText("Edit template");
    newItemToolItem_2_1_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doEditTemplate();
      }
    });

    final ToolItem newItemToolItem_1_1_1 = new ToolItem(toolBar_1_1, SWT.PUSH);
    newItemToolItem_1_1_1.setText("Remove template");
    newItemToolItem_1_1_1.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        doRemoveTemplate();
      }
    });

    template_table = new Table(composite_1_1, SWT.FULL_SELECTION | SWT.BORDER);
    template_table.addKeyListener(new KeyAdapter() {
    	public void keyPressed(final KeyEvent e) {
    		if (e.keyCode == SWT.DEL) {
        	doRemoveTemplate();
        } else if (e.keyCode == SWT.INSERT) {
        	doAddTemplate();
        } else if (e.stateMask == SWT.CTRL && (Character.toLowerCase(e.keyCode) == 'm')) {
        	doToggleDefaultTemplate();
        }
    	}
    });
    
    template_table.setLinesVisible(true);
    template_table.setHeaderVisible(true);
    
    addTemplateColumn("Title", 0);
    addTemplateColumn("Default", 1);
    
    final Menu menu_3 = new Menu(template_table);
    template_table.setMenu(menu_3);

    final MenuItem addTemplateMenuItem = new MenuItem(menu_3, SWT.NONE);
    addTemplateMenuItem.setText("Add");
    addTemplateMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doAddTemplate();
    	}
    });
    
    final MenuItem editTemplateMenuItem = new MenuItem(menu_3, SWT.NONE);
    editTemplateMenuItem.setText("Edit");
    editTemplateMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doEditTemplate();
    	}
    });

    final MenuItem removeTemplateMenuItem = new MenuItem(menu_3, SWT.NONE);
    removeTemplateMenuItem.setText("Remove");
    removeTemplateMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doRemoveTemplate();
    	}
    });
    
    new MenuItem(menu_3, SWT.SEPARATOR);
    
    final MenuItem toggleTemplateMenuItem = new MenuItem(menu_3, SWT.NONE);
    toggleTemplateMenuItem.setText("Toggle default");
    toggleTemplateMenuItem.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doToggleDefaultTemplate();
    	}
    });
    
    // init values
    for (Profile prof: profilesList) addProfileToTable(prof);
    for (DosboxVersion dbversion: dbversionsList) addDosboxVersionToTable(dbversion);
    for (Template template: templatesList) addTemplateToTable(template);
    
    profile_table.setSortColumn(profile_table.getColumn(settings.getIntValue("gui", "sortcolumn")));
    profile_table.setSortDirection(settings.getBooleanValue("gui", "sortascending")? SWT.UP: SWT.DOWN);
    profile_table.setColumnOrder(settings.getIntValues("gui", "columnorder"));
  }
  
  private void doReorderProfiles(int columnId, SelectionEvent e) {
	  TableColumn sortColumn = profile_table.getSortColumn();
	  TableColumn currentColumn = (TableColumn) e.widget;
	  int dir = profile_table.getSortDirection();
	  if (sortColumn == currentColumn) {
		  dir = dir == SWT.UP ? SWT.DOWN : SWT.UP;
	  } else {
		  profile_table.setSortColumn(currentColumn);
		  dir = SWT.UP;
	  }
	  int currentProfileId = -1;
	  if (profile_table.getSelectionIndex() != -1)
		  currentProfileId = profilesList.get(profile_table.getSelectionIndex()).getId();
	  try {
			profilesList = db.readProfilesList(columnId, dir == SWT.UP);
		} catch (SQLException ex) {
			GeneralPurposeDialogs.warningMessage(shell, ex.getMessage());
		}
	  for (int i = 0; i < profilesList.size(); i++)
		  setTableItem(profile_table.getItem(i), profilesList.get(i));
	  profile_table.setSortDirection(dir);
	  if (currentProfileId != -1) {
		  profile_table.setSelection(ListUtils.findTIProfile(profilesList, currentProfileId));
		  profile_table.showSelection();
	  }
	  settings.setIntValue("gui", "sortcolumn", columnId);
	  settings.setBooleanValue("gui", "sortascending", dir == SWT.UP);
  }
  
  private void displayNotes(String notes) {
    notesField.setText(notes);
  }
  
  private void displayLinks(String p_link1, String p_link2) {
    if (p_link1 != null && !p_link1.equals(""))
      link1.setText("<a href=\"" + p_link1 + "\">" + p_link1 + "</a>");
    else
      link1.setText(" ");
    
    if (p_link2 != null && !p_link2.equals(""))
      link2.setText("<a href=\"" + p_link2 + "\">" + p_link2 + "</a>");
    else
      link2.setText(" ");
  }
  
  private void displayScreenshots(Profile prof) {
    ToolItem[] toolItems = thumbsToolBar.getItems();
    for (int i = 0; i < toolItems.length; i++)
      toolItems[i].dispose();
    if (prof != null) {
	    File path = new File(prof.getCaptures());
	    String[] files = path.list();
	    if (files != null) {
	      for (int i = 0; i < files.length; i++) {
	        if (files[i].toLowerCase().endsWith(".png")) {
	        	String file = prof.getCaptures() + File.separatorChar + files[i];
	          Image thumb = SWTResourceManager.getImage(file);
	          ImageData smallThumb = thumb.getImageData();
	          int width = smallThumb.width;
	          int height = smallThumb.height;
	          double factor = (double)THUMB_HEIGHT / (double)height;
	          smallThumb = smallThumb.scaledTo((int)(width * factor), (int)(height * factor));
	          final ToolItem toolItem = new ToolItem(thumbsToolBar, SWT.PUSH);
	          toolItem.setToolTipText(file);
	          toolItem.setText(files[i]);
	          toolItem.setImage(new Image(display, smallThumb));
	          toolItem.addSelectionListener(new SelectionAdapter() {
	            public void widgetSelected(final SelectionEvent e) {
	              final Thumb thumbDialog = new Thumb(shell);
	              thumbDialog.setThumb(toolItem.getToolTipText());
	              thumbDialog.open();
	            }
	          });
	          toolItem.addDisposeListener(new DisposeListener() {
	            public void widgetDisposed(DisposeEvent e) {
	              toolItem.getImage().dispose();
	            }
	          });
	        }
	      }
	    }
    }
    thumbsToolBar.setVisible(thumbsToolBar.getItemCount() != 0);
    thumbsToolBar.pack();
  }
  
  private void doAddProfile() {
    doAddProfile(null);
  }
  
  private void doAddProfile(String file) {
    if (checkDefaultDBVersion() == null)
      return;
    final EditProfileDialog addProfileDialog = new EditProfileDialog(shell);
    if (file != null)
    	addProfileDialog.sendToProfile(file);
    Profile profile = (Profile)addProfileDialog.open();
    if (profile != null) {
      profilesList.add(profile);
      addProfileToTable(profile);
      profile_table.setSelection(profile_table.getItemCount() - 1);
      profile_table.showSelection();
      profile_table.setFocus();
      displayProfileInformation();
    }
  }
  
  public void addProfile(final String file) {
  	display.syncExec(new Runnable() {
  		public void run() {
  			doAddProfile(file);
  		}
    });
  }
  
  private void doAddDosboxVersion() {
    final EditDosboxVersionDialog addDosboxVersionDialog = new EditDosboxVersionDialog(shell);
    DosboxVersion dbversion = (DosboxVersion)addDosboxVersionDialog.open();
    if (dbversion != null)
    	updateDosboxVersionList(dbversion);
  }
  
  private void doAddTemplate() {
  	if (checkDefaultDBVersion() == null)
      return;
    final EditTemplateDialog addTemplateDialog = new EditTemplateDialog(shell);
    Template template = (Template)addTemplateDialog.open();
    if (template != null)
    	updateTemplateList(template);
  }
  
  private void doToggleFavoriteProfile() {
    int index = profile_table.getSelectionIndex();
    if (index != -1) {
    	Profile profile = profilesList.get(index);
    	try {
				db.toggleFavorite(profile.getId());
			} catch (SQLException e) {
				GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
			}
    	profile.toggleFavorite();
    	profilesList.set(index, profile);
    	setTableItem(profile_table.getItem(index), profile);
    }
  }
  
  private void doToggleDefaultVersion() {
  	int index = dosboxversion_table.getSelectionIndex();
    if (index != -1) {
    	DosboxVersion ver = dbversionsList.get(index);
    	ver.toggleDefault();
    	try {
				db.addOrEditDosboxVersion(ver.getTitle(), ver.getPath(), ver.isMultiConfig(), 
						ver.isDefaultVersion(), ver.getParameters(), ver.getId());
			} catch (SQLException e) {
				GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
			}
    	updateDosboxVersionList(ver);
    }
  }
  
  private void doToggleDefaultTemplate() {
  	int index = template_table.getSelectionIndex();
    if (index != -1) {
    	Template temp = templatesList.get(index);
    	temp.toggleDefault();
    	try {
				db.addOrEditTemplate(temp.getTitle(), temp.getdbversionId(), temp.isDefault(), temp.getId());
			} catch (SQLException e) {
				GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
			}
    	updateTemplateList(temp);
    }
  }
  
  private void doEditProfile() {
  	doEditProfile(false);
  }
  
  private void doEditProfile(boolean focusTitle) {
    int index = profile_table.getSelectionIndex();
    if (index != -1) {
      final EditProfileDialog editProfileDialog = new EditProfileDialog(shell);
      editProfileDialog.setProfile(profilesList.get(index));
      if (focusTitle)
      	editProfileDialog.focusTitle();
      Profile profile = (Profile)editProfileDialog.open();
      if (profile != null) {
        profilesList.set(index, profile);
        setTableItem(profile_table.getItem(index), profile);
        displayProfileInformation();
      }
    }
  }
  
  private void doEditDosboxVersion() {
    int index = dosboxversion_table.getSelectionIndex();
    if (index != -1) {
      final EditDosboxVersionDialog editDosboxVersionDialog = new EditDosboxVersionDialog(shell);
      editDosboxVersionDialog.setDosboxVersion(dbversionsList.get(index));
      DosboxVersion dbversion = (DosboxVersion)editDosboxVersionDialog.open();
      if (dbversion != null)
      	updateDosboxVersionList(dbversion);
    }
  }
  
  private void updateDosboxVersionList(DosboxVersion dbversion) {
  	try {
			dbversionsList = db.readDosboxVersionsList();
		} catch (SQLException e) {
			GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
		}
    dosboxversion_table.removeAll();
    for (DosboxVersion version: dbversionsList) addDosboxVersionToTable(version);
    dosboxversion_table.setSelection(ListUtils.findTIDosboxVersion(dbversionsList, dbversion.getId()));
	  dosboxversion_table.showSelection();
	  dosboxversion_table.setFocus();
  }
  
  private void updateTemplateList(Template template) {
  	try {
			templatesList = db.readTemplatesList();
		} catch (SQLException e) {
			GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
		}
    template_table.removeAll();
    for (Template temp: templatesList) addTemplateToTable(temp);
    template_table.setSelection(ListUtils.findTITemplate(templatesList, template.getId()));
	  template_table.showSelection();
	  template_table.setFocus();
  }
  
  private void doEditTemplate() {
    int index = template_table.getSelectionIndex();
    if (index != -1) {
      final EditTemplateDialog editTemplateDialog = new EditTemplateDialog(shell);
      editTemplateDialog.setTemplate(templatesList.get(index));
      Template template = (Template)editTemplateDialog.open();
      if (template != null)
      	updateTemplateList(template);
    }
  }
  
  private void doRemoveProfile() {
    int index = profile_table.getSelectionIndex();
    if (index != -1) {
      if (GeneralPurposeDialogs.confirmMessage(shell, "Do you want to remove the selected profile?")) {
        Profile prof = profilesList.get(index);
        try {
					db.removeProfile(prof.getId());
					profile_table.remove(index);
	        profilesList.remove(index);
	        displayProfileInformation();
	        SWTResourceManager.disposeImages();
	        if (GeneralPurposeDialogs.confirmMessage(shell,
	        		"Do you also want to remove the associated conf file " + prof.getConfPathAndFile() + " ?")) {
	          FileUtils.removeFile(prof.getConfPathAndFile());
	        }
	        if (GeneralPurposeDialogs.confirmMessage(shell,
	        		"Do you also want to remove the associated captures directory " + prof.getCaptures() +
	        		" including its files?")) {
	        	FileUtils.removeFilesInDirAndDir(prof.getCaptures());
	        }
				} catch (SQLException e) {
					GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
				}
      }
    }
  }

  private void doRemoveDosboxVersion() {
    int index = dosboxversion_table.getSelectionIndex();
    if (index != -1) {
      if (GeneralPurposeDialogs.confirmMessage(shell, "Do you want to remove the selected DOSBox version?")) {
        try {
					db.removeDosboxVersion((dbversionsList.get(index)).getId());
					dosboxversion_table.remove(index);
	        dbversionsList.remove(index);
				} catch (SQLException e) {
					GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
				}
      }
    }
  }
  
  private void doRemoveTemplate() {
    int index = template_table.getSelectionIndex();
    if (index != -1) {
      if (GeneralPurposeDialogs.confirmMessage(shell, "Do you want to remove the selected template?")) {
        int templateId = (templatesList.get(index)).getId();
        try {
					db.removeTemplate(templateId);
					template_table.remove(index);
	        templatesList.remove(index);
	        String conffile = FileUtils.constructTemplateFileLocation(templateId);
	        if (GeneralPurposeDialogs.confirmMessage(shell,
	        		"Do you also want to remove the associated conf file " + conffile + " ?")) {
	        	FileUtils.removeFile(conffile);
	        }
				} catch (SQLException e) {
					GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
				}
      }
    }
  }
  
  private void addProfileToTable(Profile prof) {
    final TableItem newItemTableItem = new TableItem(profile_table, SWT.BORDER); 
    setTableItem(newItemTableItem, prof);
  }
  
  private void addDosboxVersionToTable(DosboxVersion dbversion) {
    final TableItem newItemTableItem = new TableItem(dosboxversion_table, SWT.BORDER); 
    setTableItem(newItemTableItem, dbversion);
  }
  
  private void addTemplateToTable(Template template) {
    final TableItem newItemTableItem = new TableItem(template_table, SWT.BORDER); 
    setTableItem(newItemTableItem, template);
  }
  
  private void setTableItem(TableItem newItemTableItem, Profile prof) {
    newItemTableItem.setText(0, prof.getTitle());
    newItemTableItem.setText(1, prof.hasSetup());
    newItemTableItem.setText(2, prof.getDeveloperName());
    newItemTableItem.setText(3, prof.getPublisherName());
    newItemTableItem.setText(4, prof.getGenre());
    newItemTableItem.setText(5, prof.getYear());
    newItemTableItem.setText(6, prof.getStatus());
    newItemTableItem.setText(7, prof.isFavoriteString()); 
    newItemTableItem.setText(8, String.valueOf(prof.getId()));
  }
  
  private void setTableItem(TableItem newItemTableItem, DosboxVersion dbversion) {
    newItemTableItem.setText(0, dbversion.getTitle());
    newItemTableItem.setText(1, dbversion.getPath());
    newItemTableItem.setText(2, dbversion.isDefaultVersionString());
  }
  
  private void setTableItem(TableItem newItemTableItem, Template template) {
    newItemTableItem.setText(0, template.getTitle());
    newItemTableItem.setText(1, template.isDefaultString());
  }
  
  private void doRunProfile(boolean setup) {
    int index = profile_table.getSelectionIndex();
    if (index != -1) {
    	Profile prof = profilesList.get(index);
    	if (!setup || prof.hasSetupBoolean())
				try {
					FileUtils.doRunProfile(prof, dbversionsList, setup);
				} catch (IOException e) {
					GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
				}
    }
  }
  
  private void doRunDosbox() {
    int index = dosboxversion_table.getSelectionIndex();
    if (index != -1)
			try {
				FileUtils.doRunDosbox(dbversionsList.get(index));
			} catch (IOException e) {
				GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
			}
  }
  
  private DosboxVersion checkDefaultDBVersion() {
  	int defaultDosboxVersionIndex = ListUtils.findTIDefaultDosboxVersion(dbversionsList);
    if (defaultDosboxVersionIndex == -1) {
      GeneralPurposeDialogs.infoMessage(shell, "You must first define a default DOSBox version!");
      return null;
    }
    return dbversionsList.get(defaultDosboxVersionIndex);
  }
  
  private void doDFendImport() {
  	DosboxVersion defaultDosboxVersion = checkDefaultDBVersion();
    if (defaultDosboxVersion == null)
      return;
    
    if (settings.getIntValue("profiledefaults", "confpath") == 1)
    	GeneralPurposeDialogs.infoMessage(shell, "Please realize that you have currently configured " +
    			"DBGL to store profile configuration files in the game directory. " +
    			"Therefore, if you continue and perform the import, all configuration files are " +
    			"saved to the various game directories configured in D-Fend.\n\n" +
    			"If you'd rather have those DOSBox config files stored in a central place, please open " +
    			"the Settings dialog first and change the default configuration-file location to '" +
    			SettingsDialog.confLocations[0] + "'!");

    DFendImportDialog importDialog = new DFendImportDialog(shell);
    importDialog.setDefaultDosboxVersion(defaultDosboxVersion);
    if (importDialog.open() != null) {
    	try {
				profilesList = db.readProfilesList(settings.getIntValue("gui", "sortcolumn"),
						settings.getBooleanValue("gui", "sortascending"));
				profile_table.removeAll();
	      for (Profile prof: profilesList) addProfileToTable(prof);
			} catch (SQLException e) {
				GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
			}
    }
  }
  
  private void displayProfileInformation() {
    int index = profile_table.getSelectionIndex();
    if (index != -1) {
      Profile prof = profilesList.get(index);
      displayScreenshots(prof);
      displayNotes(prof.getNotes());
      displayLinks(prof.getLink1(), prof.getLink2());
    } else {
      displayScreenshots(null);
      displayNotes("");
      displayLinks("", "");
    }
  }
  
  private void doRemoveThumb() {
  	if (GeneralPurposeDialogs.confirmMessage(shell, "Would you like to remove the selected " +
  			"screenshot \"" + currentThumbFile + "\"?")) {
  		FileUtils.removeFile(currentThumbFile);
  		displayProfileInformation();
  	}
  	currentThumbFile = null;
  }
  
  private void doCreateShortcut() {
  	int index = profile_table.getSelectionIndex();
    if (index != -1)
      PlatformUtils.createShortcut(profilesList.get(index), dbversionsList);
  }
  
  private void addProfileColumn(String title, final int nr) {
  	final String width = "column" + (nr + 1) + "width";
  	final TableColumn column = new TableColumn(profile_table, SWT.NONE);
  	column.setMoveable(true);
  	column.setWidth(settings.getIntValue("gui", width));
  	column.setText(title);
  	column.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		doReorderProfiles(nr, e);
    	}
    });
  	column.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		settings.setIntValue("gui", width, column.getWidth());
    	}
    	public void controlMoved(final ControlEvent e) {
    		settings.setIntValues("gui", "columnorder", profile_table.getColumnOrder());
    	}
    });
  }
  
  private void addDBColumn(String title, final int nr) {
  	final String width = "column2_" + (nr + 1) + "width";
  	final TableColumn column = new TableColumn(dosboxversion_table, SWT.NONE);
    column.setWidth(settings.getIntValue("gui", width));
    column.setText(title);
    column.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		settings.setIntValue("gui", width, column.getWidth());
    	}
    });
  }
  
  private void addTemplateColumn(String title, final int nr) {
  	final String width = "column3_" + (nr + 1) + "width";
  	final TableColumn column = new TableColumn(template_table, SWT.NONE);
    column.setWidth(settings.getIntValue("gui", width));
    column.setText(title);
    column.addControlListener(new ControlAdapter() {
    	public void controlResized(final ControlEvent e) {
    		settings.setIntValue("gui", width, column.getWidth());
    	}
    });
  }
  
  private void doOpenSettingsDialog() {
  	SettingsDialog s = new SettingsDialog(shell);
  	s.open();
  }
  
  private void doImportConfigfile() {
  	FileDialog dialog = new FileDialog (shell, SWT.OPEN);
    dialog.setFilterNames (new String [] {
    		"DOSBox configuration files", "Executables, Booter Disk Images", "*.*"});
    dialog.setFilterExtensions (new String [] {"*.conf;*.CONF", 
    		"*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*.*"});
    String result = dialog.open();
    if (result != null) {
      doAddProfile(result);
    }
  }
}
