/* 
 * Created on 2-jul-2006 by ronald.blankendaal
 * 
 * @file $RCSfile: EditDosboxVersionDialog.java,v $
 * @version $Revision: 1.14 $ 
 * @author $Author: ronald $ (last checked in by) 
 * @date $Date: 2006/11/18 22:05:52 $ (UTC date of last check in)
 */

package com.gui;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import com.db.Database;
import com.model.DosboxVersion;
import com.util.FileUtils;
import com.util.PlatformUtils;
import swing2swt.layout.BorderLayout;


public class EditDosboxVersionDialog extends Dialog {

	private Text parameters;
	private Text path;
  private TabItem infoTabItem;
  private Text title;
  
  protected Shell shell;
  private Database db;
  protected Object result;
  
  /**
   * Create the dialog
   * @param parent
   */
  public EditDosboxVersionDialog(Shell parent) {
    super(parent, SWT.NONE);
  }

  public void setDosboxVersion(DosboxVersion dbversion) {
    this.result = dbversion;
  }

  /**
   * Open the dialog
   * @return the result
   */
  public Object open() {
  	db = Database.getInstance();
    createContents();
    shell.open();
    shell.layout();
    Display display = getParent().getDisplay();
    while (!shell.isDisposed()) {
      if (!display.readAndDispatch())
        display.sleep();
    }
    return result;
  }

  /**
   * Create contents of the dialog
   */
  protected void createContents() {
    shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
    shell.setLayout(new BorderLayout(0, 0));
    shell.setSize(610, 280);
    
    if (result != null) {
      // meaning we are essentially editing an existing dosbox version
      shell.setText("Edit Dosbox version " + ((DosboxVersion)result).getTitle() + " (" + ((DosboxVersion)result).getId() + ")");
    } else {
      shell.setText("Add Dosbox version");
    }

    final TabFolder tabFolder = new TabFolder(shell, SWT.NONE);

    infoTabItem = new TabItem(tabFolder, SWT.NONE);
    infoTabItem.setText("Info");

    final Composite composite = new Composite(tabFolder, SWT.NONE);
    final GridLayout gridLayout = new GridLayout();
    gridLayout.numColumns = 3;
    composite.setLayout(gridLayout);
    infoTabItem.setControl(composite);

    final Label titleLabel = new Label(composite, SWT.NONE);
    titleLabel.setText("Title");
    
    title = new Text(composite, SWT.BORDER);
    title.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(composite, SWT.NONE);
    
    final Label pathLabel = new Label(composite, SWT.NONE);
    pathLabel.setText("Path");

    path = new Text(composite, SWT.BORDER);
    path.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    
    final Button browseButton = new Button(composite, SWT.NONE);
    browseButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        DirectoryDialog dialog = new DirectoryDialog (shell);
        dialog.setFilterPath (path.getText());
        String result = dialog.open();
        if (result != null) {
          path.setText(result);
        }
      }
    });
    browseButton.setText("Browse..");

    final Label parametersLabel = new Label(composite, SWT.NONE);
    parametersLabel.setText("Parameters");

    parameters = new Text(composite, SWT.BORDER);
    parameters.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    new Label(composite, SWT.NONE);

    final Label multiconfSupportLabel = new Label(composite, SWT.NONE);
    multiconfSupportLabel.setText("Multiconf support");

    final Button multiconf = new Button(composite, SWT.CHECK);
    new Label(composite, SWT.NONE);
    
    final Label defaultLabel = new Label(composite, SWT.NONE);
    defaultLabel.setText("Default");

    final Button defaultButton = new Button(composite, SWT.CHECK);
    new Label(composite, SWT.NONE);

    final Composite composite_7 = new Composite(shell, SWT.NONE);
    composite_7.setLayout(new RowLayout());
    composite_7.setLayoutData(BorderLayout.SOUTH);

    final Button okButton = new Button(composite_7, SWT.NONE);
    shell.setDefaultButton(okButton);
    final RowData rowData = new RowData();
    rowData.width = 80;
    okButton.setLayoutData(rowData);
    okButton.setText("OK");
    okButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        if (!isValid())
          return;
				try {
					int dbversionId = db.addOrEditDosboxVersion(title.getText(), path.getText(),
							multiconf.getSelection(), defaultButton.getSelection(), parameters.getText(),
							result != null ? ((DosboxVersion)result).getId(): -1);
					result = new DosboxVersion(dbversionId, title.getText(), path.getText(),
              multiconf.getSelection(), defaultButton.getSelection(), parameters.getText());
				} catch (SQLException e1) {
					GeneralPurposeDialogs.warningMessage(shell, e1.getMessage());
				}
        shell.close();
      }
    });

    final Button cancelButton = new Button(composite_7, SWT.NONE);
    final RowData rowData_1 = new RowData();
    rowData_1.width = 80;
    cancelButton.setLayoutData(rowData_1);
    cancelButton.setText("Cancel");
    cancelButton.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(final SelectionEvent e) {
        result = null;
        shell.close();
      }
    });
    
    final Label label = new Label(composite, SWT.SEPARATOR | SWT.HORIZONTAL);
    label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 3, 1));
    new Label(composite, SWT.NONE);

    final Button editButton = new Button(composite, SWT.NONE);
    editButton.addSelectionListener(new SelectionAdapter() {
    	public void widgetSelected(final SelectionEvent e) {
    		if (!isValid())
    			return;
    		PlatformUtils.openForEditing(FileUtils.constructCanonicalDBConfLocation(path.getText()));
    	}
    });
    editButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
    editButton.setText("Edit configuration file using external editor");
    new Label(composite, SWT.NONE);
    
    // init values
    if (result != null) {
      // meaning we are essentially editing an existing dosbox version
      // so we need to set previous values
      title.setText(((DosboxVersion)result).getTitle());
      path.setText(((DosboxVersion)result).getPath());
      parameters.setText(((DosboxVersion)result).getParameters());
      defaultButton.setSelection(((DosboxVersion)result).isDefaultVersion());
      multiconf.setSelection(((DosboxVersion)result).isMultiConfig());
    }
    title.setFocus();
  }
  
  private boolean isValid() {
    GeneralPurposeDialogs.initErrorDialog();
    if (title.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter a dosbox version title", title);
    if (path.getText().equals(""))
      GeneralPurposeDialogs.addError("You must enter a path to the dosbox executable", path);
    if (!path.getText().endsWith(File.separator))
      path.setText(path.getText() + File.separatorChar);
    DosboxVersion dbversion = new DosboxVersion(-1, "", path.getText(), false, false, "");
    String executable = dbversion.getExecutable();
    String configFile = dbversion.getConfigFile();
    boolean exeAvailable = FileUtils.isExistingReadableFile(executable);
    if (!exeAvailable)
    	GeneralPurposeDialogs.addError("The dosbox executable \"" + executable + "\" is missing or unreadable", path);
    if (!FileUtils.isExistingReadableFile(configFile) && exeAvailable) {
    	if (GeneralPurposeDialogs.confirmMessage(shell, "The dosbox configuration file \"" +
    			configFile + "\" is missing or unreadable.\n\nWould you like to create a configuration " +
    			"file based on this dosbox version's internal defaults?")) {
    		try {
					FileUtils.doCreateDosboxConf(dbversion);
				} catch (IOException e) {
					GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
				}
    	}
    }
    if (!FileUtils.isExistingReadableFile(configFile))
    	GeneralPurposeDialogs.addError("The dosbox configuration file \"" +	configFile +
    			"\" is missing or unreadable", path);
    return !GeneralPurposeDialogs.displayErrorDialog(shell);
  }
}
